/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import java.net.URI;
import java.net.URISyntaxException;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.security.AttributeFinderModule;
import org.fcrepo.server.security.ContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextAttributeFinderModule
extends AttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(ContextAttributeFinderModule.class);
    private final ContextRegistry m_contexts;

    @Override
    protected boolean canHandleAdhoc() {
        return true;
    }

    private ContextAttributeFinderModule(ContextRegistry contexts) {
        this.m_contexts = contexts;
        try {
            this.registerSupportedDesignatorType(0);
            this.registerSupportedDesignatorType(2);
            this.registerSupportedDesignatorType(1);
            this.registerSupportedDesignatorType(3);
            this.registerAttribute(Constants.ENVIRONMENT.CURRENT_DATE_TIME.uri, Constants.ENVIRONMENT.CURRENT_DATE_TIME.datatype);
            this.registerAttribute(Constants.ENVIRONMENT.CURRENT_DATE.uri, Constants.ENVIRONMENT.CURRENT_DATE.datatype);
            this.registerAttribute(Constants.ENVIRONMENT.CURRENT_TIME.uri, Constants.ENVIRONMENT.CURRENT_TIME.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.PROTOCOL.uri, Constants.HTTP_REQUEST.PROTOCOL.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SCHEME.uri, Constants.HTTP_REQUEST.SCHEME.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SECURITY.uri, Constants.HTTP_REQUEST.SECURITY.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.AUTHTYPE.uri, Constants.HTTP_REQUEST.AUTHTYPE.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.METHOD.uri, Constants.HTTP_REQUEST.METHOD.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SESSION_ENCODING.uri, Constants.HTTP_REQUEST.SESSION_ENCODING.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SESSION_STATUS.uri, Constants.HTTP_REQUEST.SESSION_STATUS.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.CONTENT_LENGTH.uri, Constants.HTTP_REQUEST.CONTENT_LENGTH.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.CONTENT_TYPE.uri, Constants.HTTP_REQUEST.CONTENT_TYPE.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.CLIENT_FQDN.uri, Constants.HTTP_REQUEST.CLIENT_FQDN.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.CLIENT_IP_ADDRESS.uri, Constants.HTTP_REQUEST.CLIENT_IP_ADDRESS.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SERVER_FQDN.uri, Constants.HTTP_REQUEST.SERVER_FQDN.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SERVER_IP_ADDRESS.uri, Constants.HTTP_REQUEST.SERVER_IP_ADDRESS.datatype);
            this.registerAttribute(Constants.HTTP_REQUEST.SERVER_PORT.uri, Constants.HTTP_REQUEST.SERVER_PORT.datatype);
            this.attributesDenied.add("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
            this.attributesDenied.add("urn:oasis:names:tc:xacml:1.0:action:action-id");
            this.attributesDenied.add("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
            this.attributesDenied.add(Constants.ACTION.CONTEXT_ID.uri);
            this.attributesDenied.add(Constants.SUBJECT.LOGIN_ID.uri);
            this.attributesDenied.add(Constants.ACTION.ID.uri);
            this.attributesDenied.add(Constants.ACTION.API.uri);
            this.setInstantiatedOk(true);
        }
        catch (URISyntaxException e1) {
            this.setInstantiatedOk(false);
        }
    }

    private final String getContextId(EvaluationCtx context) {
        URI contextIdType = null;
        URI contextIdId = null;
        try {
            contextIdType = new URI("http://www.w3.org/2001/XMLSchema#string");
        }
        catch (URISyntaxException e) {
            logger.debug("ContextAttributeFinder:getContextId exit on couldn't make URI for contextId type");
        }
        try {
            contextIdId = new URI(Constants.ACTION.CONTEXT_ID.uri);
        }
        catch (URISyntaxException e) {
            logger.debug("ContextAttributeFinder:getContextId exit on couldn't make URI for contextId itself");
        }
        logger.debug("ContextAttributeFinder:findAttribute about to call getAttributeFromEvaluationCtx");
        EvaluationResult attribute = context.getActionAttribute(contextIdType, contextIdId, null);
        Object element = this.getAttributeFromEvaluationResult(attribute);
        if (element == null) {
            logger.debug("ContextAttributeFinder:getContextId exit on can't get contextId on request callback");
            return null;
        }
        if (!(element instanceof StringAttribute)) {
            logger.debug("ContextAttributeFinder:getContextId exit on couldn't get contextId from xacml request non-string returned");
            return null;
        }
        String contextId = ((StringAttribute)element).getValue();
        if (contextId == null) {
            logger.debug("ContextAttributeFinder:getContextId exit on null contextId");
            return null;
        }
        if (!this.validContextId(contextId)) {
            logger.debug("ContextAttributeFinder:getContextId exit on invalid context-id");
            return null;
        }
        return contextId;
    }

    private final boolean validContextId(String contextId) {
        if (contextId == null) {
            return false;
        }
        if ("".equals(contextId)) {
            return false;
        }
        return !" ".equals(contextId);
    }

    @Override
    protected final Object getAttributeLocally(int designatorType, String attributeId, URI resourceCategory, EvaluationCtx ctx) {
        logger.debug("getAttributeLocally context");
        String contextId = this.getContextId(ctx);
        logger.debug("contextId=" + contextId + " attributeId=" + attributeId);
        if (contextId == null || contextId.equals("")) {
            return null;
        }
        Context context = this.m_contexts.getContext(contextId);
        logger.debug("got context");
        String[] values = null;
        logger.debug("designatorType" + designatorType);
        block0 : switch (designatorType) {
            case 0: {
                if (0 > context.nSubjectValues(attributeId)) {
                    values = null;
                    break;
                }
                logger.debug("getting n values for " + attributeId + "=" + context.nSubjectValues(attributeId));
                switch (context.nSubjectValues(attributeId)) {
                    case 0: {
                        values = null;
                        break;
                    }
                    case 1: {
                        values = new String[]{context.getSubjectValue(attributeId)};
                        break;
                    }
                    default: {
                        values = context.getSubjectValues(attributeId);
                    }
                }
                if (!logger.isDebugEnabled()) break;
                if (values == null) {
                    logger.debug("RETURNING NO VALUES FOR " + attributeId);
                    break;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("RETURNING " + values.length + " VALUES FOR " + attributeId + " ==");
                for (int i = 0; i < values.length; ++i) {
                    sb.append(" " + values[i]);
                }
                logger.debug(sb.toString());
                break;
            }
            case 2: {
                if (0 > context.nActionValues(attributeId)) {
                    values = null;
                    break;
                }
                switch (context.nActionValues(attributeId)) {
                    case 0: {
                        values = null;
                        break block0;
                    }
                    case 1: {
                        values = new String[]{context.getActionValue(attributeId)};
                        break block0;
                    }
                }
                values = context.getActionValues(attributeId);
                break;
            }
            case 1: {
                if (0 > context.nResourceValues(attributeId)) {
                    values = null;
                    break;
                }
                switch (context.nResourceValues(attributeId)) {
                    case 0: {
                        values = null;
                        break block0;
                    }
                    case 1: {
                        values = new String[]{context.getResourceValue(attributeId)};
                        break block0;
                    }
                }
                values = context.getResourceValues(attributeId);
                break;
            }
            case 3: {
                if (0 > context.nEnvironmentValues(attributeId)) {
                    values = null;
                    break;
                }
                switch (context.nEnvironmentValues(attributeId)) {
                    case 0: {
                        values = null;
                        break block0;
                    }
                    case 1: {
                        values = new String[]{context.getEnvironmentValue(attributeId)};
                        break block0;
                    }
                }
                values = context.getEnvironmentValues(attributeId);
                break;
            }
        }
        if (values instanceof String) {
            logger.debug("getAttributeLocally string value=" + (String)values);
        } else if (values instanceof String[]) {
            logger.debug("getAttributeLocally string values={}", values);
            for (int i = 0; i < values.length; ++i) {
                logger.debug("another string value={}", (Object)values[i]);
            }
        } else {
            logger.debug("getAttributeLocally object value={}", values);
        }
        return values;
    }
}

