/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.BackendSecurityParserException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.security.BackendSecurity;
import org.fcrepo.server.security.BackendSecurityDeserializer;
import org.fcrepo.server.security.BackendSecuritySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBackendSecurity
extends Module
implements BackendSecurity {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBackendSecurity.class);
    public static BackendSecuritySpec beSS = null;
    private boolean m_validate = false;
    private String m_encoding = null;
    private static String m_beSecurityPath = null;

    public DefaultBackendSecurity(Map moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        try {
            Server s_server = this.getServer();
            logger.debug("DefaultBackendSecurity initialized");
            String fedoraHome = Constants.FEDORA_HOME;
            if (fedoraHome == null) {
                throw new ModuleInitializationException("[DefaultBackendSecurity] Module failed to initialize: FEDORA_HOME is undefined", this.getRole());
            }
            m_beSecurityPath = fedoraHome + "/server/config/beSecurity.xml";
            logger.debug("m_beSecurityPath: " + m_beSecurityPath);
            String validate = this.getParameter("beSecurity_validation");
            if (validate != null) {
                if (!validate.equals("true") && !validate.equals("false")) {
                    logger.warn("Validation setting for backend security configuration file must be either \"true\" or \"false\". Value specified was: \"" + validate + "\". Validation is defaulted to " + "\"false\".");
                } else {
                    this.m_validate = new Boolean(validate);
                }
            } else {
                logger.warn("Validation setting for backend security configuration file was not specified. Validation is defaulted to \"false\".");
            }
            logger.debug("beSecurity_validate: " + this.m_validate);
            this.m_encoding = this.getParameter("beSecurity_char_encoding");
            if (this.m_encoding == null) {
                this.m_encoding = "utf-8";
                logger.warn("Character encoding for backend security configuration file was not specified. Encoding defaulted to \"utf-8\".");
            }
            logger.debug("beSecurity_char_encoding: " + this.m_encoding);
            this.setBackendSecuritySpec();
            if (logger.isDebugEnabled()) {
                Set<String> roleList = beSS.listRoleKeys();
                Iterator<String> iter = roleList.iterator();
                while (iter.hasNext()) {
                    logger.debug("beSecurity ROLE: " + iter.next());
                }
            }
        }
        catch (Throwable th) {
            throw new ModuleInitializationException("[DefaultBackendSecurity] BackendSecurity could not be instantiated. The underlying error was a " + th.getClass().getName() + "The message was \"" + th.getMessage() + "\".", this.getRole());
        }
    }

    @Override
    public BackendSecuritySpec parseBeSecurity() throws BackendSecurityParserException {
        try {
            BackendSecurityDeserializer bsd = new BackendSecurityDeserializer(this.m_encoding, this.m_validate);
            return bsd.deserialize(m_beSecurityPath);
        }
        catch (Throwable th) {
            throw new BackendSecurityParserException("[DefaultBackendSecurity] An error has occured in parsing the backend security configuration file located at \"" + m_beSecurityPath + "\". " + "The underlying error was a " + th.getClass().getName() + "The message was \"" + th.getMessage() + "\".");
        }
    }

    @Override
    public BackendSecuritySpec getBackendSecuritySpec() {
        return beSS;
    }

    @Override
    public void setBackendSecuritySpec() throws BackendSecurityParserException {
        beSS = this.parseBeSecurity();
    }

    @Override
    public BackendSecuritySpec reloadBeSecurity() throws BackendSecurityParserException {
        return this.parseBeSecurity();
    }
}

