/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import com.sun.xacml.EvaluationCtx;
import java.net.URI;
import java.net.URISyntaxException;
import org.fcrepo.common.Constants;
import org.fcrepo.server.security.AttributeFinderModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestAttributeFinderModule
extends AttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(TestAttributeFinderModule.class);
    public static final String ATTRIBUTE_ID = Constants.ENVIRONMENT.uri + ":springConfigured";
    public static final String ATTRIBUTE_VALUE = "demo:5";
    private static final TestAttributeFinderModule singleton = new TestAttributeFinderModule();

    @Override
    protected boolean canHandleAdhoc() {
        return true;
    }

    private TestAttributeFinderModule() {
        try {
            this.registerSupportedDesignatorType(3);
            this.registerAttribute(ATTRIBUTE_ID, "http://www.w3.org/2001/XMLSchema#string");
            this.attributesDenied.add("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
            this.attributesDenied.add("urn:oasis:names:tc:xacml:1.0:action:action-id");
            this.attributesDenied.add("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
            this.attributesDenied.add(Constants.ACTION.CONTEXT_ID.uri);
            this.attributesDenied.add(Constants.SUBJECT.LOGIN_ID.uri);
            this.attributesDenied.add(Constants.ACTION.ID.uri);
            this.attributesDenied.add(Constants.ACTION.API.uri);
            this.setInstantiatedOk(true);
        }
        catch (URISyntaxException e1) {
            this.setInstantiatedOk(false);
        }
    }

    public static final TestAttributeFinderModule getInstance() {
        return singleton;
    }

    @Override
    protected final Object getAttributeLocally(int designatorType, String attributeId, URI resourceCategory, EvaluationCtx ctx) {
        logger.debug("getAttributeLocally test");
        logger.debug("TestAttributeFinderModule attributeId=" + attributeId);
        String values = null;
        logger.debug("designatorType" + designatorType);
        values = designatorType == 3 ? (ATTRIBUTE_ID.equals(attributeId) ? ATTRIBUTE_VALUE : null) : null;
        if (values instanceof String) {
            logger.debug("getAttributeLocally string value=" + values);
        } else {
            logger.debug("getAttributeLocally object value=" + values);
        }
        return values;
    }
}

