/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.impl;

import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Subject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.security.PolicyEnforcementPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicyEnforcementPoint
implements PolicyEnforcementPoint {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPolicyEnforcementPoint.class);
    static final URI XACML_SUBJECT_ID_URI = AbstractPolicyEnforcementPoint.getSafeURI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
    static final URI XACML_ACTION_ID_URI = AbstractPolicyEnforcementPoint.getSafeURI("urn:oasis:names:tc:xacml:1.0:action:action-id");
    static final URI XACML_RESOURCE_ID_URI = AbstractPolicyEnforcementPoint.getSafeURI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
    static final URI SUBJECT_ID_URI = AbstractPolicyEnforcementPoint.getSafeURI(Constants.SUBJECT.LOGIN_ID.uri);
    static final URI ACTION_ID_URI = AbstractPolicyEnforcementPoint.getSafeURI(Constants.ACTION.ID.uri);
    static final URI ACTION_API_URI = AbstractPolicyEnforcementPoint.getSafeURI(Constants.ACTION.API.uri);
    static final URI ACTION_CONTEXT_URI = AbstractPolicyEnforcementPoint.getSafeURI(Constants.ACTION.CONTEXT_ID.uri);
    static final URI RESOURCE_ID_URI = AbstractPolicyEnforcementPoint.getSafeURI(Constants.OBJECT.PID.uri);
    static final URI RESOURCE_NAMESPACE_URI = AbstractPolicyEnforcementPoint.getSafeURI(Constants.OBJECT.NAMESPACE.uri);
    protected final PDPConfig m_pdpConfig;
    protected PDP m_pdp;

    private static URI getSafeURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            logger.error("Bad URI syntax: " + uri, (Throwable)e);
            return null;
        }
    }

    public AbstractPolicyEnforcementPoint(PDPConfig pdpConfig) {
        this.m_pdpConfig = pdpConfig;
    }

    public void init() throws GeneralException {
        this.newPdp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void newPdp() {
        PDP pdp = new PDP(this.m_pdpConfig);
        AbstractPolicyEnforcementPoint abstractPolicyEnforcementPoint = this;
        synchronized (abstractPolicyEnforcementPoint) {
            this.m_pdp = pdp;
        }
    }

    @Override
    public void inactivate() {
        this.destroy();
    }

    @Override
    public void destroy() {
        this.m_pdp = null;
    }

    protected Set<Subject> wrapSubjects(String subjectLoginId) {
        logger.debug("wrapSubjectIdAsSubjects(): " + subjectLoginId);
        StringAttribute stringAttribute = new StringAttribute("");
        Attribute subjectAttribute = new Attribute(XACML_SUBJECT_ID_URI, null, null, (AttributeValue)stringAttribute);
        logger.debug("wrapSubjectIdAsSubjects(): subjectAttribute, id=" + subjectAttribute.getId() + ", type=" + subjectAttribute.getType() + ", value=" + subjectAttribute.getValue());
        HashSet<Attribute> subjectAttributes = new HashSet<Attribute>();
        subjectAttributes.add(subjectAttribute);
        if (subjectLoginId != null && !"".equals(subjectLoginId)) {
            stringAttribute = new StringAttribute(subjectLoginId);
            subjectAttribute = new Attribute(SUBJECT_ID_URI, null, null, (AttributeValue)stringAttribute);
            logger.debug("wrapSubjectIdAsSubjects(): subjectAttribute, id=" + subjectAttribute.getId() + ", type=" + subjectAttribute.getType() + ", value=" + subjectAttribute.getValue());
        }
        subjectAttributes.add(subjectAttribute);
        Subject singleSubject = new Subject(subjectAttributes);
        HashSet<Subject> subjects = new HashSet<Subject>();
        subjects.add(singleSubject);
        return subjects;
    }

    protected Set<Attribute> wrapActions(String actionId, String actionApi, String contextIndex) {
        HashSet<Attribute> actions = new HashSet<Attribute>();
        Attribute action = new Attribute(XACML_ACTION_ID_URI, null, null, (AttributeValue)new StringAttribute(""));
        actions.add(action);
        action = new Attribute(ACTION_ID_URI, null, null, (AttributeValue)new StringAttribute(actionId));
        actions.add(action);
        action = new Attribute(ACTION_API_URI, null, null, (AttributeValue)new StringAttribute(actionApi));
        actions.add(action);
        action = new Attribute(ACTION_CONTEXT_URI, null, null, (AttributeValue)new StringAttribute(contextIndex));
        actions.add(action);
        return actions;
    }

    protected Set<Attribute> wrapResources(String pid, String namespace) throws AuthzOperationalException {
        HashSet<Attribute> resources = new HashSet<Attribute>();
        Attribute attribute = null;
        attribute = new Attribute(XACML_RESOURCE_ID_URI, null, null, (AttributeValue)new StringAttribute(""));
        resources.add(attribute);
        attribute = new Attribute(RESOURCE_ID_URI, null, null, (AttributeValue)new StringAttribute(pid));
        resources.add(attribute);
        attribute = new Attribute(RESOURCE_NAMESPACE_URI, null, null, (AttributeValue)new StringAttribute(namespace));
        resources.add(attribute);
        return resources;
    }

    protected static final boolean denyBiasedAuthz(Set set) {
        int nPermits = 0;
        int nDenies = 0;
        int nNotApplicables = 0;
        int nIndeterminates = 0;
        int nWrongs = 0;
        block6: for (Result result : set) {
            int decision = result.getDecision();
            switch (decision) {
                case 0: {
                    ++nPermits;
                    continue block6;
                }
                case 1: {
                    ++nDenies;
                    continue block6;
                }
                case 2: {
                    ++nIndeterminates;
                    continue block6;
                }
                case 3: {
                    ++nNotApplicables;
                    continue block6;
                }
            }
            ++nWrongs;
        }
        logger.debug("AUTHZ:  permits=" + nPermits + " denies=" + nDenies + " indeterminates=" + nIndeterminates + " notApplicables=" + nNotApplicables + " unexpecteds=" + nWrongs);
        return nPermits >= 1 && nDenies == 0 && nIndeterminates == 0 && nWrongs == 0;
    }
}

