/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.impl;

import com.sun.xacml.PDPConfig;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Subject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.Context;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.authorization.AuthzDeniedException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.errors.authorization.AuthzPermittedException;
import org.fcrepo.server.security.ContextRegistry;
import org.fcrepo.server.security.PolicyEnforcementPoint;
import org.fcrepo.server.security.impl.AbstractPolicyEnforcementPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyEnforcementPoint
extends AbstractPolicyEnforcementPoint
implements PolicyEnforcementPoint {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPolicyEnforcementPoint.class);
    private static final String ROLE = PolicyEnforcementPoint.class.getName();
    private static final String ENFORCE_MODE_CONFIG_KEY = "ENFORCE-MODE";
    static final String ENFORCE_MODE_ENFORCE_POLICIES = "enforce-policies";
    static final String ENFORCE_MODE_PERMIT_ALL_REQUESTS = "permit-all-requests";
    static final String ENFORCE_MODE_DENY_ALL_REQUESTS = "deny-all-requests";
    private final ContextRegistry m_registry;
    private String m_enforceMode = "enforce-policies";
    private int n = 0;

    public DefaultPolicyEnforcementPoint(PDPConfig pdpConfig, ContextRegistry registry, ModuleConfiguration authzConfiguration) throws ModuleInitializationException {
        super(pdpConfig);
        this.m_registry = registry;
        Map<String, String> moduleParameters = authzConfiguration.getParameters();
        if (moduleParameters.containsKey(ENFORCE_MODE_CONFIG_KEY)) {
            this.m_enforceMode = moduleParameters.get(ENFORCE_MODE_CONFIG_KEY);
            if (!(ENFORCE_MODE_ENFORCE_POLICIES.equals(this.m_enforceMode) || ENFORCE_MODE_PERMIT_ALL_REQUESTS.equals(this.m_enforceMode) || ENFORCE_MODE_DENY_ALL_REQUESTS.equals(this.m_enforceMode))) {
                throw new ModuleInitializationException("invalid enforceMode from config \"" + this.m_enforceMode + "\"", ROLE);
            }
        }
    }

    private synchronized int next() {
        return this.n++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enforce(String subjectId, String action, String api, String pid, String namespace, Context context) throws AuthzException {
        long enforceStartTime = System.currentTimeMillis();
        try {
            DefaultPolicyEnforcementPoint defaultPolicyEnforcementPoint = this;
            synchronized (defaultPolicyEnforcementPoint) {
            }
            if (ENFORCE_MODE_PERMIT_ALL_REQUESTS.equals(this.m_enforceMode)) {
                logger.debug("permitting request because enforceMode==ENFORCE_MODE_PERMIT_ALL_REQUESTS");
            } else {
                if (ENFORCE_MODE_DENY_ALL_REQUESTS.equals(this.m_enforceMode)) {
                    logger.debug("denying request because enforceMode==ENFORCE_MODE_DENY_ALL_REQUESTS");
                    throw new AuthzDeniedException("all requests are currently denied");
                }
                if (!ENFORCE_MODE_ENFORCE_POLICIES.equals(this.m_enforceMode)) {
                    logger.debug("denying request because enforceMode is invalid");
                    throw new AuthzOperationalException("invalid enforceMode from config \"" + this.m_enforceMode + "\"");
                }
                ResponseCtx response = null;
                String contextIndex = null;
                try {
                    contextIndex = new Integer(this.next()).toString();
                    logger.debug("context index set={}", (Object)contextIndex);
                    Set<Subject> subjects = this.wrapSubjects(subjectId);
                    Set<Attribute> actions = this.wrapActions(action, api, contextIndex);
                    Set<Attribute> resources = this.wrapResources(pid, namespace);
                    RequestCtx request = new RequestCtx(subjects, resources, actions, Collections.EMPTY_SET);
                    for (Attribute tempobj : actions) {
                        logger.debug("request action has {}={}", (Object)tempobj.getId(), (Object)tempobj.getValue().toString());
                    }
                    this.m_registry.registerContext(contextIndex, context);
                    long st = System.currentTimeMillis();
                    try {
                        response = this.m_pdp.evaluate(request);
                    }
                    finally {
                        long dur = System.currentTimeMillis() - st;
                        logger.debug("Policy evaluation took {}ms.", (Object)dur);
                    }
                    logger.debug("in pep, after evaluate() called");
                    this.m_registry.unregisterContext(contextIndex);
                }
                catch (Throwable t) {
                    try {
                        logger.error("Error evaluating policy", t);
                        throw new AuthzOperationalException("");
                    }
                    catch (Throwable throwable) {
                        this.m_registry.unregisterContext(contextIndex);
                        throw throwable;
                    }
                }
                logger.debug("in pep, before denyBiasedAuthz() called");
                if (!DefaultPolicyEnforcementPoint.denyBiasedAuthz(response.getResults())) {
                    throw new AuthzDeniedException("");
                }
            }
            if (context.getNoOp()) {
                throw new AuthzPermittedException("noOp");
            }
        }
        finally {
            long dur = System.currentTimeMillis() - enforceStartTime;
            logger.debug("Policy enforcement took {}ms.", (Object)dur);
        }
    }
}

