/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.impl;

import com.sun.xacml.AbstractPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.PolicyLoader;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.storage.RepositoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverridingPolicyLoader
extends PolicyLoader {
    private static final Logger logger = LoggerFactory.getLogger(OverridingPolicyLoader.class);
    private Strategy m_override = Strategy.ID;

    public OverridingPolicyLoader(RepositoryReader repoReader) {
        super(repoReader);
    }

    public void setOverride(Strategy override) {
        this.m_override = override;
    }

    @Override
    public Map<String, AbstractPolicy> loadPolicies(PolicyParser policyParser, boolean validate, File dir) throws IOException, ValidationException {
        HashMap<String, AbstractPolicy> policies = new HashMap<String, AbstractPolicy>();
        File defaultDir = new File(dir, "default");
        if (defaultDir.exists()) {
            policies.putAll(this.loadPolicies(policyParser, validate, defaultDir));
        }
        for (File file : dir.listFiles()) {
            if (file.getName().equals("default")) continue;
            if (file.isDirectory()) {
                policies.putAll(this.loadPolicies(policyParser, validate, file));
                continue;
            }
            if (!file.getName().endsWith(".xml")) continue;
            logger.info("Loading policy: {}", (Object)file.getPath());
            FileInputStream policyStream = new FileInputStream(file);
            AbstractPolicy policy = policyParser.parse(policyStream, validate);
            logger.info("Loaded policy ID: {}", (Object)policy.getId());
            String key = null;
            key = this.m_override == Strategy.FILENAME ? file.getName() : policy.getId().toString();
            policies.put(key, policy);
        }
        return policies;
    }

    public static enum Strategy {
        FILENAME,
        ID;

    }
}

