/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.impl;

import com.sun.xacml.AbstractPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.PolicyLoader;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.storage.RepositoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePolicyLoader
extends PolicyLoader {
    private static final Logger logger = LoggerFactory.getLogger(SimplePolicyLoader.class);

    public SimplePolicyLoader(RepositoryReader repoReader) {
        super(repoReader);
    }

    @Override
    public Map<String, AbstractPolicy> loadPolicies(PolicyParser policyParser, boolean validate, File dir) throws IOException, ValidationException {
        HashMap<String, AbstractPolicy> policies = new HashMap<String, AbstractPolicy>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                policies.putAll(this.loadPolicies(policyParser, validate, file));
                continue;
            }
            if (!file.getName().endsWith(".xml")) continue;
            logger.info("Loading policy: {}", (Object)file.getPath());
            FileInputStream policyStream = new FileInputStream(file);
            policies.put(file.getPath(), policyParser.parse(policyStream, validate));
        }
        return policies;
    }
}

