/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base {
    private static final Logger logger = LoggerFactory.getLogger(Base.class);
    protected static final String[] StringArrayPrototype = new String[0];
    private static final String INTO = " . . .";
    private static final String OUTOF = ". . . ";
    protected boolean initErrors = false;

    protected String getClassName() {
        String classname = this.getClass().getName();
        String[] parts = classname.split("\\.");
        if (parts.length > 0) {
            classname = parts[parts.length - 1];
        }
        return classname;
    }

    public final String enter(String method) {
        return this.getClassName() + "." + method + " " + INTO;
    }

    public final String exit(String method) {
        return this.getClassName() + "." + OUTOF + " " + method;
    }

    public final String enterExit(String method) {
        return this.getClassName() + "." + OUTOF + method + INTO;
    }

    public final String passFail(String method, String test, String result) {
        return this.getClassName() + "." + method + ": " + result + " " + test + " test";
    }

    public final String pass(String method, String test) {
        return this.passFail(method, test, "passed");
    }

    public final String fail(String method, String test) {
        return this.passFail(method, test, "failed");
    }

    public final String format(String method, String msg) {
        return this.getClassName() + "." + method + ": " + msg;
    }

    public final String format(String method, String msg, String name) {
        return this.format(method, msg, name, null);
    }

    public final String format(String method, String msg, String name, String value) {
        return this.getClassName() + "." + method + ": " + (msg == null ? "" : msg + " ") + name + "==" + (value == null ? "" : value);
    }

    public static final boolean booleanValue(String string) throws Exception {
        if (Boolean.TRUE.toString().equals(string) || Boolean.FALSE.toString().equals(string)) {
            return new Boolean(string);
        }
        throw new Exception("does not represent a boolean");
    }

    protected void initThisSubclass(String key, String value) {
        logger.debug("AFB.iTS");
        String method = "initThisSubclass() ";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        this.initErrors = true;
        if (logger.isErrorEnabled()) {
            logger.error(this.format(method, "unknown parameter", key, value));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }
}

