/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.FilterConfig;
import org.fcrepo.server.security.servletfilters.BaseContributing;
import org.fcrepo.server.security.servletfilters.Cache;
import org.fcrepo.server.security.servletfilters.CacheElement;
import org.fcrepo.server.security.servletfilters.CacheElementPopulator;
import org.fcrepo.server.security.servletfilters.ExtendedHttpServletRequest;
import org.fcrepo.server.security.servletfilters.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCaching
extends BaseContributing
implements CacheElementPopulator {
    private static final Logger logger = LoggerFactory.getLogger(BaseCaching.class);
    private static final Map superCache = new Hashtable();
    protected boolean SPONSORING = false;
    public static final String LOOKUP_SUCCESS_TIMEOUT_UNIT_KEY = "lookup-success-timeout-unit";
    public static final String LOOKUP_SUCCESS_TIMEOUT_DURATION_KEY = "lookup-success-timeout-duration";
    public static final String AUTHN_FAILURE_TIMEOUT_UNIT_KEY = "authn-failure-timeout-unit";
    public static final String AUTHN_FAILURE_TIMEOUT_DURATION_KEY = "authn-failure-timeout-duration";
    public static final String LOOKUP_EXCEPTION_TIMEOUT_UNIT_KEY = "lookup-exception-timeout-unit";
    public static final String LOOKUP_EXCEPTION_TIMEOUT_DURATION_KEY = "lookup-exception-timeout-duration";
    private final String LOOKUP_SUCCESS_TIMEOUT_UNIT_DEFAULT = "MINUTE";
    private final int LOOKUP_SUCCESS_TIMEOUT_DURATION_DEFAULT = 10;
    private final String AUTHN_FAILURE_TIMEOUT_UNIT_DEFAULT = "SECOND";
    private final int AUTHN_FAILURE_TIMEOUT_DURATION_DEFAULT = 1;
    private final String LOOKUP_EXCEPTION_TIMEOUT_UNIT_DEFAULT = "SECOND";
    private final int LOOKUP_EXCEPTION_TIMEOUT_DURATION_DEFAULT = 1;
    private String LOOKUP_SUCCESS_TIMEOUT_UNIT = "MINUTE";
    private int LOOKUP_SUCCESS_TIMEOUT_DURATION = 10;
    private String AUTHN_FAILURE_TIMEOUT_UNIT = "SECOND";
    private int AUTHN_FAILURE_TIMEOUT_DURATION = 1;
    private String LOOKUP_EXCEPTION_TIMEOUT_UNIT = "SECOND";
    private int LOOKUP_EXCEPTION_TIMEOUT_DURATION = 1;
    public String AUTHENTICATE_KEY = "authenticate";
    public String AUTHENTICATED_USER_KEY = "associated-filters";
    public String SPONSORED_USER_KEY = "surrogate-associated-filters";

    protected final Cache getCache(String filterName) {
        String method = "getCache()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enterExit(method));
        }
        return (Cache)superCache.get(filterName);
    }

    private final void putCache(String filterName, Cache cache) {
        String method = "putCache()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enterExit(method));
        }
        superCache.put(filterName, cache);
    }

    @Override
    public void init(FilterConfig filterConfig) {
        Cache cache;
        String method = "init()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.init(filterConfig);
        this.inited = false;
        if (!this.initErrors && (cache = this.getCache(this.FILTER_NAME)) == null) {
            cache = this.getNewCache();
            this.putCache(this.FILTER_NAME, cache);
        }
        if (this.initErrors) {
            logger.error(this.format(method, "cache not set up correctly; see previous error"));
        }
        this.inited = true;
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    public void destroy() {
        String method = "destroy()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.destroy();
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    protected Cache getNewCache() {
        String method = "getNewCache()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        Cache cache = new Cache(this.FILTER_NAME, "", this.LOOKUP_SUCCESS_TIMEOUT_UNIT, this.LOOKUP_SUCCESS_TIMEOUT_DURATION, this.AUTHN_FAILURE_TIMEOUT_UNIT, this.AUTHN_FAILURE_TIMEOUT_DURATION, this.LOOKUP_EXCEPTION_TIMEOUT_UNIT, this.LOOKUP_EXCEPTION_TIMEOUT_DURATION, this);
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
        return cache;
    }

    @Override
    protected void initThisSubclass(String key, String value) {
        String method = "initThisSubclass()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        boolean setLocally = false;
        if (LOOKUP_SUCCESS_TIMEOUT_UNIT_KEY.equals(key)) {
            this.LOOKUP_SUCCESS_TIMEOUT_UNIT = value;
            setLocally = true;
        } else if (LOOKUP_SUCCESS_TIMEOUT_DURATION_KEY.equals(key)) {
            this.LOOKUP_SUCCESS_TIMEOUT_DURATION = Integer.parseInt(value);
            setLocally = true;
        } else if (AUTHN_FAILURE_TIMEOUT_UNIT_KEY.equals(key)) {
            this.AUTHN_FAILURE_TIMEOUT_UNIT = value;
            setLocally = true;
        } else if (AUTHN_FAILURE_TIMEOUT_DURATION_KEY.equals(key)) {
            this.AUTHN_FAILURE_TIMEOUT_DURATION = Integer.parseInt(value);
            setLocally = true;
        } else if (LOOKUP_EXCEPTION_TIMEOUT_UNIT_KEY.equals(key)) {
            this.LOOKUP_EXCEPTION_TIMEOUT_UNIT = value;
            setLocally = true;
        } else if (LOOKUP_EXCEPTION_TIMEOUT_DURATION_KEY.equals(key)) {
            this.LOOKUP_EXCEPTION_TIMEOUT_DURATION = Integer.parseInt(value);
            setLocally = true;
        } else if (this.AUTHENTICATE_KEY.equals(key)) {
            try {
                this.AUTHENTICATE = BaseCaching.booleanValue(value);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error(this.format(method, "known parameter, bad value", key, value));
                }
                this.initErrors = true;
            }
            setLocally = true;
        } else if (this.AUTHENTICATED_USER_KEY.equals(key)) {
            String[] temp = value.split(",");
            this.FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES = new Vector(temp.length);
            for (String element : temp) {
                this.FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES.add(element);
            }
            setLocally = true;
        } else if (this.SPONSORED_USER_KEY.equals(key)) {
            logger.error(this.format(method, null, "\"SPONSORED_USER_KEY\"", this.SPONSORED_USER_KEY));
            logger.error(this.format(method, null, "other filters associated with this filter for surrogates", value));
            String[] temp = value.split(",");
            this.FILTERS_CONTRIBUTING_SPONSORED_ATTRIBUTES = new Vector(temp.length);
            for (String element : temp) {
                logger.error(this.format(method, null, "adding", element));
                this.FILTERS_CONTRIBUTING_SPONSORED_ATTRIBUTES.add(element);
            }
            setLocally = true;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, "deferring to super"));
            }
            super.initThisSubclass(key, value);
        }
        if (setLocally && logger.isInfoEnabled()) {
            logger.info(this.format(method, "known parameter", key, value));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    protected boolean authenticate(boolean alreadyAuthenticated) {
        boolean authenticate = this.AUTHENTICATE && !alreadyAuthenticated;
        return authenticate;
    }

    @Override
    public void authenticate(ExtendedHttpServletRequest extendedHttpServletRequest) throws Exception {
        String method = "authenticate()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        try {
            String userid = extendedHttpServletRequest.getUser();
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, null, "userid", userid));
            }
            boolean authenticated = false;
            if (userid != null && !"".equals(userid)) {
                Boolean result;
                String password = extendedHttpServletRequest.getPassword();
                if (logger.isDebugEnabled()) {
                    logger.debug(this.format(method, null, "password", password));
                }
                Cache cache = this.getCache(this.FILTER_NAME);
                if (logger.isDebugEnabled()) {
                    logger.debug(this.format(method, "calling cache.authenticate()"));
                }
                boolean bl = authenticated = (result = cache.authenticate(this, userid, password)) != null && result != false;
                if (authenticated) {
                    Principal authenticatingPrincipal = new Principal(userid);
                    extendedHttpServletRequest.setAuthenticated(authenticatingPrincipal, this.FILTER_NAME);
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "set authenticated"));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(this.format(method, "calling audit", "user", userid));
                }
                cache.audit(userid);
            }
        }
        catch (Throwable th) {
            logger.error("Error authenticating", th);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    public void contributeAttributes(ExtendedHttpServletRequest extendedHttpServletRequest, String userid, String password) throws Exception {
        String method = "gatherAttributes()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        if (!extendedHttpServletRequest.isAuthenticated()) {
            throw new Exception();
        }
        try {
            Cache cache = this.getCache(this.FILTER_NAME);
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, "calling cache.getNamedValues()"));
            }
            Map namedValues = cache.getNamedValues(this, userid, password);
            extendedHttpServletRequest.addAttributes(this.FILTER_NAME, namedValues);
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, "gatherAttributes calling audit"));
            }
            cache.audit(userid);
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, "at end of gatherAttributes"));
            }
        }
        catch (Throwable th) {
            logger.error("Error conributing attributes", th);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    public void contributeAuthenticatedAttributes(ExtendedHttpServletRequest extendedHttpServletRequest) throws Exception {
        String method = "gatherAuthenticatedAttributes()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        if (extendedHttpServletRequest.getUserPrincipal() != null) {
            String userid = extendedHttpServletRequest.getUser();
            String password = extendedHttpServletRequest.getPassword();
            this.contributeAttributes(extendedHttpServletRequest, userid, password);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    public void contributeSponsoredAttributes(ExtendedHttpServletRequest extendedHttpServletRequest) throws Exception {
        String sponsoredUser;
        String method = "gatherSponsoredAttributes()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        if ((sponsoredUser = extendedHttpServletRequest.getFromHeader()) != null && !"".equals(sponsoredUser)) {
            String password = "";
            this.contributeAttributes(extendedHttpServletRequest, sponsoredUser, password);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    public void populateCacheElement(CacheElement cacheElement, String password) {
        String method = "populateCacheElement()";
        if (logger.isWarnEnabled()) {
            logger.warn(this.format(method, "must implement this method in filter subclass"));
        }
    }
}

