/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.server.security.servletfilters.Base;
import org.fcrepo.server.security.servletfilters.ExtendedHttpServletRequest;
import org.fcrepo.server.security.servletfilters.FilterSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContributing
extends FilterSetup {
    private static final Logger logger = LoggerFactory.getLogger(BaseContributing.class);
    public static final HashSet NULL_SET = new HashSet();
    public static final Hashtable EMPTY_MAP = new Hashtable();
    public static final String[] EMPTY_ARRAY = new String[0];
    private static boolean AUTHENTICATE_DEFAULT = true;
    private static Collection FILTERS_CONTRIBUTING_SPONSORED_ATTRIBUTES_DEFAULT = NULL_SET;
    protected boolean AUTHENTICATE = AUTHENTICATE_DEFAULT;
    protected Collection FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES = NULL_SET;
    protected Collection FILTERS_CONTRIBUTING_SPONSORED_ATTRIBUTES = FILTERS_CONTRIBUTING_SPONSORED_ATTRIBUTES_DEFAULT;
    public static final String SURROGATE_ROLE_KEY = "surrogate-role";
    private static String SURROGATE_ROLE_DEFAULT = null;
    protected String SURROGATE_ROLE = SURROGATE_ROLE_DEFAULT;
    public static final String SURROGATE_ATTRIBUTE_KEY = "surrogate-attribute";
    private static String SURROGATE_ATTRIBUTE_DEFAULT = null;
    protected String SURROGATE_ATTRIBUTE = SURROGATE_ATTRIBUTE_DEFAULT;
    public static final String USE_FILTER = "use-filter";
    public static final String SKIP_FILTER = "skip-filter";
    public static final String UNAUTHENTICATE_USER_UNCONDITIONALLY = "unauthenticate-user-unconditionally";
    public static final String UNAUTHENTICATE_USER_CONDITIONALLY = "unauthenticate-user-conditionally";
    public static final String PW_NULL_KEY = "null-password";
    private static String PW_NULL_DEFAULT = "use-filter";
    public String PW_NULL = PW_NULL_DEFAULT;
    public static final String PW_0_KEY = "zerolength-password";
    private static String PW_0_DEFAULT = "use-filter";
    public String PW_0 = PW_0_DEFAULT;
    public static final String EMPTY_RESULTS_KEY = "empty-results";
    private static String EMPTY_RESULTS_DEFAULT = "unauthenticate-user-conditionally";
    public String EMPTY_RESULTS = EMPTY_RESULTS_DEFAULT;
    public static final String LOG_STACK_TRACES_KEY = "log-stack-traces";
    private static boolean LOG_STACK_TRACES_DEFAULT = false;
    protected boolean LOG_STACK_TRACES = LOG_STACK_TRACES_DEFAULT;

    @Override
    public void init(FilterConfig filterConfig) {
        String method = "init() ";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.init(filterConfig);
        this.inited = false;
        if (!this.initErrors && this.FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES.isEmpty()) {
            if (this.FILTER_NAME == null || "".equals(this.FILTER_NAME)) {
                this.initErrors = true;
                if (logger.isErrorEnabled()) {
                    logger.error(this.format(method, "FILTER_NAME not set"));
                }
            } else {
                this.FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES = new Vector(1);
                this.FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES.add(this.FILTER_NAME);
            }
        }
        if (this.initErrors && logger.isErrorEnabled()) {
            logger.error(this.format(method, "FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES not set; see previous error"));
        }
        this.inited = true;
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    public void destroy() {
        String method = "destroy()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.destroy();
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    protected void initThisSubclass(String key, String value) {
        String m = "initThisSubclass() ";
        logger.debug(m + ">");
        if (SURROGATE_ROLE_KEY.equals(key)) {
            this.SURROGATE_ROLE = value;
            logger.info(m + key + "==" + this.SURROGATE_ROLE);
        } else if (SURROGATE_ATTRIBUTE_KEY.equals(key)) {
            this.SURROGATE_ATTRIBUTE = value;
            logger.info(m + key + "==" + this.SURROGATE_ATTRIBUTE);
        } else if (LOG_STACK_TRACES_KEY.equals(key)) {
            try {
                this.LOG_STACK_TRACES = Base.booleanValue(value);
                logger.info(m + key + "==" + this.LOG_STACK_TRACES);
            }
            catch (Throwable t) {
                this.initErrors = true;
                logger.error(m + "bad config " + key + "==" + value);
            }
        } else if (PW_NULL_KEY.equals(key)) {
            if (SKIP_FILTER.equalsIgnoreCase(value) || USE_FILTER.equalsIgnoreCase(value) || UNAUTHENTICATE_USER_UNCONDITIONALLY.equalsIgnoreCase(value)) {
                this.PW_NULL = value;
                logger.info(m + key + "==" + this.PW_NULL);
            } else {
                this.initErrors = true;
                logger.error(m + "bad config " + key + "==" + value);
            }
        } else if (PW_0_KEY.equals(key)) {
            if (SKIP_FILTER.equalsIgnoreCase(value) || USE_FILTER.equalsIgnoreCase(value) || UNAUTHENTICATE_USER_UNCONDITIONALLY.equalsIgnoreCase(value)) {
                this.PW_0 = value;
                logger.info(m + key + "==" + this.PW_0);
            } else {
                this.initErrors = true;
                logger.error(m + "bad config " + key + "==" + value);
            }
        } else if (EMPTY_RESULTS_KEY.equals(key)) {
            if (SKIP_FILTER.equalsIgnoreCase(value) || USE_FILTER.equalsIgnoreCase(value) || UNAUTHENTICATE_USER_UNCONDITIONALLY.equalsIgnoreCase(value) || UNAUTHENTICATE_USER_CONDITIONALLY.equalsIgnoreCase(value)) {
                this.EMPTY_RESULTS = value;
                logger.info(m + key + "==" + this.EMPTY_RESULTS);
            } else {
                this.initErrors = true;
                logger.error(m + "bad config " + key + "==" + value);
            }
        } else {
            logger.debug(m + "deferring " + key + " to super");
            super.initThisSubclass(key, value);
        }
        logger.debug(m + "<");
    }

    @Override
    public boolean doThisSubclass(ExtendedHttpServletRequest extendedHttpServletRequest, HttpServletResponse response) throws Throwable {
        boolean alreadyAuthenticated;
        String method = "doThisSubclass() ";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.doThisSubclass(extendedHttpServletRequest, response);
        boolean bl = alreadyAuthenticated = extendedHttpServletRequest.getUserPrincipal() != null;
        if (logger.isDebugEnabled()) {
            logger.debug(this.format(method, null, "alreadyAuthenticated") + alreadyAuthenticated);
            logger.debug(this.format(method, null, "AUTHENTICATE") + this.AUTHENTICATE);
        }
        if (this.authenticate(alreadyAuthenticated)) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, "calling authenticate() . . ."));
            }
            this.authenticate(extendedHttpServletRequest);
        } else if (logger.isDebugEnabled()) {
            logger.debug(this.format(method, "not calling authenticate()"));
        }
        String authority = extendedHttpServletRequest.getAuthority();
        logger.debug(this.format(method, null, "authority", authority));
        if (authority != null && !"".equals(authority)) {
            if (extendedHttpServletRequest.isUserSponsored()) {
                logger.debug(this.format(method, "user already sponsored"));
            } else {
                logger.debug(this.format(method, "user not already sponsored"));
                if (!this.FILTERS_CONTRIBUTING_AUTHENTICATED_ATTRIBUTES.contains(authority)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "not calling gatherAuthenticatedAttributes()"));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "calling gatherAuthenticatedAttributes() . . ."));
                    }
                    this.contributeAuthenticatedAttributes(extendedHttpServletRequest);
                    boolean surrogateTurnedOnHere = false;
                    if (this.SURROGATE_ROLE == null || "".equals(this.SURROGATE_ROLE)) {
                        logger.debug(this.format(method, "no surrogate role configured"));
                    } else {
                        logger.debug(this.format(method, "surrogate role configured", SURROGATE_ROLE_KEY, this.SURROGATE_ROLE));
                        if (extendedHttpServletRequest.isUserInRole(this.SURROGATE_ROLE)) {
                            logger.debug(this.format(method, "authenticated user has surrogate role"));
                            surrogateTurnedOnHere = true;
                        } else {
                            logger.debug(this.format(method, "authenticated user doesn't have surrogate role"));
                        }
                    }
                    if (this.SURROGATE_ATTRIBUTE == null || "".equals(this.SURROGATE_ATTRIBUTE)) {
                        logger.debug(this.format(method, "no surrogate attribute configured"));
                    } else {
                        logger.debug(this.format(method, "surrogate attribute configured", SURROGATE_ATTRIBUTE_KEY, this.SURROGATE_ATTRIBUTE));
                        if (extendedHttpServletRequest.isAttributeDefined(this.SURROGATE_ATTRIBUTE)) {
                            logger.debug(this.format(method, "authenticated user has surrogate attribute"));
                            surrogateTurnedOnHere = true;
                        } else {
                            logger.debug(this.format(method, "authenticated user doesn't have surrogate attribute"));
                        }
                    }
                    if (surrogateTurnedOnHere) {
                        logger.debug(this.format(method, "setting user to sponsored"));
                        extendedHttpServletRequest.setSponsoredUser();
                        if (extendedHttpServletRequest.isUserSponsored()) {
                            logger.debug(this.format(method, "verified that user is sponsored"));
                        } else {
                            logger.error(this.format(method, "user is not correctly sponsored"));
                        }
                    }
                }
            }
            if (extendedHttpServletRequest.isUserSponsored()) {
                if (!this.FILTERS_CONTRIBUTING_SPONSORED_ATTRIBUTES.contains(authority)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "not calling gatherSponsoredAttributes()"));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "calling gatherSponsoredAttributes() . . ."));
                    }
                    this.contributeSponsoredAttributes(extendedHttpServletRequest);
                }
            }
        }
        return false;
    }

    protected abstract void authenticate(ExtendedHttpServletRequest var1) throws Exception;

    protected abstract void contributeAuthenticatedAttributes(ExtendedHttpServletRequest var1) throws Exception;

    protected abstract void contributeSponsoredAttributes(ExtendedHttpServletRequest var1) throws Exception;

    protected abstract boolean authenticate(boolean var1);
}

