/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.security.servletfilters.Cache;
import org.fcrepo.server.security.servletfilters.CacheElementPopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheElement {
    private static final Logger logger = LoggerFactory.getLogger(CacheElement.class);
    private static final Calendar EARLIER;
    private static final boolean s_expired_default = true;
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private final String m_userid;
    private final String m_cacheid;
    private final String m_cacheabbrev;
    private String m_password = null;
    private boolean m_valid = false;
    private Calendar m_expiration = null;
    private Boolean m_authenticated = null;
    private Map m_namedValues = null;
    private String m_errorMessage = null;

    public CacheElement(String userid, String cacheid, String cacheabbrev) {
        this.m_userid = userid;
        this.m_cacheid = cacheid;
        this.m_cacheabbrev = cacheabbrev;
        this.invalidate();
    }

    public String getUserid() {
        return this.m_userid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void populate(Boolean authenticated, Set predicates, Map namedValues, String errorMessage) {
        String m = this.m_cacheabbrev + " populate() ";
        logger.debug(m + ">");
        try {
            if (predicates != null) {
                logger.warn(m + " predicates are deprecated; will be ignored");
            }
            this.assertInvalid();
            if (errorMessage != null) {
                logger.error(m + "errorMessage==" + errorMessage);
                throw new Exception(errorMessage);
            }
            this.validate(authenticated, namedValues);
        }
        catch (Throwable t) {
            logger.error(m + "invalidating to be sure");
            this.invalidate(errorMessage);
        }
        finally {
            logger.debug(m + "<");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Boolean authenticate(Cache cache, String pwd) {
        String m = this.m_cacheabbrev + " authenticate() ";
        logger.debug(m + ">");
        Boolean rc = null;
        try {
            logger.debug(m + "m_valid==" + this.m_valid);
            if (this.m_valid && !CacheElement.isExpired(this.m_expiration)) {
                logger.debug(m + "valid and not expired, so use");
                if (!this.isAuthenticated()) {
                    logger.debug(m + "auth==" + this.m_authenticated);
                    rc = this.m_authenticated;
                } else {
                    logger.debug(m + "already authd, request password==" + pwd);
                    if (pwd == null) {
                        logger.debug(m + "null request password");
                        rc = Boolean.FALSE;
                    } else if ("".equals(pwd)) {
                        logger.debug(m + "zero-length request password");
                        rc = Boolean.FALSE;
                    } else {
                        logger.debug(m + "stored password==" + this.m_password);
                        rc = pwd.equals(this.m_password);
                    }
                }
            } else {
                logger.debug(m + "expired or invalid, so try to repopulate");
                this.invalidate();
                CacheElementPopulator cePop = cache.getCacheElementPopulator();
                cePop.populateCacheElement(this, pwd);
                int duration = 0;
                String unit = null;
                this.m_password = null;
                if (this.m_authenticated == null || !this.m_valid) {
                    duration = cache.getAuthExceptionTimeoutDuration();
                    unit = cache.getAuthExceptionTimeoutUnit();
                    logger.debug(m + "couldn't complete population");
                } else {
                    logger.debug(m + "populate completed");
                    if (this.isAuthenticated()) {
                        this.m_password = pwd;
                        duration = cache.getAuthSuccessTimeoutDuration();
                        unit = cache.getAuthSuccessTimeoutUnit();
                        logger.debug(m + "populate succeeded");
                    } else {
                        duration = cache.getAuthFailureTimeoutDuration();
                        unit = cache.getAuthFailureTimeoutUnit();
                        logger.debug(m + "populate failed");
                    }
                }
                this.m_expiration = CacheElement.calcExpiration(duration, unit);
                rc = this.m_authenticated;
            }
        }
        catch (Throwable th) {
            this.invalidate();
            rc = this.m_authenticated;
            logger.error(m + "invalidating to be sure");
        }
        finally {
            this.audit();
            logger.debug(m + "< " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Map getNamedValues(Cache cache, String pwd) {
        String m = this.m_cacheabbrev + " namedValues ";
        logger.debug(m + ">");
        Map rc = null;
        try {
            logger.debug(m + "valid==" + this.m_valid);
            if (this.m_valid && !CacheElement.isExpired(this.m_expiration)) {
                logger.debug(m + "valid and not expired, so use");
            } else {
                logger.debug(m + "expired or invalid, so try to repopulate");
                this.invalidate();
                CacheElementPopulator cePop = cache.getCacheElementPopulator();
                cePop.populateCacheElement(this, pwd);
                int duration = 0;
                String unit = null;
                if (this.m_namedValues == null || !this.m_valid) {
                    duration = cache.getAuthExceptionTimeoutDuration();
                    unit = cache.getAuthExceptionTimeoutUnit();
                    logger.debug(m + "couldn't complete population");
                } else {
                    logger.debug(m + "populate completed");
                    if (this.m_namedValues == null) {
                        duration = cache.getAuthFailureTimeoutDuration();
                        unit = cache.getAuthFailureTimeoutUnit();
                        logger.debug(m + "populate failed");
                    } else {
                        this.m_password = pwd;
                        duration = cache.getAuthSuccessTimeoutDuration();
                        unit = cache.getAuthSuccessTimeoutUnit();
                        logger.debug(m + "populate succeeded");
                    }
                }
                this.m_expiration = CacheElement.calcExpiration(duration, unit);
            }
        }
        catch (Throwable th) {
            String msg = m + "invalidating to be sure";
            this.invalidate(msg);
            logger.error(msg);
        }
        finally {
            this.audit();
            rc = this.m_namedValues;
            if (rc == null) {
                rc = new Hashtable();
            }
            logger.debug(m + "< " + rc);
        }
        return rc;
    }

    public String getInstanceId() {
        String rc = this.toString();
        int i = rc.indexOf("@");
        if (i > 0) {
            rc = rc.substring(i + 1);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void audit() {
        String m = this.m_cacheabbrev + " audit() ";
        if (logger.isDebugEnabled()) {
            try {
                Calendar now = Calendar.getInstance();
                logger.debug(m + "> " + this.m_cacheid + " " + this.getInstanceId() + " @ " + CacheElement.format(now));
                logger.debug(m + "valid==" + this.m_valid);
                logger.debug(m + "userid==" + this.getUserid());
                logger.debug(m + "password==" + this.m_password);
                logger.debug(m + "authenticated==" + this.m_authenticated);
                logger.debug(m + "errorMessage==" + this.m_errorMessage);
                logger.debug(m + "expiration==" + CacheElement.format(this.m_expiration));
                logger.debug(m + CacheElement.compareForExpiration(now, this.m_expiration));
                if (this.m_namedValues == null) {
                    logger.debug(m + "(no named attributes");
                } else {
                    CacheElement.auditNamedValues(m, this.m_namedValues);
                }
            }
            finally {
                logger.debug(m + "<");
            }
        }
    }

    private boolean isAuthenticated() {
        if (this.m_authenticated == null) {
            return false;
        }
        return this.m_authenticated;
    }

    private void invalidate() {
        this.invalidate(null);
    }

    private void invalidate(String errorMessage) {
        String m = this.m_cacheabbrev + " invalidate() ";
        this.m_valid = false;
        this.m_errorMessage = errorMessage;
        this.m_authenticated = null;
        this.m_namedValues = null;
        this.m_expiration = EARLIER;
        this.m_password = null;
        if (this.m_errorMessage != null) {
            logger.debug(m + this.m_errorMessage);
        }
    }

    private final void assertInvalid() {
        assert (this.m_authenticated == null);
        assert (this.m_namedValues == null);
        assert (!this.m_valid);
        assert (CacheElement.isExpired(this.m_expiration, false));
        assert (this.m_password == null);
    }

    private static final void checkCalcExpiration(int duration, int unit) throws IllegalArgumentException {
        if (duration < 0) {
            throw new IllegalArgumentException("bad duration==" + duration);
        }
        switch (unit) {
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("bad unit==" + unit);
            }
        }
    }

    private void validate(Boolean authenticated, Map namedValues) {
        this.assertInvalid();
        this.m_authenticated = authenticated;
        this.m_namedValues = namedValues;
        this.m_errorMessage = null;
        this.m_valid = true;
    }

    private static final void auditNamedValues(String m, Map namedValues) {
        if (logger.isDebugEnabled()) {
            assert (namedValues != null);
            for (Object name : namedValues.keySet()) {
                assert (name instanceof String) : "not a string, name==" + name;
                StringBuffer sb = new StringBuffer(m + name + "==");
                Object temp2 = namedValues.get(name);
                assert (temp2 instanceof String || temp2 instanceof Set) : "neither string nor set, temp==" + temp2;
                if (temp2 instanceof String) {
                    sb.append(temp2.toString());
                } else if (temp2 instanceof Set) {
                    Set values = (Set)temp2;
                    sb.append("(" + values.size() + ") {");
                    String punct = "";
                    for (Object temp2 : values) {
                        if (!(temp2 instanceof String)) {
                            logger.error(m + "set member not string, ==" + temp2);
                            continue;
                        }
                        String value = (String)temp2;
                        sb.append(punct + value);
                        punct = ",";
                    }
                    sb.append("}");
                }
                logger.debug(sb.toString());
            }
        }
    }

    private static final String pad(long i, String pad, boolean padLeft) {
        String rc = "";
        String st = Long.toString(i);
        if (st.length() == pad.length()) {
            rc = st;
        } else if (st.length() > pad.length()) {
            rc = st.substring(0, pad.length());
        } else {
            String padNeeded = pad.substring(0, pad.length() - st.length());
            rc = padLeft ? padNeeded + st : st + padNeeded;
        }
        return rc;
    }

    private static final String pad(long i, String pad) {
        return CacheElement.pad(i, pad, true);
    }

    private static final String format(long day, long hour, long minute, long second, long millisecond, String dayPad) {
        StringBuffer sb = new StringBuffer();
        if (dayPad != null) {
            sb.append(CacheElement.pad(day, "00"));
            sb.append(" ");
        } else {
            sb.append(Long.toString(day));
            sb.append(" days ");
        }
        sb.append(CacheElement.pad(hour, "00"));
        sb.append(":");
        sb.append(CacheElement.pad(minute, "00"));
        sb.append(":");
        sb.append(CacheElement.pad(second, "00"));
        sb.append(".");
        sb.append(CacheElement.pad(millisecond, "000"));
        return sb.toString();
    }

    private static final String format(long year, long month, long day, long hour, long minute, long second, long millisecond) {
        StringBuffer sb = new StringBuffer();
        sb.append(CacheElement.pad(year, "0000"));
        sb.append("-");
        sb.append(CacheElement.pad(month, "00"));
        sb.append("-");
        sb.append(CacheElement.format(day, hour, minute, second, millisecond, "00"));
        return sb.toString();
    }

    private static final String format(Calendar time) {
        return CacheElement.format(time.get(1), time.get(2) + 1, time.get(5), time.get(11), time.get(12), time.get(13), time.get(14));
    }

    private static final String difference(Calendar earlier, Calendar later) {
        long milliseconds = later.getTimeInMillis() - earlier.getTimeInMillis();
        long days = milliseconds / 86400000L;
        long hours = (milliseconds %= 86400000L) / 3600000L;
        long minutes = (milliseconds %= 3600000L) / 60000L;
        long seconds = (milliseconds %= 60000L) / 1000L;
        String rc = CacheElement.format(days, hours, minutes, seconds, milliseconds %= 1000L, null);
        return rc;
    }

    private static final String compareForExpiration(Calendar first, Calendar second) {
        String rc = null;
        rc = first.before(second) ? "expires in " + CacheElement.difference(first, second) : "expired " + CacheElement.difference(second, first) + " ago";
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Calendar calcExpiration(int duration, int unit) {
        String m = "- calcExpiration(int,int) ";
        logger.debug(m + ">");
        Calendar now = Calendar.getInstance();
        Calendar rc = Calendar.getInstance();
        try {
            CacheElement.checkCalcExpiration(duration, unit);
            if (duration > 0) {
                rc.add(unit, duration);
                logger.debug(m + CacheElement.compareForExpiration(now, rc));
            } else {
                logger.debug(m + "timeout set to now (effectively, no caching)");
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug(m + "< " + CacheElement.format(rc));
            }
        }
        return rc;
    }

    private static final int calcCalendarUnit(String unit) {
        String m = "- calcCalendarUnit() ";
        int rc = 13;
        if (!unit.endsWith("s")) {
            unit = unit + "s";
        }
        if ("milliseconds".equalsIgnoreCase(unit)) {
            rc = 14;
        } else if ("seconds".equalsIgnoreCase(unit)) {
            rc = 13;
        } else if ("minutes".equalsIgnoreCase(unit)) {
            rc = 12;
        } else if ("hours".equalsIgnoreCase(unit)) {
            rc = 10;
        } else {
            String msg = "illegal Calendar unit: " + unit;
            logger.error(m + "(" + msg + ")");
            throw new IllegalArgumentException(msg);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Calendar calcExpiration(int duration, String unit) {
        String m = "- calcExpiration(int,String) ";
        Calendar rc = Calendar.getInstance();
        int calendarUnit = 13;
        try {
            calendarUnit = CacheElement.calcCalendarUnit(unit);
        }
        catch (Throwable t) {
            duration = 0;
            logger.error(m + "using duration==" + duration);
            logger.error(m + "using calendarUnit==" + calendarUnit);
        }
        finally {
            rc = CacheElement.calcExpiration(duration, calendarUnit);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isExpired(Calendar now, Calendar expiration, boolean verbose) {
        String m = "- isExpired() ";
        if (verbose) {
            logger.debug(m + ">");
        }
        boolean rc = true;
        try {
            if (now == null) {
                String msg = "illegal parm now==" + now;
                logger.error(m + "(" + msg + ")");
                throw new IllegalArgumentException(msg);
            }
            if (expiration == null) {
                String msg = "illegal parm expiration==" + expiration;
                logger.error(m + "(" + msg + ")");
                throw new IllegalArgumentException(msg);
            }
            if (verbose) {
                logger.debug(m + "now==" + CacheElement.format(now));
                logger.debug(m + "exp==" + CacheElement.format(expiration));
            }
            rc = !now.before(expiration);
        }
        catch (Throwable th) {
            logger.error(m + "failed comparison");
            rc = true;
        }
        finally {
            if (verbose) {
                logger.debug(m + CacheElement.compareForExpiration(now, expiration));
                logger.debug(m + "< " + rc);
            }
        }
        return rc;
    }

    private static final boolean isExpired(Calendar expiration, boolean verbose) {
        String m = "- isExpired() ";
        boolean rc = true;
        try {
            if (expiration == null) {
                String msg = "illegal parm expiration==" + expiration;
                logger.error(m + "(" + msg + ")");
                throw new IllegalArgumentException(msg);
            }
            Calendar now = Calendar.getInstance();
            rc = CacheElement.isExpired(now, expiration, verbose);
        }
        catch (Throwable th) {
            logger.error(m + "failed comparison");
            rc = true;
        }
        return rc;
    }

    private static final boolean isExpired(Calendar now) {
        return CacheElement.isExpired(now, true);
    }

    static {
        Calendar temp = Calendar.getInstance();
        temp.set(1, 1999);
        EARLIER = temp;
    }
}

