/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.codec.binary.Base64;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.security.servletfilters.ExtendedHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHttpServletRequestWrapper
extends HttpServletRequestWrapper
implements ExtendedHttpServletRequest {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedHttpServletRequestWrapper.class);
    private String username = null;
    private String password = null;
    private String authority;
    private Principal userPrincipal;
    private boolean wrapperWriteLocked = false;
    private String sponsoredUser = null;
    private final Map authenticatedAttributes = new Hashtable();
    private final Map sponsoredAttributes = new Hashtable();
    public static final String BASIC = "Basic";
    public static final String AUTHORIZATION = "Authorization";
    public static final String FROM = "From";

    @Override
    public final void lockWrapper() throws Exception {
        this.lockSponsoredUser();
        this.wrapperWriteLocked = true;
    }

    private void setSponsoredUser(String sponsoredUser) throws Exception {
        if (this.sponsoredUser == null) {
            this.sponsoredUser = sponsoredUser;
        }
    }

    @Override
    public void setSponsoredUser() throws Exception {
        String method = "setSponsoredUser";
        String sponsoredUser = "";
        logger.debug(method + " , isSponsoredUserRequested()==" + this.isSponsoredUserRequested());
        if (this.isSponsoredUserRequested()) {
            sponsoredUser = this.getFromHeader();
            logger.debug(method + " , sponsoredUser==" + sponsoredUser);
        }
        this.setSponsoredUser(sponsoredUser);
    }

    @Override
    public void lockSponsoredUser() throws Exception {
        this.setSponsoredUser("");
    }

    @Override
    public void setAuthenticated(Principal userPrincipal, String authority) throws Exception {
        if (this.wrapperWriteLocked) {
            throw new Exception();
        }
        if (this.isAuthenticated()) {
            throw new Exception();
        }
        this.userPrincipal = userPrincipal;
        this.authority = authority;
    }

    public Principal getUserPrincipal() {
        Principal userPrincipal = super.getUserPrincipal();
        if (userPrincipal == null) {
            userPrincipal = this.userPrincipal;
        }
        return userPrincipal;
    }

    @Override
    public final boolean isUserSponsored() {
        return this.sponsoredUser != null && !"".equals(this.sponsoredUser);
    }

    protected boolean isSponsoredUserRequested() {
        String sponsoredUser = this.getFromHeader();
        boolean isSponsoredUserRequested = sponsoredUser != null && !"".equals(sponsoredUser);
        return isSponsoredUserRequested;
    }

    @Override
    public final boolean isAuthenticated() {
        return this.getUserPrincipal() != null;
    }

    public String getRemoteUser() {
        String remoteUser = null;
        if (this.isUserSponsored()) {
            remoteUser = this.sponsoredUser;
        } else {
            remoteUser = super.getRemoteUser();
            if (remoteUser == null && this.userPrincipal != null) {
                remoteUser = this.userPrincipal.getName();
            }
        }
        return remoteUser;
    }

    public final void auditInnerMap(Map map) {
        if (logger.isDebugEnabled()) {
            for (String key : map.keySet()) {
                Object value = map.get(key);
                StringBuffer sb = new StringBuffer(key + "==");
                String comma = "";
                if (value instanceof String) {
                    sb.append(value);
                } else if (value instanceof String[]) {
                    sb.append("[");
                    for (int i = 0; i < ((String[])value).length; ++i) {
                        Object o = ((String[])value)[i];
                        if (o instanceof String) {
                            sb.append(comma + o);
                            comma = ",";
                            continue;
                        }
                        sb.append(comma + "UNKNOWN");
                        comma = ",";
                    }
                    sb.append("]");
                } else if (value instanceof Set) {
                    sb.append("{");
                    for (Object o : (Set)value) {
                        if (o instanceof String) {
                            sb.append(comma + o);
                            comma = ",";
                            continue;
                        }
                        sb.append(comma + "UNKNOWN");
                        comma = ",";
                    }
                    sb.append("}");
                } else {
                    sb.append("UNKNOWN");
                }
                logger.debug(sb.toString());
            }
        }
    }

    public final void auditInnerSet(Set set) {
        if (logger.isDebugEnabled()) {
            for (Object value : set) {
                if (value instanceof String) {
                    logger.debug((String)value);
                    continue;
                }
                logger.debug("UNKNOWN");
            }
        }
    }

    public final void auditOuterMap(Map map, String desc) {
        if (logger.isDebugEnabled()) {
            logger.debug("");
            logger.debug("auditing " + desc);
            for (Object key : map.keySet()) {
                Object inner = map.get(key);
                String authority = "";
                authority = key instanceof String ? (String)key : "<authority not a string>";
                if (inner instanceof Map) {
                    logger.debug(authority + " maps to . . .");
                    this.auditInnerMap((Map)inner);
                    continue;
                }
                if (inner instanceof Set) {
                    logger.debug(authority + " maps to . . .");
                    this.auditInnerSet((Set)inner);
                    continue;
                }
                logger.debug(authority + " maps to an unknown object==" + map.getClass().getName());
            }
        }
    }

    @Override
    public void audit() {
        if (logger.isDebugEnabled()) {
            logger.debug("\n===AUDIT===");
            logger.debug("auditing wrapped request");
            this.auditOuterMap(this.authenticatedAttributes, "authenticatedAttributes");
            this.auditOuterMap(this.sponsoredAttributes, "sponsoredAttributes");
            logger.debug("===AUDIT===\n");
        }
    }

    public boolean getAttributeDefined(String key) throws AuthzOperationalException {
        boolean defined = false;
        Map map = null;
        map = this.isUserSponsored() ? this.sponsoredAttributes : this.authenticatedAttributes;
        for (Map attributesFromOneAuthority : map.values()) {
            if (!attributesFromOneAuthority.containsKey(key)) continue;
            defined = true;
            break;
        }
        return defined;
    }

    @Override
    public Set getAttributeValues(String key) throws AuthzOperationalException {
        HashSet accumulatedValues4Key = null;
        Map map = null;
        map = this.isUserSponsored() ? this.sponsoredAttributes : this.authenticatedAttributes;
        for (Map attributesFromOneAuthority : map.values()) {
            Set someValues4Key;
            if (!attributesFromOneAuthority.containsKey(key) || (someValues4Key = (Set)attributesFromOneAuthority.get(key)) == null || someValues4Key.isEmpty()) continue;
            if (accumulatedValues4Key == null) {
                accumulatedValues4Key = new HashSet();
            }
            accumulatedValues4Key.addAll(someValues4Key);
        }
        if (accumulatedValues4Key == null) {
            accumulatedValues4Key = IMMUTABLE_NULL_SET;
        }
        return accumulatedValues4Key;
    }

    @Override
    public boolean hasAttributeValues(String key) throws AuthzOperationalException {
        Set temp = this.getAttributeValues(key);
        return !temp.isEmpty();
    }

    @Override
    public boolean isAttributeDefined(String key) throws AuthzOperationalException {
        boolean isAttributeDefined = this.getAttributeDefined(key);
        return isAttributeDefined;
    }

    private void putIntoMap(Map map, String key, Object value) throws Exception {
        if (this.wrapperWriteLocked) {
            throw new Exception();
        }
        if (!this.isAuthenticated()) {
            throw new Exception("can't collect user roles/attributes/groups until after authentication");
        }
        if (map == null || key == null || value == null) {
            throw new Exception("null parm, map==" + map + ", key==" + key + ", value==" + value);
        }
        if (map.containsKey(key)) {
            throw new Exception("map already contains key==" + key);
        }
        logger.debug("mapping " + key + " => " + value + " in " + map);
        map.put(key, value);
    }

    private void putMapIntoMap(Map map, String key, Object value) throws Exception {
        if (!(value instanceof Map)) {
            throw new Exception("input parm must be a map");
        }
        this.putIntoMap(map, key, value);
    }

    @Override
    public void addAttributes(String authority, Map attributes) throws Exception {
        if (this.isUserSponsored()) {
            this.putMapIntoMap(this.sponsoredAttributes, authority, attributes);
        } else {
            this.putMapIntoMap(this.authenticatedAttributes, authority, attributes);
        }
    }

    private Map getAllAttributes(Map attributeGroup) {
        Hashtable all = new Hashtable();
        for (Map m : attributeGroup.values()) {
            all.putAll(m);
        }
        return all;
    }

    @Override
    public Map getAllAttributes() throws AuthzOperationalException {
        Map all = null;
        all = this.isUserSponsored() ? this.getAllAttributes(this.sponsoredAttributes) : this.getAllAttributes(this.authenticatedAttributes);
        return all;
    }

    private final String[] parseUsernamePassword(String header) throws Exception {
        String here = "parseUsernamePassword():";
        String[] usernamePassword = null;
        String msg = here + "header intact";
        if (header == null || "".equals(header)) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", header==" + header);
            throw new Exception(exceptionMsg);
        }
        logger.debug(msg + "succeeded");
        String[] authschemeUsernamepassword = header.split("\\s+");
        msg = here + "header split";
        if (authschemeUsernamepassword.length != 2) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", header==" + header);
            throw new Exception(exceptionMsg);
        }
        logger.debug(msg + "succeeded");
        msg = here + "auth scheme";
        String authscheme = authschemeUsernamepassword[0];
        if (authscheme == null && !BASIC.equalsIgnoreCase(authscheme)) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", authscheme==" + authscheme);
            throw new Exception(exceptionMsg);
        }
        logger.debug(msg + "succeeded");
        msg = here + "digest non-null";
        String usernamepassword = authschemeUsernamepassword[1];
        if (usernamepassword == null || "".equals(usernamepassword)) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", usernamepassword==" + usernamepassword);
            throw new Exception(exceptionMsg);
        }
        logger.debug(msg + "succeeded" + ", usernamepassword==" + usernamepassword);
        byte[] encoded = usernamepassword.getBytes();
        msg = here + "digest base64-encoded";
        if (!Base64.isArrayByteBase64((byte[])encoded)) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", encoded==" + encoded);
            throw new Exception(exceptionMsg);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(msg + "succeeded" + ", encoded==" + encoded);
        }
        byte[] decodedAsByteArray = Base64.decodeBase64((byte[])encoded);
        logger.debug(here + "got decoded bytes" + "succeeded" + ", decodedAsByteArray==" + decodedAsByteArray);
        String decoded = new String(decodedAsByteArray);
        logger.debug(here + "got decoded string" + "succeeded" + ", decoded==" + decoded);
        msg = here + "digest decoded";
        if (decoded == null || "".equals(decoded)) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", digest decoded==" + decoded);
            throw new Exception(exceptionMsg);
        }
        logger.debug(msg + "succeeded");
        String DELIMITER = ":";
        if (decoded == null) {
            logger.error("decoded user/password is null . . . returning 0-length strings");
            usernamePassword = new String[]{"", ""};
        } else {
            if (decoded.indexOf(DELIMITER) < 0) {
                String exceptionMsg = "decoded user/password lacks delimiter";
                logger.error(exceptionMsg + " . . . throwing exception");
                throw new Exception(exceptionMsg);
            }
            if (decoded.startsWith(DELIMITER)) {
                logger.error("decoded user/password is lacks user . . . returning 0-length strings");
                usernamePassword = new String[]{"", ""};
            } else {
                usernamePassword = decoded.endsWith(DELIMITER) ? new String[]{decoded.substring(0, decoded.length() - 1), ""} : decoded.split(DELIMITER);
            }
        }
        msg = here + "user/password split";
        if (usernamePassword.length != 2) {
            String exceptionMsg = msg + "failed";
            logger.error(exceptionMsg + ", digest decoded==" + decoded);
            throw new Exception(exceptionMsg);
        }
        logger.debug(msg + "succeeded");
        return usernamePassword;
    }

    public final String getAuthorizationHeader() {
        String value;
        String name;
        logger.debug("getAuthorizationHeader()");
        logger.debug("getting this headers");
        Enumeration enu = this.getHeaderNames();
        while (enu.hasMoreElements()) {
            name = (String)enu.nextElement();
            logger.debug("another headername==" + name);
            value = this.getHeader(name);
            logger.debug("another headervalue==" + value);
        }
        logger.debug("getting super headers");
        enu = super.getHeaderNames();
        while (enu.hasMoreElements()) {
            name = (String)enu.nextElement();
            logger.debug("another headername==" + name);
            value = super.getHeader(name);
            logger.debug("another headervalue==" + value);
        }
        return this.getHeader(AUTHORIZATION);
    }

    @Override
    public final String getFromHeader() {
        return this.getHeader(FROM);
    }

    @Override
    public final String getUser() throws Exception {
        if (this.username == null) {
            logger.debug("username==null, so will grok now");
            String authorizationHeader = this.getAuthorizationHeader();
            logger.debug("authorizationHeader==" + authorizationHeader);
            if (authorizationHeader != null && !"".equals(authorizationHeader)) {
                logger.debug("authorizationHeader is intact");
                String[] usernamePassword = this.parseUsernamePassword(authorizationHeader);
                logger.debug("usernamePassword[] length==" + usernamePassword.length);
                this.username = usernamePassword[0];
                logger.debug("username (usernamePassword[0])==" + this.username);
                if (super.getRemoteUser() == null) {
                    logger.debug("had none before");
                } else if (super.getRemoteUser() == this.username || super.getRemoteUser().equals(this.username)) {
                    logger.debug("got same now");
                } else {
                    throw new Exception("somebody got it wrong");
                }
            }
        }
        logger.debug("return user==" + this.username);
        return this.username;
    }

    @Override
    public final String getPassword() throws Exception {
        String authorizationHeader;
        if (this.password == null && (authorizationHeader = this.getAuthorizationHeader()) != null && !"".equals(authorizationHeader)) {
            String[] usernamePassword = this.parseUsernamePassword(authorizationHeader);
            this.password = usernamePassword[1];
        }
        logger.debug("return password==" + this.password);
        return this.password;
    }

    @Override
    public final String getAuthority() {
        return this.authority;
    }

    public ExtendedHttpServletRequestWrapper(HttpServletRequest wrappedRequest) throws Exception {
        super(wrappedRequest);
    }

    @Deprecated
    public String getRealPath(String path) {
        return super.getRealPath(path);
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isSecure() {
        logger.debug("super.isSecure()==" + super.isSecure());
        logger.debug("this.getLocalPort()==" + this.getLocalPort());
        logger.debug("this.getProtocol()==" + this.getProtocol());
        logger.debug("this.getServerPort()==" + this.getServerPort());
        logger.debug("this.getRequestURI()==" + this.getRequestURI());
        return super.isSecure();
    }
}

