/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.server.security.servletfilters.ExtendedHttpServletRequest;
import org.fcrepo.server.security.servletfilters.FilterSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FilterFinalize
extends FilterSetup {
    private static final Logger logger = LoggerFactory.getLogger(FilterFinalize.class);
    private static final boolean AUTHENTICATION_REQUIRED_DEFAULT = true;
    private boolean AUTHENTICATION_REQUIRED = true;
    private static final String AUTHENTICATION_REQUIRED_KEY = "authentication-required";
    private static final String REQUEST_ATTRIBUTE_INPUT_NAME_DEFAULT = "FEDORA_AUX_SUBJECT_ATTRIBUTES";
    private String REQUEST_ATTRIBUTE_INPUT_NAME = "FEDORA_AUX_SUBJECT_ATTRIBUTES";
    private static final String REQUEST_ATTRIBUTE_INPUT_NAME_KEY = "request-attribute-input-key";
    private static final String REQUEST_ATTRIBUTE_INPUT_AUTHORITY_DEFAULT = "auxsubject";
    private String REQUEST_ATTRIBUTE_INPUT_AUTHORITY = "auxsubject";
    private static final String REQUEST_ATTRIBUTE_INPUT_AUTHORITY_KEY = "request-attribute-input-authority";
    private static final String DELIVERY_NAME_DEFAULT = "FEDORA_AUX_SUBJECT_ATTRIBUTES";
    private final String DELIVERY_NAME = "FEDORA_AUX_SUBJECT_ATTRIBUTES";
    private static final String[] URLS_DEFAULT = new String[]{"/.*"};
    private String[] URLS = URLS_DEFAULT;
    private static final String URLS_KEY = "authentication-urls";

    @Override
    protected void initThisSubclass(String key, String value) {
        logger.debug("FAT.iTS");
        String method = "initThisSubclass() ";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        boolean setLocally = false;
        if (AUTHENTICATION_REQUIRED_KEY.equals(key)) {
            try {
                this.AUTHENTICATION_REQUIRED = FilterFinalize.booleanValue(value);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error(this.format(method, "bad value", key, value));
                }
                this.initErrors = true;
            }
            setLocally = true;
        } else if (REQUEST_ATTRIBUTE_INPUT_NAME_KEY.equals(key)) {
            this.REQUEST_ATTRIBUTE_INPUT_NAME = value;
            setLocally = true;
        } else if (REQUEST_ATTRIBUTE_INPUT_AUTHORITY_KEY.equals(key)) {
            this.REQUEST_ATTRIBUTE_INPUT_AUTHORITY = value;
            setLocally = true;
        } else if (URLS_KEY.equals(key)) {
            String temp = value;
            this.URLS = temp.split(",");
            setLocally = true;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(this.format(method, "deferring to super"));
            }
            super.initThisSubclass(key, value);
        }
        if (setLocally && logger.isInfoEnabled()) {
            logger.info(this.format(method, "known parameter", key, value));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }

    @Override
    public boolean doThisSubclass(ExtendedHttpServletRequest request, HttpServletResponse response) throws Throwable {
        String method = "doThisSubclass() ";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.doThisSubclass(request, response);
        request.lockWrapper();
        if (this.REQUEST_ATTRIBUTE_INPUT_NAME != null) {
            Object testFedoraAuxSubjectAttributes = request.getAttribute(this.REQUEST_ATTRIBUTE_INPUT_NAME);
            if (testFedoraAuxSubjectAttributes == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.format(method, "no aux subject attributes found"));
                }
            } else if (!(testFedoraAuxSubjectAttributes instanceof Map)) {
                if (logger.isErrorEnabled()) {
                    logger.error(this.format(method, "aux subject attributes found, but not a Map"));
                }
            } else {
                boolean errorsInMap = false;
                Map auxSubjectRoles = (Map)testFedoraAuxSubjectAttributes;
                for (Object name : auxSubjectRoles.keySet()) {
                    if (!(name instanceof String)) {
                        logger.error(this.format(method, "key not a String " + name));
                        errorsInMap = true;
                        break;
                    }
                    Object value = auxSubjectRoles.get(name);
                    if (value instanceof String[]) continue;
                    if (logger.isErrorEnabled()) {
                        logger.error(this.format(method, "value not a String" + value));
                    }
                    errorsInMap = true;
                    break;
                }
                if (errorsInMap) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "errors in map"));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.format(method, "no errors in map"));
                    }
                    request.addAttributes(this.REQUEST_ATTRIBUTE_INPUT_AUTHORITY, auxSubjectRoles);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.format(method, "before stashing"));
        }
        request.audit();
        Hashtable subjectAttributesMap = new Hashtable();
        subjectAttributesMap.putAll(request.getAllAttributes());
        for (String name : subjectAttributesMap.keySet()) {
            Object value = subjectAttributesMap.get(name);
            logger.debug("IN FILTER MAP HAS ATTRIBUTE " + name + "==" + value + " " + value.getClass().getName());
        }
        logger.debug("IN FILTER ROLE eduPersonAffiliation?==" + request.isUserInRole("eduPersonAffiliation"));
        request.setAttribute("FEDORA_AUX_SUBJECT_ATTRIBUTES", subjectAttributesMap);
        return false;
    }

    @Override
    public void destroy() {
        String method = "destroy()";
        if (logger.isDebugEnabled()) {
            logger.debug(this.enter(method));
        }
        super.destroy();
        if (logger.isDebugEnabled()) {
            logger.debug(this.exit(method));
        }
    }
}

