/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRestApiFlash
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(FilterRestApiFlash.class);

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering FilterRestApiFlash.doThisSubclass()");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String queryString = httpRequest.getQueryString();
        if (queryString != null && queryString.contains("flash=true")) {
            StatusHttpServletResponseWrapper sHttpResponse = new StatusHttpServletResponseWrapper(httpResponse);
            filterChain.doFilter(request, (ServletResponse)sHttpResponse);
            if (sHttpResponse.status != sHttpResponse.realStatus) {
                try {
                    ServletOutputStream out = sHttpResponse.getOutputStream();
                    out.print("::ERROR(" + sHttpResponse.realStatus + ")");
                }
                catch (IllegalStateException ise) {
                    PrintWriter out = sHttpResponse.getWriter();
                    out.print("::ERROR(" + sHttpResponse.realStatus + ")");
                }
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private static class StatusHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private int realStatus;
        private int status;

        public StatusHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int statusCode) {
            this.realStatus = statusCode;
            if (statusCode - 200 < 0 || statusCode - 200 >= 100) {
                this.status = 200;
                super.setStatus(this.status);
            } else {
                this.status = statusCode;
            }
        }
    }
}

