/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters.ldap;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.FilterConfig;
import org.fcrepo.server.errors.authorization.PasswordComparisonException;
import org.fcrepo.server.security.servletfilters.BaseCaching;
import org.fcrepo.server.security.servletfilters.CacheElement;
import org.fcrepo.server.security.servletfilters.FilterSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FilterLdap
extends BaseCaching {
    public static final String CONTEXT_VERSION_KEY = "java.naming.ldap.version";
    public static final String VERSION_KEY = "version";
    public static final String BIND_FILTER_KEY = "bind-filter";
    public static final String URL_KEY = "url";
    public static final String BASE_KEY = "search-base";
    public static final String FILTER_KEY = "search-filter";
    public static final String USERID_KEY = "id-attribute";
    public static final String PASSWORD_KEY = "password-attribute";
    public static final String ATTRIBUTES2RETURN_KEY = "attributes";
    public static final String GROUPS_NAME_KEY = "attributes-common-name";
    public static final String SECURITY_AUTHENTICATION_KEY = "security-authentication";
    public static final String SECURITY_PRINCIPAL_KEY = "security-principal";
    public static final String SECURITY_CREDENTIALS_KEY = "security-credentials";
    private static final Logger logger = LoggerFactory.getLogger(FilterLdap.class);
    private String[] DIRECTORY_ATTRIBUTES_NEEDED = null;
    private String VERSION = "2";
    private String BIND_FILTER = "";
    private String URL = "";
    private String BASE = "";
    private String FILTER = "";
    private String PASSWORD = "";
    private String[] ATTRIBUTES2RETURN = null;
    private String GROUPS_NAME = null;
    public String SECURITY_AUTHENTICATION = "none";
    public String SECURITY_PRINCIPAL = null;
    public String SECURITY_CREDENTIALS = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(FilterConfig filterConfig) {
        String m = "L init() ";
        try {
            logger.debug(m + ">");
            super.init(filterConfig);
            m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " init() ";
            this.inited = false;
            if (!this.initErrors) {
                HashSet<String> temp = new HashSet<String>();
                if (this.ATTRIBUTES2RETURN == null) {
                    this.ATTRIBUTES2RETURN = new String[0];
                } else {
                    for (String element : this.ATTRIBUTES2RETURN) {
                        temp.add(element);
                    }
                }
                if (this.AUTHENTICATE && this.PASSWORD != null && !"".equals(this.PASSWORD)) {
                    temp.add(this.PASSWORD);
                }
                this.DIRECTORY_ATTRIBUTES_NEEDED = temp.toArray(StringArrayPrototype);
                boolean haveBindMethod = false;
                if (this.SECURITY_AUTHENTICATION != null && !"".equals(this.SECURITY_AUTHENTICATION)) {
                    haveBindMethod = true;
                }
                boolean haveSuperUser = false;
                if (this.SECURITY_PRINCIPAL != null && !"".equals(this.SECURITY_PRINCIPAL)) {
                    haveSuperUser = true;
                }
                boolean haveSuperUserPassword = false;
                if (this.SECURITY_CREDENTIALS != null && !"".equals(this.SECURITY_CREDENTIALS)) {
                    haveSuperUserPassword = true;
                }
                boolean haveUserPasswordAttributeName = false;
                if (this.PASSWORD != null && !"".equals(this.PASSWORD)) {
                    haveUserPasswordAttributeName = true;
                }
                boolean commonBindConfigured = false;
                if (haveBindMethod && haveSuperUserPassword) {
                    boolean error = false;
                    if (!haveSuperUser) {
                        error = true;
                    }
                    if (error) {
                        this.initErrors = true;
                    } else {
                        commonBindConfigured = true;
                    }
                }
                boolean individualBindConfigured = false;
                boolean individualBindTestConfigured = false;
                if (haveBindMethod && !haveSuperUserPassword) {
                    if (haveSuperUser) {
                        individualBindTestConfigured = true;
                    } else {
                        individualBindConfigured = true;
                    }
                }
                boolean individualCompareConfigured = false;
                if (haveUserPasswordAttributeName) {
                    individualCompareConfigured = true;
                }
            }
            if (this.initErrors) {
                logger.error(m + "not initialized; see previous error");
            }
            this.inited = true;
        }
        finally {
            logger.debug(m + "<");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " destroy() ";
        try {
            logger.debug(m + ">");
            super.destroy();
        }
        finally {
            logger.debug(m + "<");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initThisSubclass(String key, String value) {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " initThisSubclass() ";
        try {
            logger.debug(m + ">");
            logger.debug(m + key + "==" + value);
            boolean setLocally = false;
            if (VERSION_KEY.equals(key)) {
                this.VERSION = value;
                setLocally = true;
            } else if (BIND_FILTER_KEY.equals(key)) {
                this.BIND_FILTER = value;
                setLocally = true;
            } else if (URL_KEY.equals(key)) {
                this.URL = value;
                setLocally = true;
            } else if (BASE_KEY.equals(key)) {
                this.BASE = value;
                setLocally = true;
            } else if (USERID_KEY.equals(key)) {
                setLocally = true;
            } else if (ATTRIBUTES2RETURN_KEY.equals(key)) {
                if (value.indexOf(",") < 0) {
                    if ("".equals(value)) {
                        this.ATTRIBUTES2RETURN = null;
                    } else {
                        this.ATTRIBUTES2RETURN = new String[1];
                        this.ATTRIBUTES2RETURN[0] = value;
                    }
                } else {
                    this.ATTRIBUTES2RETURN = value.split(",");
                }
                setLocally = true;
            } else if (GROUPS_NAME_KEY.equals(key)) {
                this.GROUPS_NAME = value;
                setLocally = true;
            } else if (FILTER_KEY.equals(key)) {
                this.FILTER = value;
                setLocally = true;
            } else if (PASSWORD_KEY.equals(key)) {
                this.PASSWORD = value;
                setLocally = true;
            } else if (SECURITY_AUTHENTICATION_KEY.equals(key)) {
                this.SECURITY_AUTHENTICATION = value;
                setLocally = true;
            } else if (SECURITY_PRINCIPAL_KEY.equals(key)) {
                this.SECURITY_PRINCIPAL = value;
                setLocally = true;
            } else if (SECURITY_CREDENTIALS_KEY.equals(key)) {
                this.SECURITY_CREDENTIALS = value;
                setLocally = true;
            } else {
                logger.debug(m + "deferring to super");
                super.initThisSubclass(key, value);
            }
            if (setLocally) {
                logger.info(m + "known parameter " + key + "==" + value);
            }
        }
        finally {
            logger.debug(m + "<");
        }
    }

    private final String applyFilter(String filter, String[] args) {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " applyFilter() ";
        String result = filter;
        logger.debug(m + "result==" + result);
        for (int i = args.length - 1; i >= 0; --i) {
            String regex = "\\{" + Integer.toString(i) + "\\}";
            logger.debug(m + "regex ==" + regex);
            logger.debug(m + "arg ==" + args[i]);
            result = result.replaceFirst(regex, args[i]);
            logger.debug(m + "result==" + result);
        }
        return result;
    }

    private boolean bindRequired() {
        boolean bindRequired = "simple".equals(this.SECURITY_AUTHENTICATION);
        return bindRequired;
    }

    private boolean individualUserBind() {
        boolean individualUserBind = this.bindRequired() && this.AUTHENTICATE && (this.PASSWORD == null || "".equals(this.PASSWORD));
        return individualUserBind;
    }

    private boolean individualUserComparison() {
        boolean individualUserComparison = this.AUTHENTICATE && this.PASSWORD != null && !"".equals(this.PASSWORD);
        return individualUserComparison;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getEnvironment(String userid, String password) {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " getEnvironment() ";
        Hashtable<String, String> env = null;
        try {
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (this.VERSION != null && !"".equals(this.VERSION)) {
                logger.debug(m + "ldap explicit version==" + this.VERSION);
                env.put(CONTEXT_VERSION_KEY, this.VERSION);
            }
            logger.debug(m + "ldap version==" + env.get(CONTEXT_VERSION_KEY));
            env.put("java.naming.provider.url", this.URL);
            logger.debug(m + "ldap url==" + env.get("java.naming.provider.url"));
            if (!this.bindRequired()) {
                logger.debug(m + "\"binding\" anonymously");
            } else {
                env.put("java.naming.security.authentication", this.SECURITY_AUTHENTICATION);
                String userForBind = null;
                String passwordForBind = null;
                if (!this.individualUserBind()) {
                    userForBind = this.SECURITY_PRINCIPAL;
                    passwordForBind = this.SECURITY_CREDENTIALS;
                    logger.debug(m + "binding to protected directory");
                } else {
                    passwordForBind = password;
                    if (this.SECURITY_PRINCIPAL == null || "".equals(this.SECURITY_PRINCIPAL)) {
                        userForBind = userid;
                        logger.debug(m + "binding for real user");
                    } else {
                        userForBind = this.SECURITY_PRINCIPAL;
                        logger.debug(m + "binding for --test-- user");
                    }
                }
                env.put("java.naming.security.credentials", passwordForBind);
                String[] parms = new String[]{userForBind};
                String userFormattedForBind = this.applyFilter(this.BIND_FILTER, parms);
                env.put("java.naming.security.principal", userFormattedForBind);
            }
            logger.debug(m + "bind w " + env.get("java.naming.security.authentication"));
            logger.debug(m + "user== " + env.get("java.naming.security.principal"));
            logger.debug(m + "passwd==" + env.get("java.naming.security.credentials"));
        }
        catch (Throwable th) {
            if (this.LOG_STACK_TRACES) {
                logger.error(m + "couldn't set up env for DirContext", th);
            } else {
                logger.error(m + "couldn't set up env for DirContext" + th.getMessage());
            }
        }
        finally {
            logger.debug(m + "< " + env);
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFilter(String userid) {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " getFilter() ";
        logger.debug(m + ">");
        String filter = null;
        try {
            filter = new String(this.FILTER);
            filter = filter.replaceFirst("\\{0}", userid);
        }
        catch (Throwable th) {
            if (this.LOG_STACK_TRACES) {
                logger.error(m + "couldn't set up filter for dir search", th);
            } else {
                logger.error(m + "couldn't set up filter for dir search" + th.getMessage());
            }
        }
        finally {
            logger.debug(m + "< " + filter);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SearchControls getSearchControls() {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " getSearchControls() ";
        logger.debug(m + ">");
        SearchControls searchControls = null;
        try {
            int nEntries2return = 0;
            int millisecondTimeLimit = 0;
            boolean retobj = true;
            boolean deref = true;
            searchControls = new SearchControls(2, nEntries2return, millisecondTimeLimit, this.DIRECTORY_ATTRIBUTES_NEEDED, retobj, deref);
        }
        catch (Throwable th) {
            block5: {
                try {
                    if (this.LOG_STACK_TRACES) {
                        logger.error(m + "couldn't set up search controls for dir search", th);
                        break block5;
                    }
                    logger.error(m + "couldn't set up search controls for dir search" + th.getMessage());
                }
                catch (Throwable throwable) {
                    logger.debug(m + "< " + searchControls);
                    throw throwable;
                }
            }
            logger.debug(m + "< " + searchControls);
        }
        logger.debug(m + "< " + searchControls);
        return searchControls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration getBasicNamingEnumeration(String userid, String password, String filter, SearchControls searchControls, Hashtable env) throws NamingException, Exception {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " getNamingEnumeration() ";
        logger.debug(m + ">");
        NamingEnumeration<SearchResult> ne = null;
        try {
            InitialDirContext ctx;
            try {
                ctx = new InitialDirContext(env);
            }
            catch (NamingException th) {
                String msg = "exception getting ldap context";
                if (this.LOG_STACK_TRACES) {
                    logger.error(m + msg, (Throwable)th);
                } else {
                    logger.error(m + msg + " " + th.getMessage());
                }
                throw th;
            }
            if (ctx == null) {
                logger.error(m + "unexpected null ldap context");
                throw new NamingException("");
            }
            try {
                ne = ctx.search(this.BASE, filter, searchControls);
            }
            catch (NamingException th) {
                String msg = "exception getting ldap enumeration";
                if (this.LOG_STACK_TRACES) {
                    logger.error(m + msg, (Throwable)th);
                } else {
                    logger.error(m + msg + " " + th.getMessage());
                }
                throw th;
            }
            if (ne == null) {
                logger.error(m + "unexpected null ldap enumeration");
                throw new NamingException("");
            }
        }
        finally {
            logger.debug(m + "< " + ne);
        }
        return ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration getNamingEnumeration(String userid, String password, String filter, SearchControls searchControls, Hashtable env) throws NamingException, Exception {
        NamingEnumeration ne;
        block29: {
            String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " getNamingEnumeration() ";
            logger.debug(m + ">");
            String msg = "[LDAP: error code 49 - Bind failed: ";
            if (!this.individualUserBind()) {
                logger.info(m + "-not- binding individual user");
            } else {
                logger.info(m + "-binding- individual user");
                if (password == null) {
                    logger.debug(m + "null password");
                    if ("use-filter".equalsIgnoreCase(this.PW_NULL)) {
                        logger.debug(m + "-no- pre null password handling");
                    } else if (this.AUTHENTICATE) {
                        logger.info(m + "-doing- pre null password handling");
                        if ("unauthenticate-user-unconditionally".equalsIgnoreCase(this.PW_NULL)) {
                            logger.info(m + "pre unauthenticating for null password");
                            throw new NamingException(msg + "null password]");
                        }
                        if ("skip-filter".equalsIgnoreCase(this.PW_NULL)) {
                            logger.info(m + "pre ignoring for null passwd");
                            throw new Exception(msg + "null password]");
                        }
                    }
                } else if ("".equals(password)) {
                    logger.debug(m + "0-length password");
                    if ("use-filter".equalsIgnoreCase(this.PW_0)) {
                        logger.debug(m + "-no- pre 0-length password handling");
                    } else if (this.AUTHENTICATE) {
                        logger.info(m + "-doing- pre 0-length password handling");
                        if ("unauthenticate-user-unconditionally".equalsIgnoreCase(this.PW_0)) {
                            logger.info(m + "pre unauthenticating for 0-length password");
                            throw new NamingException(msg + "0-length password]");
                        }
                        if ("skip-filter".equalsIgnoreCase(this.PW_0)) {
                            logger.info(m + "pre ignoring for 0-length passwd");
                            throw new Exception(msg + "0-length password]");
                        }
                    }
                } else assert (password.length() > 0);
            }
            ne = null;
            try {
                ne = this.getBasicNamingEnumeration(userid, password, filter, searchControls, env);
                assert (ne != null);
                if (ne.hasMoreElements()) {
                    logger.debug(m + "enumeration has elements");
                    break block29;
                }
                logger.debug(m + "enumeration has no elements, yet no exceptions");
                if (this.bindRequired() && !this.individualUserBind()) {
                    logger.debug(m + "failed security bind");
                    throw new NamingException(msg + "failed security bind]");
                }
                if (!this.AUTHENTICATE) {
                    logger.debug(m + "user authentication -not- done by this filter");
                    break block29;
                }
                logger.debug(m + "user authentication -done- by this filter");
                if (!this.bindRequired()) {
                    logger.debug(m + "but -not- binding");
                    break block29;
                }
                logger.debug(m + "-and- binding");
                if ("skip-filter".equalsIgnoreCase(this.EMPTY_RESULTS)) {
                    logger.debug(m + "passing thru for EMPTY_RESULTS");
                    throw new Exception(msg + "null password]");
                }
                if ("unauthenticate-user-unconditionally".equalsIgnoreCase(this.EMPTY_RESULTS)) {
                    logger.debug(m + "failing for EMPTY_RESULTS");
                    throw new NamingException(msg + "null password]");
                }
                if ("use-filter".equalsIgnoreCase(this.EMPTY_RESULTS)) {
                    logger.debug(m + "passing for EMPTY_RESULTS");
                    break block29;
                }
                if (!"unauthenticate-user-conditionally".equalsIgnoreCase(this.EMPTY_RESULTS)) break block29;
                if (this.ATTRIBUTES2RETURN == null || this.ATTRIBUTES2RETURN.length < 1) {
                    logger.debug(m + "fair enough");
                    break block29;
                }
                throw new NamingException(msg + "expected some");
            }
            finally {
                logger.debug(m + "< " + ne);
            }
        }
        return ne;
    }

    private static Boolean comparePassword(Attributes attributes, String password, String passwordAttribute) throws PasswordComparisonException {
        String m = "- comparePassword() ";
        logger.debug(m + ">");
        Boolean rc = null;
        try {
            logger.debug(m + "looking for return attribute==" + passwordAttribute);
            Attribute attribute = attributes.get(passwordAttribute);
            if (attribute == null) {
                logger.error(m + "null object");
            } else {
                int size = attribute.size();
                logger.debug(m + "object with n==" + size);
                for (int j = 0; j < size; ++j) {
                    Object o = attribute.get(j);
                    if (password.equals(o.toString())) {
                        logger.debug(m + "compares true");
                        if (rc == null) {
                            logger.debug(m + "1st comp:  authenticate");
                            rc = Boolean.TRUE;
                            continue;
                        }
                        logger.error(m + "dup comp:  keep previous rc==" + rc);
                        continue;
                    }
                    logger.debug(m + "compares false, -un-authenticate");
                    if (rc == null) {
                        logger.debug(m + "1st comp (fyi)");
                    } else {
                        logger.error(m + "dup comp (fyi)");
                    }
                    rc = Boolean.FALSE;
                }
            }
        }
        catch (Throwable th) {
            logger.error(m + "resetting to null rc==" + rc + th.getMessage());
            throw new PasswordComparisonException("in ldap servlet filter", th);
        }
        finally {
            logger.debug(m + "< " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributes(Attributes attributes, Map map) throws Throwable {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " getAttributes() ";
        logger.debug(m + ">");
        try {
            for (String key : this.ATTRIBUTES2RETURN) {
                Set<Object> values;
                logger.debug(m + "looking for return attribute==" + key);
                Attribute attribute = attributes.get(key);
                if (attribute == null) {
                    logger.error(m + "null object...continue to next attr sought");
                    continue;
                }
                if (this.GROUPS_NAME != null && !"".equals(this.GROUPS_NAME)) {
                    key = this.GROUPS_NAME;
                    logger.debug(m + "values collected and interpreted as groups==" + key);
                }
                if (map.containsKey(key)) {
                    logger.debug(m + "already a value-set for attribute==" + key);
                    values = (Set)map.get(key);
                } else {
                    logger.debug(m + "making+storing a value-set for attribute==" + key);
                    values = new HashSet();
                    map.put(key, values);
                }
                int size = attribute.size();
                logger.debug(m + "object with n==" + size);
                for (int j = 0; j < size; ++j) {
                    Object o = attribute.get(j);
                    values.add(o);
                    logger.debug(m + "added value==" + o.toString() + ", class==" + o.getClass().getName());
                }
            }
        }
        finally {
            logger.debug(m + "<");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean processNamingEnumeration(NamingEnumeration ne, String password, Boolean authenticated, Map map) {
        String m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " processNamingEnumeration() ";
        logger.debug(m + ">");
        try {
            boolean errorOnSomeComparison = false;
            while (ne.hasMoreElements()) {
                logger.debug(m + "another element");
                SearchResult s = null;
                try {
                    Object o = ne.nextElement();
                    logger.debug(m + "got a " + o.getClass().getName());
                    s = (SearchResult)o;
                }
                catch (Throwable th) {
                    logger.error(m + "naming enum contains obj not SearchResult");
                    continue;
                }
                Attributes attributes = s.getAttributes();
                this.getAttributes(attributes, map);
                if (!this.individualUserComparison()) continue;
                Boolean temp = null;
                try {
                    temp = FilterLdap.comparePassword(attributes, password, this.PASSWORD);
                    logger.debug(m + "-this- comp yields " + temp);
                    if (authenticated != null && !authenticated.booleanValue()) {
                        logger.debug(m + "keeping prev failed authn");
                        continue;
                    }
                    logger.debug(m + "replacing prvsuccess or null authn");
                    if (errorOnSomeComparison) {
                        logger.debug(m + "errorOnSomeComparison==" + errorOnSomeComparison);
                        continue;
                    }
                    authenticated = temp;
                }
                catch (Throwable th) {
                    logger.debug(m + "in iUC conditional, caught throwable th==" + th);
                    errorOnSomeComparison = true;
                    authenticated = null;
                }
            }
            if (this.individualUserComparison()) {
                if (errorOnSomeComparison) {
                    logger.debug(m + "exception, so assuring authenticated==" + authenticated);
                    authenticated = null;
                    map.clear();
                } else if (authenticated == null) {
                    authenticated = Boolean.FALSE;
                    logger.debug(m + "no passwd attr found, so authenticated==" + authenticated);
                }
            }
        }
        catch (Throwable th) {
            map.clear();
            if (authenticated != null && authenticated.booleanValue()) {
                authenticated = null;
            }
            if (this.LOG_STACK_TRACES) {
                logger.error(m + "ldap filter failure", th);
            } else {
                logger.error(m + "ldap filter failure" + th.getMessage());
            }
        }
        finally {
            logger.debug(m + "< authenticated==" + authenticated + " map==" + map);
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateCacheElement(CacheElement cacheElement, String password) {
        Hashtable map;
        Boolean authenticated;
        String m;
        block24: {
            m = FilterSetup.getFilterNameAbbrev(this.FILTER_NAME) + " populateCacheElement() ";
            logger.debug(m + ">");
            authenticated = null;
            map = new Hashtable();
            try {
                logger.debug(m + "about to call getNamingEnumeration()");
                String filter = this.getFilter(cacheElement.getUserid());
                SearchControls searchControls = this.getSearchControls();
                Hashtable env = this.getEnvironment(cacheElement.getUserid(), password);
                NamingEnumeration ne = null;
                try {
                    ne = this.getNamingEnumeration(cacheElement.getUserid(), password, filter, searchControls, env);
                    assert (ne != null);
                    logger.debug(m + "got expected non-null ne, no exception thrown");
                    if (this.AUTHENTICATE && this.individualUserBind()) {
                        authenticated = Boolean.TRUE;
                    }
                    if (this.AUTHENTICATE && this.individualUserBind() && !authenticated.booleanValue()) {
                        logger.debug(m + "-not- calling processNamingEnumeration()");
                        break block24;
                    }
                    logger.debug(m + "about to call processNamingEnumeration()");
                    assert (map.isEmpty());
                    try {
                        authenticated = this.processNamingEnumeration(ne, password, authenticated, map);
                        logger.debug(m + "back from pNE.  AUTHENTICATE==" + this.AUTHENTICATE + " authenticated==" + authenticated + " map==" + map);
                        if (authenticated != null) {
                            logger.debug(m + "authenticated.booleanValue()==" + authenticated);
                        }
                        if (map != null) {
                            logger.debug(m + "map.isEmpty()==" + map.isEmpty());
                        }
                        if (this.AUTHENTICATE && (authenticated == null || !authenticated.booleanValue())) {
                            map.clear();
                        }
                        logger.debug(m + "before catch");
                    }
                    catch (Throwable th) {
                        map.clear();
                        authenticated = this.AUTHENTICATE && this.individualUserBind() ? Boolean.FALSE : null;
                        if (this.LOG_STACK_TRACES) {
                            logger.error(m + "caught th==" + th);
                            break block24;
                        }
                        logger.error(m + "caught th==" + th.getMessage());
                    }
                }
                catch (NamingException e) {
                    logger.error(m + "unexpected null ne w/o exception thrown");
                    if (!this.AUTHENTICATE) {
                        logger.error(m + "wasn't authenticating");
                    } else {
                        authenticated = Boolean.FALSE;
                        if (this.individualUserComparison()) {
                            logger.error(m + "can't do password comparison, so false");
                        } else if (this.individualUserBind()) {
                            logger.error(m + "accept to mean failed bind, so false");
                        } else {
                            logger.error(m + "authenticating, so now set false");
                        }
                    }
                }
                catch (Exception e) {
                    if (this.AUTHENTICATE && this.individualUserComparison()) {
                        authenticated = null;
                        logger.error(m + "has no ret vals, so reject authentication");
                    } else if (this.AUTHENTICATE && this.individualUserBind()) {
                        authenticated = null;
                        logger.error(m + "has no ret vals, so reject authentication");
                    }
                }
            }
            catch (Throwable throwable) {
                logger.debug(m + "in finally, authenticated==" + authenticated + " map==" + map);
                cacheElement.populate(authenticated, null, map, null);
                logger.debug(m + "<");
                throw throwable;
            }
        }
        logger.debug(m + "in finally, authenticated==" + authenticated + " map==" + map);
        cacheElement.populate(authenticated, null, map, null);
        logger.debug(m + "<");
    }
}

