/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.servletfilters.xmluserfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.server.security.servletfilters.FinishedParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserXmlUserfile
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(ParserXmlUserfile.class);
    private SAXParser m_parser;
    private final InputStream m_xmlStream;
    private String username = null;
    private String password = null;
    private Boolean authenticated = null;
    private Map namedAttributes = null;
    private String attributeName = null;
    private Set attributeValues = null;
    private StringBuffer value = null;
    private boolean inValue = false;
    private boolean foundUser = false;

    public ParserXmlUserfile(InputStream xmlStream) throws IOException {
        logger.debug("Initializing XMLUserfile parser");
        this.m_xmlStream = xmlStream;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            this.m_parser = spf.newSAXParser();
        }
        catch (Exception e) {
            throw new IOException("Error getting XML parser", e);
        }
    }

    public final Boolean getAuthenticated() {
        return this.authenticated;
    }

    public final Map getNamedAttributes() {
        return this.namedAttributes;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        if (localName.equals("users")) {
            logger.debug("<users> foundUser==" + this.foundUser);
        } else if (localName.equals("user")) {
            logger.debug("<user> foundUser==" + this.foundUser);
            logger.debug("<<user>> this node username==" + a.getValue("name") + " password==" + a.getValue("password"));
            if (this.username.equals(a.getValue("name"))) {
                this.foundUser = true;
                this.authenticated = this.password != null && this.password.equals(a.getValue("password"));
            }
        } else if (localName.equals("attribute")) {
            logger.debug("<attribute> foundUser==" + this.foundUser);
            if (this.foundUser) {
                this.attributeName = a.getValue("name");
                this.attributeValues = new HashSet();
                logger.debug("attributeName==" + this.attributeName);
            }
        } else if (localName.equals("value")) {
            logger.debug("<value> foundUser==" + this.foundUser);
            this.inValue = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("users")) {
            logger.debug("</users> foundUser==" + this.foundUser);
            this.authenticated = Boolean.FALSE;
        } else if (localName.equals("user")) {
            logger.debug("</user> foundUser==" + this.foundUser);
            if (this.foundUser) {
                logger.debug("at </user> (quick audit)");
                logger.debug("authenticated==" + this.authenticated);
                logger.debug("namedAttributes n==" + this.namedAttributes.size());
                throw new FinishedParsingException("");
            }
        } else if (localName.equals("attribute")) {
            logger.debug("</attribute> foundUser==" + this.foundUser);
            if (this.foundUser) {
                logger.debug("set n==" + this.attributeValues.size());
                this.namedAttributes.put(this.attributeName, this.attributeValues);
                logger.debug("just added values for " + this.attributeName);
            }
            this.attributeName = null;
            this.attributeValues = null;
        } else if (localName.equals("value")) {
            logger.debug("</value> foundUser==" + this.foundUser);
            if (this.foundUser) {
                this.attributeValues.add(this.value.toString());
                logger.debug("just added " + this.value);
            }
            logger.debug("quick audit of value string ==" + this.value);
            this.value.setLength(0);
            this.inValue = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inValue && this.foundUser && this.value != null) {
            this.value.append(ch, start, length);
            logger.debug("characters called start==" + start + " length==" + length);
        }
    }

    public void parse(String username, String password) throws IOException, FinishedParsingException {
        this.username = username;
        this.password = password;
        try {
            this.value = new StringBuffer();
            this.authenticated = null;
            this.namedAttributes = new Hashtable();
            this.foundUser = false;
            this.m_parser.parse(this.m_xmlStream, (DefaultHandler)this);
        }
        catch (FinishedParsingException fpe) {
            throw fpe;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException("Error parsing XML: " + e.getMessage());
        }
    }
}

