/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.RecoveryContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ConnectionPoolNotFoundException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.InvalidContextException;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ObjectAlreadyInLowlevelStorageException;
import org.fcrepo.server.errors.ObjectExistsException;
import org.fcrepo.server.errors.ObjectLockedException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StorageDeviceException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.management.PIDGenerator;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.DOReaderCache;
import org.fcrepo.server.storage.DOWriter;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.FedoraStorageHintProvider;
import org.fcrepo.server.storage.NullStorageHintsProvider;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.SimpleDOWriter;
import org.fcrepo.server.storage.SimpleServiceDefinitionReader;
import org.fcrepo.server.storage.SimpleServiceDeploymentReader;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.DigitalObjectUtil;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.XMLDatastreamProcessor;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.server.utilities.DCFields;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.validation.DOObjectValidator;
import org.fcrepo.server.validation.DOValidator;
import org.fcrepo.server.validation.ValidationUtility;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDOManager
extends Module
implements DOManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDOManager.class);
    private static final Pattern URL_PROTOCOL = Pattern.compile("^\\w+:\\/.*$");
    private String m_pidNamespace;
    protected String m_storagePool;
    private String m_defaultStorageFormat;
    private String m_defaultExportFormat;
    private String m_storageCharacterEncoding;
    protected PIDGenerator m_pidGenerator;
    protected DOTranslator m_translator;
    protected ILowlevelStorage m_permanentStore;
    protected FedoraStorageHintProvider m_hintProvider;
    protected DOValidator m_validator;
    private DOObjectValidator m_objectValidator;
    protected FieldSearch m_fieldSearch;
    protected ExternalContentManager m_contentManager;
    protected Management m_management;
    protected Set<String> m_retainPIDs;
    protected ResourceIndex m_resourceIndex;
    private DOReaderCache m_readerCache;
    private final Set<String> m_lockedPIDs = new HashSet<String>();
    protected ConnectionPool m_connectionPool;
    protected Connection m_connection;
    private ModelDeploymentMap m_cModelDeploymentMap;
    private int m_ingestValidationLevel;

    public DefaultDOManager(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        String ingestValidationLevel;
        int readerCacheSeconds;
        int readerCacheSize;
        this.m_pidNamespace = this.getParameter("pidNamespace");
        if (this.m_pidNamespace == null) {
            throw new ModuleInitializationException("pidNamespace parameter must be specified.", this.getRole());
        }
        if (this.m_pidNamespace.length() > 17 || this.m_pidNamespace.length() < 1) {
            throw new ModuleInitializationException("pidNamespace parameter must be 1-17 chars long", this.getRole());
        }
        StringBuffer badChars = new StringBuffer();
        for (int i = 0; i < this.m_pidNamespace.length(); ++i) {
            char c = this.m_pidNamespace.charAt(i);
            boolean invalid = true;
            if (c >= '0' && c <= '9') {
                invalid = false;
            } else if (c >= 'a' && c <= 'z') {
                invalid = false;
            } else if (c >= 'A' && c <= 'Z') {
                invalid = false;
            } else if (c == '-') {
                invalid = false;
            } else if (c == '.') {
                invalid = false;
            }
            if (!invalid) continue;
            badChars.append(c);
        }
        if (badChars.toString().length() > 0) {
            throw new ModuleInitializationException("pidNamespace contains invalid character(s) '" + badChars.toString() + "'", this.getRole());
        }
        this.m_storagePool = this.getParameter("storagePool");
        if (this.m_storagePool == null) {
            logger.debug("Parameter storagePool not given, will defer to ConnectionPoolManager's default pool.");
        }
        logger.debug("Server property format.storage= " + Server.STORAGE_FORMAT);
        this.m_defaultStorageFormat = Server.STORAGE_FORMAT;
        if (this.m_defaultStorageFormat == null) {
            throw new ModuleInitializationException("System property format.storage not given, but it's required.", this.getRole());
        }
        this.m_defaultExportFormat = this.getParameter("defaultExportFormat");
        if (this.m_defaultExportFormat == null) {
            throw new ModuleInitializationException("Parameter defaultExportFormat not given, but it's required.", this.getRole());
        }
        this.m_storageCharacterEncoding = this.getParameter("storageCharacterEncoding");
        if (this.m_storageCharacterEncoding == null) {
            logger.debug("Parameter storage_character_encoding not given, using UTF-8");
            this.m_storageCharacterEncoding = "UTF-8";
        }
        this.initRetainPID();
        String rcSize = this.getParameter("readerCacheSize");
        if (rcSize == null) {
            logger.debug("Parameter readerCacheSize not given, using 20");
            rcSize = "20";
        }
        try {
            readerCacheSize = Integer.parseInt(rcSize);
            if (readerCacheSize < 0) {
                throw new Exception("Cannot be less than zero");
            }
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Bad value for readerCacheSize parameter: " + e.getMessage(), this.getRole());
        }
        String rcSeconds = this.getParameter("readerCacheSeconds");
        if (rcSeconds == null) {
            logger.debug("Parameter readerCacheSeconds not given, using 5");
            rcSeconds = "5";
        }
        try {
            readerCacheSeconds = Integer.parseInt(rcSeconds);
            if (readerCacheSeconds < 1) {
                throw new Exception("Cannot be less than one");
            }
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Bad value for readerCacheSeconds parameter: " + e.getMessage(), this.getRole());
        }
        if (readerCacheSize > 0) {
            this.m_readerCache = new DOReaderCache(readerCacheSize, readerCacheSeconds);
        }
        if ((ingestValidationLevel = this.getParameter("ingestValidationLevel")) == null) {
            logger.debug("Ingest validation level not specified, using default of all");
            this.m_ingestValidationLevel = 0;
        } else {
            this.m_ingestValidationLevel = Integer.parseInt(ingestValidationLevel);
            if (this.m_ingestValidationLevel < -1 || this.m_ingestValidationLevel > 2) {
                throw new ModuleInitializationException("Bad value for ingestValidationLevel", this.getRole());
            }
        }
    }

    protected void initRetainPID() {
        this.m_retainPIDs = new HashSet<String>();
        String retainPIDs = this.getParameter("retainPIDs");
        if (retainPIDs == null || retainPIDs.equals("*")) {
            this.m_retainPIDs = null;
        } else {
            String[] ns;
            for (String element : ns = retainPIDs.trim().replaceAll(" +", ",").replaceAll(",+", ",").split(",")) {
                if (element.length() <= 0) continue;
                this.m_retainPIDs.add(element);
            }
            this.m_retainPIDs.add("fedora-system");
        }
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        this.m_management = (Management)((Object)this.getServer().getModule("org.fcrepo.server.management.Management"));
        if (this.m_management == null) {
            throw new ModuleInitializationException("Management module not loaded.", this.getRole());
        }
        this.m_contentManager = (ExternalContentManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ExternalContentManager"));
        if (this.m_contentManager == null) {
            throw new ModuleInitializationException("ExternalContentManager not loaded.", this.getRole());
        }
        this.m_fieldSearch = (FieldSearch)((Object)this.getServer().getModule("org.fcrepo.server.search.FieldSearch"));
        this.m_pidGenerator = (PIDGenerator)((Object)this.getServer().getModule("org.fcrepo.server.management.PIDGenerator"));
        this.m_translator = (DOTranslator)((Object)this.getServer().getModule("org.fcrepo.server.storage.translation.DOTranslator"));
        this.m_validator = (DOValidator)((Object)this.getServer().getModule("org.fcrepo.server.validation.DOValidator"));
        if (this.m_validator == null) {
            throw new ModuleInitializationException("DOValidator not loaded.", this.getRole());
        }
        this.m_objectValidator = (DOObjectValidator)((Object)this.getServer().getModule("org.fcrepo.server.validation.DOObjectValidator"));
        if (this.m_objectValidator == null) {
            throw new ModuleInitializationException("DOObjectValidator not loaded.", this.getRole());
        }
        this.m_resourceIndex = (ResourceIndex)((Object)this.getServer().getModule("org.fcrepo.server.resourceIndex.ResourceIndex"));
        if (this.m_resourceIndex == null) {
            logger.error("ResourceIndex not loaded");
            throw new ModuleInitializationException("ResourceIndex not loaded", this.getRole());
        }
        ConnectionPoolManager cpm = (ConnectionPoolManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ConnectionPoolManager"));
        if (cpm == null) {
            throw new ModuleInitializationException("ConnectionPoolManager not loaded.", this.getRole());
        }
        try {
            this.m_connectionPool = this.m_storagePool == null ? cpm.getPool() : cpm.getPool(this.m_storagePool);
        }
        catch (ConnectionPoolNotFoundException cpnfe) {
            throw new ModuleInitializationException("Couldn't get required connection pool; wasn't found", this.getRole());
        }
        try {
            String dbSpec = "org/fcrepo/server/storage/resources/DefaultDOManager.dbspec";
            InputStream specIn = this.getClass().getClassLoader().getResourceAsStream(dbSpec);
            if (specIn == null) {
                throw new IOException("Cannot find required resource: " + dbSpec);
            }
            SQLUtility.createNonExistingTables(this.m_connectionPool, specIn);
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Error while attempting to check for and create non-existing table(s): " + e.getClass().getName() + ": " + e.getMessage(), this.getRole(), e);
        }
        this.m_permanentStore = (ILowlevelStorage)((Object)this.getServer().getModule("org.fcrepo.server.storage.lowlevel.ILowlevelStorage"));
        if (this.m_permanentStore == null) {
            logger.error("LowlevelStorage not loaded");
            throw new ModuleInitializationException("LowlevelStorage not loaded", this.getRole());
        }
        try {
            this.m_hintProvider = (FedoraStorageHintProvider)this.getServer().getBean("fedoraStorageHintProvider");
        }
        catch (Throwable t) {
            logger.warn("Could not load the specified hint provider class (as specified in spring bean definition), using default nullprovider");
            this.m_hintProvider = new NullStorageHintsProvider();
        }
        this.initializeCModelDeploymentCache();
    }

    @Override
    public String lookupDeploymentForCModel(String cModelPid, String sDefPid) {
        return this.m_cModelDeploymentMap.getDeployment(ServiceContext.getInstance(cModelPid, sDefPid));
    }

    private void initializeCModelDeploymentCache() {
        this.m_cModelDeploymentMap = new ModelDeploymentMap();
        logger.debug("Initializing content model deployment map");
        Connection c = null;
        Statement s = null;
        ResultSet r = null;
        try {
            c = this.m_connectionPool.getReadOnlyConnection();
            String query = "SELECT cModel, sDef, sDep, mDate  FROM modelDeploymentMap, doFields  WHERE doFields.pid = modelDeploymentMap.sDep";
            s = c.prepareStatement(query, 1003, 1007);
            ResultSet results = s.executeQuery();
            while (results.next()) {
                String cModel = results.getString(1);
                String sDef = results.getString(2);
                String sDep = results.getString(3);
                long lastMod = results.getLong(4);
                this.m_cModelDeploymentMap.putDeployment(ServiceContext.getInstance(cModel, sDef), sDep, lastMod);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error loading cModel deployment cach", e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (s != null) {
                    s.close();
                }
                if (c != null) {
                    this.m_connectionPool.free(c);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Error loading cModel deployment cach", e);
            }
        }
    }

    private synchronized void updateDeploymentMap(DigitalObject obj, Connection c, boolean isPurge) throws SQLException {
        String sDep = obj.getPid();
        Set<RelationshipTuple> sDefs = obj.getRelationships((PredicateNode)Constants.MODEL.IS_DEPLOYMENT_OF, null);
        Set<RelationshipTuple> models = obj.getRelationships((PredicateNode)Constants.MODEL.IS_CONTRACTOR_OF, null);
        HashSet<ServiceContext> newContext = new HashSet<ServiceContext>();
        if (!isPurge) {
            for (RelationshipTuple sDefTuple : sDefs) {
                String sDef = sDefTuple.getObjectPID();
                for (RelationshipTuple cModelTuple : models) {
                    String cModel = cModelTuple.getObjectPID();
                    newContext.add(ServiceContext.getInstance(cModel, sDef));
                }
            }
        }
        Set<ServiceContext> oldContext = this.m_cModelDeploymentMap.getContextFor(sDep);
        for (ServiceContext o : oldContext) {
            if (newContext.contains(o)) continue;
            this.removeDeployment(o, obj, c);
        }
        for (ServiceContext n : newContext) {
            if (!oldContext.contains(n)) {
                this.addDeployment(n, obj, c);
                continue;
            }
            this.updateDeployment(n, obj, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeployment(ServiceContext context, DigitalObject sDep, Connection c) throws SQLException {
        String query = "INSERT INTO modelDeploymentMap (cModel, sDef, sDep) VALUES (?, ?, ?)";
        PreparedStatement s = c.prepareStatement(query);
        try {
            s.setString(1, context.cModel);
            s.setString(2, context.sDef);
            s.setString(3, sDep.getPid());
            s.executeUpdate();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        this.m_cModelDeploymentMap.putDeployment(context, sDep.getPid(), sDep.getLastModDate().getTime());
    }

    private void updateDeployment(ServiceContext context, DigitalObject sDep, Connection c) throws SQLException {
        this.m_cModelDeploymentMap.putDeployment(context, sDep.getPid(), sDep.getLastModDate().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeployment(ServiceContext context, DigitalObject sDep, Connection c) throws SQLException {
        String query = "DELETE FROM modelDeploymentMap WHERE cModel = ? AND sDef =? AND sDep = ?";
        PreparedStatement s = c.prepareStatement(query);
        s.setString(1, context.cModel);
        s.setString(2, context.sDef);
        s.setString(3, sDep.getPid());
        try {
            s.executeUpdate();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        this.m_cModelDeploymentMap.removeDeployment(context, sDep.getPid());
    }

    @Override
    public void shutdownModule() {
        if (this.m_readerCache != null) {
            this.m_readerCache.close();
        }
    }

    @Override
    public void releaseWriter(DOWriter writer) {
        if (writer.isNew() && !writer.isCommitted()) {
            try {
                this.unregisterObject(writer.getObject());
            }
            catch (Exception e) {
                try {
                    logger.warn("Error unregistering object: " + writer.GetObjectPID(), (Throwable)e);
                }
                catch (Exception e2) {
                    logger.warn("Error unregistering object; Unable to obtain PID from writer.", (Throwable)e2);
                }
            }
        }
        writer.invalidate();
        try {
            this.releaseWriteLock(writer.GetObjectPID());
        }
        catch (ServerException e) {
            logger.warn("Error releasing object lock; Unable to obtain pid from writer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWriteLock(String pid) {
        Set<String> set = this.m_lockedPIDs;
        synchronized (set) {
            this.m_lockedPIDs.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWriteLock(String pid) throws ObjectLockedException {
        Set<String> set = this.m_lockedPIDs;
        synchronized (set) {
            if (this.m_lockedPIDs.contains(pid)) {
                throw new ObjectLockedException(pid + " is currently being " + "modified by another thread");
            }
            this.m_lockedPIDs.add(pid);
        }
    }

    public ConnectionPool getConnectionPool() {
        return this.m_connectionPool;
    }

    public DOValidator getDOValidator() {
        return this.m_validator;
    }

    @Override
    public String[] getRequiredModuleRoles() {
        return new String[]{"org.fcrepo.server.management.PIDGenerator", "org.fcrepo.server.search.FieldSearch", "org.fcrepo.server.storage.ConnectionPoolManager", "org.fcrepo.server.storage.lowlevel.ILowlevelStorage", "org.fcrepo.server.storage.ExternalContentManager", "org.fcrepo.server.storage.translation.DOTranslator", "org.fcrepo.server.validation.DOValidator"};
    }

    public String getStorageFormat() {
        return this.m_defaultStorageFormat;
    }

    public String getDefaultExportFormat() {
        return this.m_defaultExportFormat;
    }

    public String getStorageCharacterEncoding() {
        return this.m_storageCharacterEncoding;
    }

    public DOTranslator getTranslator() {
        return this.m_translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DOReader getReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
        long getReaderStartTime = System.currentTimeMillis();
        String source = null;
        try {
            DOReader reader = null;
            if (this.m_readerCache != null) {
                reader = this.m_readerCache.get(pid);
            }
            if (reader == null) {
                reader = new SimpleDOReader(context, this, this.m_translator, this.m_defaultExportFormat, this.m_defaultStorageFormat, this.m_storageCharacterEncoding, this.m_permanentStore.retrieveObject(pid));
                source = "filesystem";
                if (this.m_readerCache != null) {
                    this.m_readerCache.put(reader);
                }
            } else {
                source = "memory";
            }
            DOReader dOReader = reader;
            return dOReader;
        }
        finally {
            if (logger.isDebugEnabled()) {
                long dur = System.currentTimeMillis() - getReaderStartTime;
                logger.debug("Got DOReader (source=" + source + ") for " + pid + " in " + dur + "ms.");
            }
        }
    }

    @Override
    public ServiceDeploymentReader getServiceDeploymentReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
        return new SimpleServiceDeploymentReader(context, this, this.m_translator, this.m_defaultExportFormat, this.m_defaultStorageFormat, this.m_storageCharacterEncoding, this.m_permanentStore.retrieveObject(pid));
    }

    @Override
    public ServiceDefinitionReader getServiceDefinitionReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
        return new SimpleServiceDefinitionReader(context, this, this.m_translator, this.m_defaultExportFormat, this.m_defaultStorageFormat, this.m_storageCharacterEncoding, this.m_permanentStore.retrieveObject(pid));
    }

    @Override
    public DOWriter getWriter(boolean cachedObjectRequired, Context context, String pid) throws ServerException, ObjectLockedException {
        if (cachedObjectRequired) {
            throw new InvalidContextException("A DOWriter is unavailable in a cached context.");
        }
        BasicDigitalObject obj = new BasicDigitalObject();
        this.m_translator.deserialize(this.m_permanentStore.retrieveObject(pid), obj, this.m_defaultStorageFormat, this.m_storageCharacterEncoding, 0);
        SimpleDOWriter w = new SimpleDOWriter(context, this, this.m_translator, this.m_defaultStorageFormat, this.m_storageCharacterEncoding, (DigitalObject)obj);
        this.getWriteLock(obj.getPid());
        return w;
    }

    @Override
    public synchronized DOWriter getIngestWriter(boolean cachedObjectRequired, Context context, InputStream in, String format, String encoding, String pid) throws ServerException {
        logger.debug("Entered getIngestWriter");
        SimpleDOWriter w = null;
        BasicDigitalObject obj = null;
        File tempFile = null;
        if (cachedObjectRequired) {
            throw new InvalidContextException("A DOWriter is unavailable in a cached context.");
        }
        try {
            Date nowUTC = Server.getCurrentDate(context);
            tempFile = File.createTempFile("fedora-ingest-temp", ".xml");
            logger.debug("Creating temporary file for ingest: " + tempFile.toString());
            StreamUtility.pipeStream(in, new FileOutputStream(tempFile), 4096);
            logger.debug("Validation (ingest phase)");
            this.m_validator.validate(tempFile, format, this.m_ingestValidationLevel, "ingest");
            obj = new BasicDigitalObject();
            obj.setNew(true);
            logger.debug("Deserializing from format: " + format);
            this.m_translator.deserialize(new FileInputStream(tempFile), obj, format, encoding, 0);
            logger.debug("Setting object/component states and create dates if unset");
            if (obj.getState() == null || obj.getState().equals("")) {
                obj.setState("A");
            }
            if (obj.getCreateDate() == null || obj.getCreateDate().equals("")) {
                obj.setCreateDate(nowUTC);
            }
            obj.setLastModDate(nowUTC);
            Iterator<String> dsIter = obj.datastreamIdIterator();
            while (dsIter.hasNext()) {
                for (Datastream ds : obj.datastreams(dsIter.next())) {
                    if (ds.DSCreateDT == null || ds.DSCreateDT.equals("")) {
                        ds.DSCreateDT = nowUTC;
                    }
                    if (ds.DSState == null || ds.DSState.equals("")) {
                        ds.DSState = "A";
                    }
                    ds.DSChecksumType = Datastream.validateChecksumType(ds.DSChecksumType);
                }
            }
            if (DefaultDOManager.FOXML1_0.uri.equals(format) || "foxml1.0".equals(format) || DefaultDOManager.METS_EXT1_0.uri.equals(format) || "metslikefedora1".equals(format)) {
                DigitalObjectUtil.updateLegacyDatastreams(obj);
            }
            if (pid != null && pid.length() > 0 && !pid.equals("new")) {
                if (obj.getPid() != null && obj.getPid().length() > 0) {
                    if (!pid.equals(obj.getPid())) {
                        throw new GeneralException("The PID of the digital object and the PID provided as parameter are different. Digital object: " + obj.getPid() + " parameter: " + pid);
                    }
                } else {
                    obj.setPid(pid);
                }
            }
            if (obj.getPid() != null && obj.getPid().length() > 0) {
                obj.setPid(Server.getPID(obj.getPid()).toString());
            }
            if (obj.getPid() != null && obj.getPid().indexOf(":") != -1 && (this.m_retainPIDs == null || this.m_retainPIDs.contains(obj.getPid().split(":")[0]))) {
                logger.debug("Stream contained PID with retainable namespace-id; will use PID from stream");
                try {
                    this.m_pidGenerator.neverGeneratePID(obj.getPid());
                }
                catch (IOException e) {
                    throw new GeneralException("Error calling pidGenerator.neverGeneratePID(): " + e.getMessage());
                }
            }
            if (pid.equals("new")) {
                logger.debug("Client wants a new PID");
                String p = null;
                try {
                    if (context instanceof RecoveryContext) {
                        RecoveryContext rContext = (RecoveryContext)context;
                        p = rContext.getRecoveryValue(Constants.RECOVERY.PID.uri);
                    }
                    if (p == null) {
                        p = this.m_pidGenerator.generatePID(this.m_pidNamespace).toString();
                    } else {
                        logger.debug("Using new PID from recovery context");
                        this.m_pidGenerator.neverGeneratePID(p);
                    }
                }
                catch (Exception e) {
                    throw new GeneralException("Error generating PID", e);
                }
                logger.info("Generated new PID: " + p);
                obj.setPid(p);
            } else {
                logger.debug("Client wants to use existing PID.");
            }
            logger.info("New object PID is {}", (Object)obj.getPid());
            if (this.objectExists(obj.getPid())) {
                throw new ObjectExistsException("The PID '" + obj.getPid() + "' already exists in the registry; the object can't be re-created.");
            }
            logger.debug("Getting new writer with default export format: " + this.m_defaultExportFormat);
            logger.debug("Instantiating a SimpleDOWriter");
            w = new SimpleDOWriter(context, this, this.m_translator, this.m_defaultExportFormat, this.m_storageCharacterEncoding, (DigitalObject)obj);
            this.getWriteLock(obj.getPid());
            DefaultDOManager.populateDC(context, obj, w, nowUTC);
            ValidationUtility.validateReservedDatastreams(w);
            this.registerObject(obj);
            SimpleDOWriter simpleDOWriter = w;
            return simpleDOWriter;
        }
        catch (IOException e) {
            if (w != null) {
                this.releaseWriteLock(obj.getPid());
            }
            throw new GeneralException("Error reading/writing temporary ingest file", e);
        }
        catch (Exception e) {
            if (w != null) {
                this.releaseWriteLock(obj.getPid());
            }
            if (e instanceof ServerException) {
                ServerException se = (ServerException)e;
                throw se;
            }
            throw new GeneralException("Ingest failed: " + e.getClass().getName(), e);
        }
        finally {
            if (tempFile != null) {
                logger.debug("Finally, removing temp file");
                try {
                    tempFile.delete();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void populateDC(Context ctx, DigitalObject obj, DOWriter w, Date nowUTC) throws IOException, ServerException {
        DCFields dcf;
        logger.debug("Adding/Checking default DC datastream");
        Datastream dc = w.GetDatastream("DC", null);
        XMLDatastreamProcessor dcxml = null;
        if (dc == null) {
            dcxml = new XMLDatastreamProcessor("DC");
            dc = dcxml.getDatastream();
            dc.DatastreamID = "DC";
            dc.DSVersionID = "DC1.0";
            dc.DSCreateDT = nowUTC;
            dc.DSLabel = "Dublin Core Record for this object";
            dc.DSMIME = "text/xml";
            dc.DSFormatURI = DefaultDOManager.OAI_DC2_0.uri;
            dc.DSSize = 0L;
            dc.DSState = "A";
            dc.DSVersionable = true;
            dcf = new DCFields();
            if (obj.getLabel() != null && !obj.getLabel().equals("")) {
                dcf.titles().add(new DCField(obj.getLabel()));
            }
            w.addDatastream(dc, dc.DSVersionable);
        } else {
            dcxml = new XMLDatastreamProcessor(dc);
            dcf = new DCFields(new ByteArrayInputStream(dcxml.getXMLContent(ctx)));
        }
        try {
            dcxml.setXMLContent(dcf.getAsXML(obj.getPid()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public void doCommit(boolean cachedObjectRequired, Context context, DigitalObject obj, String logMessage, boolean remove) throws ServerException {
        String pid = obj.getPid();
        if (remove) {
            this.removeObject(obj, false);
        } else {
            if (obj.isNew()) {
                logger.info("Committing addition of " + obj.getPid());
            } else {
                logger.info("Committing modification of " + obj.getPid());
            }
            this.m_objectValidator.validate(context, new SimpleDOReader(null, null, null, null, null, obj));
            try {
                Iterator<String> dsIDIter = obj.datastreamIdIterator();
                while (dsIDIter.hasNext()) {
                    String dsID = dsIDIter.next();
                    Datastream dStream = obj.datastreams(dsID).iterator().next();
                    String controlGroupType = dStream.DSControlGrp;
                    if (!controlGroupType.equalsIgnoreCase("M")) continue;
                    for (Datastream dmc : obj.datastreams(dsID)) {
                        String internalId = pid + "+" + dmc.DatastreamID + "+" + dmc.DSVersionID;
                        if (URL_PROTOCOL.matcher(dmc.DSLocation).matches()) {
                            MIMETypedStream mimeTypedStream;
                            if (dmc.DSLocation.startsWith("uploaded://")) {
                                mimeTypedStream = new MIMETypedStream(null, this.m_management.getTempStream(dmc.DSLocation), null, dmc.DSSize);
                                logger.info("Getting managed datastream from internal uploaded location: " + dmc.DSLocation + " for " + pid);
                            } else if (dmc.DSLocation.startsWith("copy://")) {
                                mimeTypedStream = new MIMETypedStream(null, this.m_permanentStore.retrieveDatastream(dmc.DSLocation.substring(7)), null, dmc.DSSize);
                            } else if (dmc.DSLocation.startsWith("temp://")) {
                                File file = new File(dmc.DSLocation.substring(7));
                                logger.info("Getting base64 decoded datastream spooled from archive for datastream " + dsID + " (" + pid + ")");
                                try {
                                    FileInputStream str = new FileInputStream(file);
                                    mimeTypedStream = new MIMETypedStream(dmc.DSMIME, str, null, file.length());
                                }
                                catch (FileNotFoundException fnfe) {
                                    logger.error("Unable to read temp file created for datastream from archive for " + pid + " / " + dsID, (Throwable)fnfe);
                                    throw new StreamIOException("Error reading from temporary file created for binary content for " + pid + " / " + dsID);
                                }
                            } else {
                                ContentManagerParams params = new ContentManagerParams(DOTranslationUtility.makeAbsoluteURLs(dmc.DSLocation.toString()), dmc.DSMIME, null, null);
                                params.setContext(context);
                                mimeTypedStream = this.m_contentManager.getExternalContent(params);
                                logger.info("Getting managed datastream from remote location: " + dmc.DSLocation + " (" + pid + " / " + dsID + ")");
                            }
                            Map<String, String> dsHints = this.m_hintProvider.getHintsForAboutToBeStoredDatastream(obj, dmc.DatastreamID);
                            if (obj.isNew()) {
                                dmc.DSSize = this.m_permanentStore.addDatastream(internalId, mimeTypedStream.getStream(), dsHints);
                            } else {
                                try {
                                    dmc.DSSize = this.m_permanentStore.addDatastream(internalId, mimeTypedStream.getStream(), dsHints);
                                }
                                catch (ObjectAlreadyInLowlevelStorageException oailse) {
                                    dmc.DSSize = this.m_permanentStore.replaceDatastream(internalId, mimeTypedStream.getStream(), dsHints);
                                }
                            }
                            if (mimeTypedStream == null) continue;
                            mimeTypedStream.close();
                            if (dmc.DSLocation.startsWith("temp://")) {
                                File file = new File(dmc.DSLocation.substring(7));
                                if (file.exists()) {
                                    if (!file.delete()) {
                                        logger.warn("Failed to remove temp file, marked for deletion when VM closes: " + file.toString());
                                        file.deleteOnExit();
                                    }
                                } else {
                                    logger.warn("Cannot delete temp file as it no longer exists: " + file.getAbsolutePath());
                                }
                            }
                            dmc.DSLocation = internalId;
                            dmc.DSLocationType = "INTERNAL_ID";
                            logger.info("Replaced managed datastream location with internal id: " + internalId);
                            continue;
                        }
                        if (internalId.equals(dmc.DSLocation)) continue;
                        logger.error("Unrecognized DSLocation \"" + dmc.DSLocation + "\" given for datastream " + dmc.DatastreamID + " of object " + pid);
                    }
                }
                if (!obj.isNew()) {
                    this.deletePurgedDatastreams(obj, context);
                }
                obj.setLastModDate(Server.getCurrentDate(context));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                logger.debug("Serializing digital object for persistent storage " + pid);
                this.m_translator.serialize(obj, out, this.m_defaultStorageFormat, this.m_storageCharacterEncoding, 3);
                if (logger.isDebugEnabled()) {
                    ByteArrayInputStream inV = new ByteArrayInputStream(out.toByteArray());
                    logger.debug("Final Validation (storage phase)");
                    this.m_validator.validate(inV, this.m_defaultStorageFormat, 0, "store");
                }
                this.m_translator.deserialize(new ByteArrayInputStream(out.toByteArray()), new BasicDigitalObject(), this.m_defaultStorageFormat, this.m_storageCharacterEncoding, 3);
                if (this.m_resourceIndex != null && this.m_resourceIndex.getIndexLevel() != 0) {
                    logger.info("Adding to ResourceIndex");
                    if (obj.isNew()) {
                        this.m_resourceIndex.addObject(new SimpleDOReader(null, null, null, null, null, obj));
                    } else {
                        this.m_resourceIndex.modifyObject(this.getReader(false, null, obj.getPid()), new SimpleDOReader(null, null, null, null, null, obj));
                    }
                    logger.debug("Finished adding " + pid + " to ResourceIndex.");
                }
                logger.debug("Storing digital object");
                Map<String, String> objectHints = this.m_hintProvider.getHintsForAboutToBeStoredObject(obj);
                if (obj.isNew()) {
                    this.m_permanentStore.addObject(obj.getPid(), new ByteArrayInputStream(out.toByteArray()), objectHints);
                } else {
                    this.m_permanentStore.replaceObject(obj.getPid(), new ByteArrayInputStream(out.toByteArray()), objectHints);
                }
                if (this.m_readerCache != null) {
                    this.m_readerCache.remove(pid);
                }
                logger.debug("Updating registry for " + pid);
                Connection conn = null;
                PreparedStatement s = null;
                ResultSet results = null;
                try {
                    conn = this.m_connectionPool.getReadWriteConnection();
                    String query = "SELECT systemVersion FROM doRegistry WHERE doPID=?";
                    s = conn.prepareStatement(query);
                    s.setString(1, obj.getPid());
                    results = s.executeQuery();
                    if (!results.next()) {
                        throw new ObjectNotFoundException("Error creating replication job: The requested object " + pid + " doesn't exist in the registry.");
                    }
                    int systemVersion = results.getInt("systemVersion");
                    query = "UPDATE doRegistry SET systemVersion=" + ++systemVersion + " WHERE doPID=?";
                    s = conn.prepareStatement(query);
                    s.setString(1, obj.getPid());
                    s.executeUpdate();
                    if (obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
                        this.updateDeploymentMap(obj, conn, false);
                    }
                }
                catch (SQLException sqle) {
                    throw new StorageDeviceException("Error creating replication job for " + pid + ": " + sqle.getMessage(), sqle);
                }
                finally {
                    try {
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (s != null) {
                                s.close();
                            }
                            if (conn != null) {
                                this.m_connectionPool.free(conn);
                            }
                            results = null;
                            s = null;
                        }
                        catch (SQLException sqle) {
                            throw new StorageDeviceException("Unexpected error from SQL database for " + pid + ": " + sqle.getMessage(), sqle);
                        }
                    }
                    catch (Throwable throwable) {
                        results = null;
                        s = null;
                        throw throwable;
                    }
                }
                logger.info("Updating dissemination index for " + pid);
                String whichIndex = "FieldSearch";
                try {
                    logger.info("Updating FieldSearch index");
                    this.m_fieldSearch.update(new SimpleDOReader(null, null, null, null, null, obj));
                }
                catch (ServerException se) {
                    logger.error("Error updating " + whichIndex + " index for " + pid, (Throwable)se);
                    throw se;
                }
                catch (Throwable th) {
                    String msg = "Error updating " + whichIndex + " index for " + pid;
                    logger.error(msg, th);
                    throw new GeneralException(msg, th);
                }
            }
            catch (Throwable th) {
                if (obj.isNew()) {
                    try {
                        this.removeObject(obj, true);
                    }
                    catch (Exception e) {
                        logger.warn("Error while cleaning up after failed add for " + pid, (Throwable)e);
                    }
                }
                if (th instanceof ServerException) {
                    throw (ServerException)th;
                }
                throw new GeneralException("Unable to add or modify object " + pid + " (commit canceled)", th);
            }
        }
    }

    private void removeObject(DigitalObject obj, boolean failSafe) throws ServerException {
        String pid = obj.getPid();
        logger.info("Committing removal of " + pid);
        if (this.m_resourceIndex.getIndexLevel() != 0) {
            try {
                logger.info("Deleting " + pid + " from ResourceIndex");
                this.m_resourceIndex.deleteObject(new SimpleDOReader(null, null, null, null, null, obj));
                logger.debug("Finished deleting " + pid + " from ResourceIndex");
            }
            catch (ServerException se) {
                if (failSafe) {
                    logger.warn("Object " + pid + " couldn't be removed from ResourceIndex (" + se.getMessage() + "), but that might be ok; continuing with purge");
                }
                logger.error("Object " + pid + " couldn't be removed from ResourceIndex (" + se.getMessage() + ")");
            }
        }
        Iterator<String> dsIDIter = obj.datastreamIdIterator();
        while (dsIDIter.hasNext()) {
            String dsID = dsIDIter.next();
            String controlGroupType = obj.datastreams((String)dsID).iterator().next().DSControlGrp;
            if (!controlGroupType.equalsIgnoreCase("M")) continue;
            for (Datastream dmc : obj.datastreams(dsID)) {
                String id = obj.getPid() + "+" + dmc.DatastreamID + "+" + dmc.DSVersionID;
                logger.info("Deleting managed datastream: " + id + " for " + pid);
                try {
                    this.m_permanentStore.removeDatastream(id);
                }
                catch (LowlevelStorageException llse) {
                    if (failSafe) {
                        logger.warn("Error attempting removal of managed content datastream " + id + " for " + pid + " (but that might be ok during a clean-up): ", (Throwable)llse);
                        continue;
                    }
                    logger.error("Error attempting removal of managed content datastream " + id + " for " + pid + ": ", (Throwable)llse);
                }
            }
        }
        try {
            this.m_permanentStore.removeObject(obj.getPid());
        }
        catch (ObjectNotInLowlevelStorageException onilse) {
            if (failSafe) {
                logger.warn("Object " + pid + " wasn't found in permanent low level " + "store, but that might be ok; continuing with purge");
            }
            logger.error("Object " + pid + " wasn't found in permanent low level " + "store");
        }
        if (this.m_readerCache != null) {
            this.m_readerCache.remove(obj.getPid());
        }
        try {
            this.unregisterObject(obj);
        }
        catch (ServerException se) {
            if (failSafe) {
                logger.warn("Object " + pid + " couldn't be removed from registry, but that might be ok; continuing with purge");
            }
            logger.error("Object " + pid + " couldn't be removed from registry");
        }
        try {
            logger.info("Deleting " + pid + " from FieldSearch index");
            this.m_fieldSearch.delete(obj.getPid());
        }
        catch (ServerException se) {
            if (failSafe) {
                logger.warn("Object " + pid + " couldn't be removed from FieldSearch index (" + se.getMessage() + "), but that might be ok; continuing with purge");
            }
            logger.error("Object " + pid + " couldn't be removed from FieldSearch index (" + se.getMessage() + ")");
        }
    }

    private Set<Long> getDatastreamDates(Iterable<Datastream> ds) {
        HashSet<Long> dates = new HashSet<Long>();
        for (Datastream d : ds) {
            dates.add(d.DSCreateDT.getTime());
        }
        return dates;
    }

    private void deletePurgedDatastreams(DigitalObject obj, Context context) {
        try {
            Datastream[] datastreams;
            DOReader reader = this.getReader(false, context, obj.getPid());
            for (Datastream element : datastreams = reader.GetDatastreams(null, null)) {
                Date[] dates;
                if (!element.DSControlGrp.equals("M")) continue;
                String dsID = element.DatastreamID;
                Set<Long> newVersionDates = this.getDatastreamDates(obj.datastreams(dsID));
                for (Date dt : dates = reader.getDatastreamVersions(dsID)) {
                    if (newVersionDates.contains(dt.getTime())) continue;
                    String token = obj.getPid() + "+" + dsID + "+" + reader.GetDatastream((String)dsID, (Date)dt).DSVersionID;
                    try {
                        this.m_permanentStore.removeDatastream(token);
                        logger.info("Removed purged datastream version from low level storage (token = " + token + ")");
                    }
                    catch (Exception e) {
                        logger.error("Error removing purged datastream version from low level storage (token = " + token + ")", (Throwable)e);
                    }
                }
            }
        }
        catch (ServerException e) {
            logger.error("Error reading " + obj.getPid() + "; if any" + " managed datastreams were purged, they were not removed " + " from low level storage.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean objectExists(String pid) throws StorageDeviceException {
        logger.debug("Checking if " + pid + " already exists");
        Connection conn = null;
        PreparedStatement s = null;
        ResultSet results = null;
        try {
            String query = "SELECT doPID FROM doRegistry WHERE doPID=?";
            conn = this.m_connectionPool.getReadOnlyConnection();
            s = conn.prepareStatement(query);
            s.setString(1, pid);
            results = s.executeQuery();
            boolean bl = results.next();
            return bl;
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Unexpected error from SQL database: " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                    if (conn != null) {
                        this.m_connectionPool.free(conn);
                    }
                    results = null;
                    s = null;
                }
                catch (SQLException sqle) {
                    throw new StorageDeviceException("Unexpected error from SQL database: " + sqle.getMessage(), sqle);
                }
            }
            catch (Throwable throwable) {
                results = null;
                s = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerObject(DigitalObject obj) throws StorageDeviceException {
        String theLabel = "the label field is no longer used";
        String ownerID = "the ownerID field is no longer used";
        String pid = obj.getPid();
        Connection conn = null;
        Statement st = null;
        try {
            String query = "INSERT INTO doRegistry (doPID, ownerId, label) VALUES (?, ?, ?)";
            conn = this.m_connectionPool.getReadWriteConnection();
            st = conn.prepareStatement(query);
            st.setString(1, pid);
            st.setString(2, ownerID);
            st.setString(3, theLabel);
            st.executeUpdate();
            return;
        }
        catch (SQLException sqle) {
            try {
                this.unregisterObject(obj);
                throw new StorageDeviceException("Unexpected error from SQL database while registering object: " + sqle.getMessage(), sqle);
            }
            catch (Throwable th) {
                // empty catch block
            }
            throw new StorageDeviceException("Unexpected error from SQL database while registering object: " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                try {
                    if (st != null) {
                        st.close();
                    }
                    if (conn != null) {
                        this.m_connectionPool.free(conn);
                    }
                    st = null;
                }
                catch (Exception sqle) {
                    throw new StorageDeviceException("Unexpected error from SQL database while registering object: " + sqle.getMessage(), sqle);
                }
            }
            catch (Throwable throwable) {
                st = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unregisterObject(DigitalObject obj) throws StorageDeviceException {
        String pid = obj.getPid();
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.m_connectionPool.getReadWriteConnection();
            String query = "DELETE FROM doRegistry WHERE doPID=?";
            st = conn.prepareStatement(query);
            st.setString(1, pid);
            st.executeUpdate();
            if (!obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) return;
            this.updateDeploymentMap(obj, conn, true);
            return;
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Unexpected error from SQL database while unregistering object: " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                try {
                    if (st != null) {
                        st.close();
                    }
                    if (conn != null) {
                        this.m_connectionPool.free(conn);
                    }
                    st = null;
                }
                catch (Exception sqle) {
                    throw new StorageDeviceException("Unexpected error from SQL database while unregistering object: " + sqle.getMessage(), sqle);
                }
            }
            catch (Throwable throwable) {
                st = null;
                throw throwable;
            }
        }
    }

    @Override
    public String[] listObjectPIDs(Context context) throws StorageDeviceException {
        return this.getPIDs("WHERE systemVersion > 0");
    }

    public static String toSql(String name, String in) {
        if (in.indexOf("\\") != -1) {
            StringBuffer out = new StringBuffer();
            out.append("'");
            boolean needLike = false;
            boolean needEscape = false;
            boolean lastWasEscape = false;
            for (int i = 0; i < in.length(); ++i) {
                char c = in.charAt(i);
                if (!lastWasEscape && c == '\\') {
                    lastWasEscape = true;
                    continue;
                }
                char nextChar = '!';
                boolean useNextChar = false;
                if (!lastWasEscape) {
                    if (c == '?') {
                        out.append('_');
                        needLike = true;
                    } else if (c == '*') {
                        out.append('%');
                        needLike = true;
                    } else {
                        nextChar = c;
                        useNextChar = true;
                    }
                } else {
                    nextChar = c;
                    useNextChar = true;
                }
                if (useNextChar) {
                    if (nextChar == '\"') {
                        out.append("\\\"");
                        needEscape = true;
                    } else if (nextChar == '\'') {
                        out.append("\\'");
                        needEscape = true;
                    } else if (nextChar == '%') {
                        out.append("\\%");
                        needEscape = true;
                    } else if (nextChar == '_') {
                        out.append("\\_");
                        needEscape = true;
                    } else {
                        out.append(nextChar);
                    }
                }
                lastWasEscape = false;
            }
            out.append("'");
            if (needLike) {
                out.insert(0, " LIKE ");
            } else {
                out.insert(0, " = ");
            }
            out.insert(0, name);
            if (needEscape) {
                out.insert(0, ' ');
            }
            return out.toString();
        }
        StringBuffer out = new StringBuffer();
        out.append("'");
        boolean needLike = false;
        boolean needEscape = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '?') {
                out.append('_');
                needLike = true;
                continue;
            }
            if (c == '*') {
                out.append('%');
                needLike = true;
                continue;
            }
            if (c == '\"') {
                out.append("\\\"");
                needEscape = true;
                continue;
            }
            if (c == '\'') {
                out.append("\\'");
                needEscape = true;
                continue;
            }
            if (c == '%') {
                out.append("\\%");
                needEscape = true;
                continue;
            }
            if (c == '_') {
                out.append("\\_");
                needEscape = true;
                continue;
            }
            out.append(c);
        }
        out.append("'");
        if (needLike) {
            out.insert(0, " LIKE ");
        } else {
            out.insert(0, " = ");
        }
        out.insert(0, name);
        if (needEscape) {
            out.insert(0, ' ');
        }
        return out.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getPIDs(String whereClause) throws StorageDeviceException {
        ArrayList<String> pidList = new ArrayList<String>();
        Connection conn = null;
        Statement s = null;
        ResultSet results = null;
        try {
            conn = this.m_connectionPool.getReadOnlyConnection();
            String query = "SELECT doPID FROM doRegistry " + whereClause;
            s = conn.prepareStatement(query);
            logger.debug("Executing db query: " + query);
            results = s.executeQuery();
            while (results.next()) {
                pidList.add(results.getString("doPID"));
            }
            String[] ret = new String[pidList.size()];
            Iterator pidIter = pidList.iterator();
            int i = 0;
            while (pidIter.hasNext()) {
                ret[i++] = (String)pidIter.next();
            }
            String[] stringArray = ret;
            return stringArray;
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Unexpected error from SQL database: " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                    if (conn != null) {
                        this.m_connectionPool.free(conn);
                    }
                    results = null;
                    s = null;
                }
                catch (SQLException sqle) {
                    throw new StorageDeviceException("Unexpected error from SQL database: " + sqle.getMessage(), sqle);
                }
            }
            catch (Throwable throwable) {
                results = null;
                s = null;
                throw throwable;
            }
        }
    }

    @Override
    public FieldSearchResult findObjects(Context context, String[] resultFields, int maxResults, FieldSearchQuery query) throws ServerException {
        return this.m_fieldSearch.findObjects(resultFields, maxResults, query);
    }

    @Override
    public FieldSearchResult resumeFindObjects(Context context, String sessionToken) throws ServerException {
        return this.m_fieldSearch.resumeFindObjects(sessionToken);
    }

    @Override
    public String[] getNextPID(int numPIDs, String namespace) throws ServerException {
        if (numPIDs < 1) {
            numPIDs = 1;
        }
        String[] pidList = new String[numPIDs];
        if (namespace == null || namespace.equals("")) {
            namespace = this.m_pidNamespace;
        }
        try {
            for (int i = 0; i < numPIDs; ++i) {
                pidList[i] = this.m_pidGenerator.generatePID(namespace).toString();
            }
            return pidList;
        }
        catch (IOException ioe) {
            throw new GeneralException("DefaultDOManager.getNextPID: Error generating PID, PIDGenerator returned unexpected error: (" + ioe.getClass().getName() + ") - " + ioe.getMessage());
        }
    }

    @Override
    public void reservePIDs(String[] pidList) throws ServerException {
        try {
            for (String element : pidList) {
                this.m_pidGenerator.neverGeneratePID(element);
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error reserving PIDs", e);
        }
    }

    @Override
    public String getRepositoryHash() throws ServerException {
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getReadOnlyConnection();
            StringBuffer hash = new StringBuffer();
            hash.append(this.getNumObjectsWithVersion(conn, 0));
            hash.append("|");
            hash.append(this.getLatestModificationDate(conn));
            String string = hash.toString();
            return string;
        }
        catch (SQLException e) {
            throw new GeneralException("SQL error encountered while computing repository hash", e);
        }
        finally {
            if (conn != null) {
                this.m_connectionPool.free(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumObjectsWithVersion(Connection conn, int n) throws SQLException {
        Statement st = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT COUNT(*) FROM doRegistry");
            if (n > 0) {
                query.append(" WHERE systemVersion = " + n);
            }
            st = conn.prepareStatement(query.toString());
            ResultSet results = st.executeQuery();
            results.next();
            int n2 = results.getInt(1);
            return n2;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLatestModificationDate(Connection conn) throws SQLException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement("SELECT MAX(mDate) FROM doFields ");
            ResultSet results = st.executeQuery();
            if (results.next()) {
                long l = results.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private static class ServiceContext {
        public final String cModel;
        public final String sDef;
        private final String _val;

        private ServiceContext(String cModelPid, String sDefPid) {
            this.cModel = cModelPid;
            this.sDef = sDefPid;
            this._val = "(" + cModelPid + "," + sDefPid + ")";
        }

        public static ServiceContext getInstance(String cModel, String sDef) {
            return new ServiceContext(cModel, sDef);
        }

        public String toString() {
            return this._val;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ServiceContext)) {
                return false;
            }
            return this._val.equals(((ServiceContext)o)._val);
        }

        public int hashCode() {
            return this._val.hashCode();
        }
    }

    private class ModelDeploymentMap {
        private final Map<ServiceContext, Map<String, Long>> map = new ConcurrentHashMap<ServiceContext, Map<String, Long>>();

        private ModelDeploymentMap() {
        }

        public String putDeployment(ServiceContext cxt, String sDep, long lastModDate) {
            if (!this.map.containsKey(cxt)) {
                this.map.put(cxt, new HashMap());
            }
            this.map.get(cxt).put(sDep, lastModDate);
            return this.getDeployment(cxt);
        }

        public String removeDeployment(ServiceContext cxt, String sDep) {
            Map<String, Long> deployments = this.map.get(cxt);
            if (deployments != null) {
                deployments.remove(sDep);
            }
            return this.getDeployment(cxt);
        }

        public String getDeployment(ServiceContext cxt) {
            if (this.map.containsKey(cxt)) {
                String sDep = null;
                int count = 0;
                long first = -1L;
                for (Map.Entry<String, Long> dep : this.map.get(cxt).entrySet()) {
                    if (dep.getValue() >= first && first >= 0L) continue;
                    first = dep.getValue();
                    sDep = dep.getKey();
                    ++count;
                }
                if (count > 1) {
                    logger.info("More than one service deployment specified for sDef " + cxt.sDef + " in model " + cxt.cModel + ".  Using the one with the EARLIEST modification date.");
                }
                return sDep;
            }
            return null;
        }

        public Set<ServiceContext> getContextFor(String sDep) {
            HashSet<ServiceContext> cxt = new HashSet<ServiceContext>();
            for (Map.Entry<ServiceContext, Map<String, Long>> dep : this.map.entrySet()) {
                if (!dep.getValue().keySet().contains(sDep)) continue;
                cxt.add(dep.getKey());
            }
            return cxt;
        }
    }
}

