/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.DisseminationException;
import org.fcrepo.server.errors.MethodNotFoundException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StorageException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDOReader
implements DOReader {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDOReader.class);
    protected final DigitalObject m_obj;
    private final Context m_context;
    private final RepositoryReader m_repoReader;
    private final DOTranslator m_translator;
    private final String m_exportFormat;
    private String m_storageFormat;
    private final SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public SimpleDOReader(Context context, RepositoryReader repoReader, DOTranslator translator, String exportFormat, String storageFormat, String encoding, InputStream serializedObject) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        this.m_context = context;
        this.m_repoReader = repoReader;
        this.m_translator = translator;
        this.m_exportFormat = exportFormat;
        this.m_storageFormat = storageFormat;
        this.m_obj = new BasicDigitalObject();
        this.m_translator.deserialize(serializedObject, this.m_obj, this.m_storageFormat, encoding, 0);
    }

    public SimpleDOReader(Context context, RepositoryReader repoReader, DOTranslator translator, String exportFormat, String encoding, DigitalObject obj) {
        this.m_context = context;
        this.m_repoReader = repoReader;
        this.m_translator = translator;
        this.m_exportFormat = exportFormat;
        this.m_obj = obj;
    }

    @Override
    public DigitalObject getObject() {
        return this.m_obj;
    }

    @Override
    public Date getCreateDate() {
        return this.m_obj.getCreateDate();
    }

    @Override
    public Date getLastModDate() {
        return this.m_obj.getLastModDate();
    }

    @Override
    public String getOwnerId() {
        return this.m_obj.getOwnerId();
    }

    @Override
    public List<AuditRecord> getAuditRecords() {
        return this.m_obj.getAuditRecords();
    }

    @Override
    public InputStream GetObjectXML() throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        this.m_translator.serialize(this.m_obj, bytes, this.m_storageFormat, "UTF-8", 3);
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    @Override
    public InputStream Export(String format, String exportContext) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        int transContext;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        logger.debug("Export context: " + exportContext);
        if (exportContext == null || exportContext.equals("") || exportContext.equalsIgnoreCase("default")) {
            transContext = 1;
        } else if (exportContext.equalsIgnoreCase("public")) {
            transContext = 1;
        } else if (exportContext.equalsIgnoreCase("migrate")) {
            transContext = 2;
        } else if (exportContext.equalsIgnoreCase("archive")) {
            transContext = 4;
        } else {
            throw new UnsupportedTranslationException("Export context " + exportContext + " is not valid.");
        }
        if (format == null || format.equals("") || format.equalsIgnoreCase("default")) {
            logger.debug("Export in default format: " + this.m_exportFormat);
            this.m_translator.serialize(this.m_obj, bytes, this.m_exportFormat, "UTF-8", transContext);
        } else {
            logger.debug("Export in format: " + format);
            this.m_translator.serialize(this.m_obj, bytes, format, "UTF-8", transContext);
        }
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    @Override
    @Deprecated
    public InputStream ExportObject(String format, String exportContext) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        return this.Export(format, exportContext);
    }

    @Override
    public String GetObjectPID() {
        return this.m_obj.getPid();
    }

    @Override
    public String GetObjectLabel() {
        return this.m_obj.getLabel();
    }

    @Override
    public String GetObjectState() {
        if (this.m_obj.getState() == null) {
            return "A";
        }
        return this.m_obj.getState();
    }

    @Override
    public List<String> getContentModels() throws ServerException {
        ArrayList<String> list = new ArrayList<String>();
        for (RelationshipTuple rel : this.getRelationships((PredicateNode)Constants.MODEL.HAS_MODEL, null)) {
            list.add(rel.object);
        }
        return list;
    }

    @Override
    public boolean hasContentModel(ObjectNode contentModel) throws ServerException {
        return this.hasRelationship((PredicateNode)Constants.MODEL.HAS_MODEL, contentModel);
    }

    @Override
    public String[] ListDatastreamIDs(String state) {
        Iterator<String> iter = this.m_obj.datastreamIdIterator();
        ArrayList<String> al = new ArrayList<String>();
        while (iter.hasNext()) {
            String dsId = iter.next();
            if (state == null) {
                al.add(dsId);
                continue;
            }
            Datastream ds = this.GetDatastream(dsId, null);
            if (!ds.DSState.equals(state)) continue;
            al.add(dsId);
        }
        iter = al.iterator();
        String[] out = new String[al.size()];
        int i = 0;
        while (iter.hasNext()) {
            out[i] = iter.next();
            ++i;
        }
        return out;
    }

    @Override
    public Datastream getDatastream(String dsID, String versionID) {
        for (Datastream ds : this.m_obj.datastreams(dsID)) {
            if (!ds.DSVersionID.equals(versionID)) continue;
            return ds;
        }
        return null;
    }

    @Override
    public Datastream GetDatastream(String datastreamID, Date versDateTime) {
        Datastream result = null;
        long bestTimeDifference = Long.MAX_VALUE;
        long latestCreateTime = -1L;
        long vTime = -1L;
        if (versDateTime != null) {
            vTime = versDateTime.getTime();
        }
        for (Datastream ds : this.m_obj.datastreams(datastreamID)) {
            if (versDateTime == null) {
                if (ds.DSCreateDT != null && ds.DSCreateDT.getTime() <= latestCreateTime && result != null) continue;
                result = ds;
                if (ds.DSCreateDT == null) continue;
                latestCreateTime = ds.DSCreateDT.getTime();
                continue;
            }
            long diff = ds.DSCreateDT == null ? vTime : vTime - ds.DSCreateDT.getTime();
            if (diff < 0L || diff >= bestTimeDifference) continue;
            bestTimeDifference = diff;
            result = ds;
        }
        return result;
    }

    @Override
    public Date[] getDatastreamVersions(String datastreamID) {
        ArrayList<Date> versionDates = new ArrayList<Date>();
        for (Datastream d : this.m_obj.datastreams(datastreamID)) {
            versionDates.add(d.DSCreateDT);
        }
        return versionDates.toArray(new Date[0]);
    }

    @Override
    public Datastream[] GetDatastreams(Date versDateTime, String state) {
        String[] ids = this.ListDatastreamIDs(null);
        ArrayList<Datastream> al = new ArrayList<Datastream>();
        for (String element : ids) {
            Datastream ds = this.GetDatastream(element, versDateTime);
            if (ds == null || state != null && !ds.DSState.equals(state)) continue;
            al.add(ds);
        }
        Datastream[] out = new Datastream[al.size()];
        Iterator iter = al.iterator();
        int i = 0;
        while (iter.hasNext()) {
            out[i] = (Datastream)iter.next();
            ++i;
        }
        return out;
    }

    @Override
    public String[] getObjectHistory(String PID2) {
        String[] dsIDs = this.ListDatastreamIDs(null);
        TreeSet<String> modDates = new TreeSet<String>();
        for (String element : dsIDs) {
            Date[] dsDates;
            for (Date element2 : dsDates = this.getDatastreamVersions(element)) {
                modDates.add(DateUtility.convertDateToString((Date)element2));
            }
        }
        return modDates.toArray(new String[0]);
    }

    private MethodDef[] listMethods(String sDefPID, ServiceDefinitionReader sDefReader, Date versDateTime) throws MethodNotFoundException, ServerException {
        if (sDefPID.equalsIgnoreCase("fedora-system:1") || sDefPID.equalsIgnoreCase("fedora-system:3")) {
            throw new MethodNotFoundException("[getObjectMethods] The object, " + this.m_obj.getPid() + ", will not report on dynamic method definitions " + "at this time (fedora-system:1 and fedora-system:3.");
        }
        if (sDefReader == null) {
            return null;
        }
        MethodDef[] methods = sDefReader.getAbstractMethods(versDateTime);
        for (int i = 0; i < methods.length; ++i) {
            methods[i].methodParms = this.filterParms(methods[i]);
        }
        return methods;
    }

    private MethodParmDef[] filterParms(MethodDef method) {
        ArrayList<MethodParmDef> filteredParms = new ArrayList<MethodParmDef>();
        for (MethodParmDef element : method.methodParms) {
            if (!element.parmType.equalsIgnoreCase("fedora:userInputType")) continue;
            filteredParms.add(element);
        }
        return filteredParms.toArray(new MethodParmDef[0]);
    }

    protected String getWhenString(Date versDateTime) {
        if (versDateTime != null) {
            return this.m_formatter.format(versDateTime);
        }
        return "the current time";
    }

    @Override
    public ObjectMethodsDef[] listMethods(Date versDateTime) throws ServerException {
        ArrayList<MethodDef> methodList = new ArrayList<MethodDef>();
        ArrayList<String> sDefIDList = new ArrayList<String>();
        ServiceDefinitionReader sDefReader = null;
        for (String cm : this.getContentModels()) {
            DOReader cmReader;
            if (Models.contains((String)cm)) continue;
            String cModelPid = cm.substring(12);
            if ("self".equals(cModelPid)) {
                cmReader = this;
                cModelPid = this.GetObjectPID();
            } else {
                try {
                    cmReader = this.m_repoReader.getReader(false, this.m_context, cModelPid);
                }
                catch (StorageException e) {
                    throw new DisseminationException(null, "Content Model Object " + cModelPid + " does not exist.", null, null, e);
                }
            }
            Set<RelationshipTuple> hasServiceRels = cmReader.getRelationships((PredicateNode)Constants.MODEL.HAS_SERVICE, null);
            for (RelationshipTuple element2 : hasServiceRels) {
                String sDefPid = element2.getObjectPID();
                try {
                    sDefReader = this.m_repoReader.getServiceDefinitionReader(false, this.m_context, sDefPid);
                }
                catch (StorageException se) {
                    throw new DisseminationException("Service definition " + sDefPid + " required by Content Model " + cModelPid + " not found.");
                }
                MethodDef[] methods = this.listMethods(sDefPid, sDefReader, versDateTime);
                if (methods == null) continue;
                for (MethodDef element3 : methods) {
                    methodList.add(element3);
                    sDefIDList.add(element2.getObjectPID());
                }
            }
        }
        ObjectMethodsDef[] ret = new ObjectMethodsDef[methodList.size()];
        for (int i = 0; i < methodList.size(); ++i) {
            MethodDef def = (MethodDef)methodList.get(i);
            ret[i] = new ObjectMethodsDef();
            ret[i].PID = this.GetObjectPID();
            ret[i].sDefPID = (String)sDefIDList.get(i);
            ret[i].methodName = def.methodName;
            ret[i].methodParmDefs = def.methodParms;
            ret[i].asOfDate = versDateTime;
        }
        return ret;
    }

    @Override
    public boolean hasRelationship(SubjectNode subject, PredicateNode predicate, ObjectNode object) {
        return this.m_obj.hasRelationship(subject, predicate, object);
    }

    @Override
    public boolean hasRelationship(PredicateNode predicate, ObjectNode object) {
        return this.m_obj.hasRelationship(predicate, object);
    }

    @Override
    public Set<RelationshipTuple> getRelationships(SubjectNode subject, PredicateNode predicate, ObjectNode object) {
        return this.m_obj.getRelationships(subject, predicate, object);
    }

    @Override
    public Set<RelationshipTuple> getRelationships(PredicateNode predicate, ObjectNode object) {
        return this.m_obj.getRelationships(predicate, object);
    }

    @Override
    public Set<RelationshipTuple> getRelationships() {
        return this.m_obj.getRelationships();
    }
}

