/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.InputStream;
import java.util.Date;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;

public class SimpleServiceAwareReader
extends SimpleDOReader {
    public SimpleServiceAwareReader(Context context, RepositoryReader repoReader, DOTranslator translator, String exportFormat, String storageFormat, String encoding, InputStream serializedObject) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        super(context, repoReader, translator, exportFormat, storageFormat, encoding, serializedObject);
    }

    public SimpleServiceAwareReader(Context context, RepositoryReader repoReader, DOTranslator translator, String exportFormat, String encoding, DigitalObject obj) {
        super(context, repoReader, translator, exportFormat, encoding, obj);
    }

    protected DatastreamXMLMetadata getWSDLDatastream(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException {
        Datastream ds = this.GetDatastream("WSDL", versDateTime);
        if (ds == null) {
            throw new DatastreamNotFoundException("The object, " + this.GetObjectPID() + " does not have a WSDL datastream" + " existing at " + this.getWhenString(versDateTime));
        }
        DatastreamXMLMetadata wsdlDS = null;
        try {
            wsdlDS = (DatastreamXMLMetadata)ds;
        }
        catch (Throwable th) {
            throw new ObjectIntegrityException("The object, " + this.GetObjectPID() + " has a WSDL datastream existing at " + this.getWhenString(versDateTime) + ", but it's not an " + "XML metadata datastream");
        }
        return wsdlDS;
    }

    protected DatastreamXMLMetadata getMethodMapDatastream(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException {
        Datastream ds = this.GetDatastream("METHODMAP", versDateTime);
        if (ds == null) {
            throw new DatastreamNotFoundException("The object, " + this.GetObjectPID() + " does not have a METHODMAP datastream" + " existing at " + this.getWhenString(versDateTime));
        }
        DatastreamXMLMetadata mmapDS = null;
        try {
            mmapDS = (DatastreamXMLMetadata)ds;
        }
        catch (Throwable th) {
            throw new ObjectIntegrityException("The object, " + this.GetObjectPID() + " has a METHODMAP datastream existing at " + this.getWhenString(versDateTime) + ", but it's not an " + "XML metadata datastream");
        }
        return mmapDS;
    }

    protected DatastreamXMLMetadata getDSInputSpecDatastream(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException {
        Datastream ds = this.GetDatastream("DSINPUTSPEC", versDateTime);
        if (ds == null) {
            throw new DatastreamNotFoundException("The object, " + this.GetObjectPID() + " does not have a DSINPUTSPEC datastream" + " existing at " + this.getWhenString(versDateTime));
        }
        DatastreamXMLMetadata dsInSpecDS = null;
        try {
            dsInSpecDS = (DatastreamXMLMetadata)ds;
        }
        catch (Throwable th) {
            throw new ObjectIntegrityException("The object, " + this.GetObjectPID() + " has a DSINPUTSPEC datastream existing at " + this.getWhenString(versDateTime) + ", but it's not an " + "XML metadata datastream");
        }
        return dsInSpecDS;
    }
}

