/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.MethodNotFoundException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.SimpleServiceAwareReader;
import org.fcrepo.server.storage.service.ServiceMapper;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.DeploymentDSBindSpec;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.MethodDefOperationBind;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.xml.sax.InputSource;

public class SimpleServiceDeploymentReader
extends SimpleServiceAwareReader
implements ServiceDeploymentReader {
    private final ServiceMapper serviceMapper = new ServiceMapper(this.GetObjectPID());

    public SimpleServiceDeploymentReader(Context context, RepositoryReader repoReader, DOTranslator translator, String exportFormat, String storageFormat, String encoding, InputStream serializedObject) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        super(context, repoReader, translator, exportFormat, storageFormat, encoding, serializedObject);
    }

    public SimpleServiceDeploymentReader(Context context, RepositoryReader repoReader, DOTranslator translator, String exportFormat, String encoding, DigitalObject obj) {
        super(context, repoReader, translator, exportFormat, encoding, obj);
    }

    @Override
    public MethodDef[] getServiceMethods(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        return this.serviceMapper.getMethodDefs(new InputSource(new ByteArrayInputStream(this.getMethodMapDatastream((Date)versDateTime).xmlContent)));
    }

    @Override
    public MethodParmDef[] getServiceMethodParms(String methodName, Date versDateTime) throws MethodNotFoundException, ServerException {
        return this.getParms(this.getServiceMethods(versDateTime), methodName);
    }

    @Override
    public MethodDefOperationBind[] getServiceMethodBindings(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        return this.serviceMapper.getMethodDefBindings(new InputSource(new ByteArrayInputStream(this.getWSDLDatastream((Date)versDateTime).xmlContent)), new InputSource(new ByteArrayInputStream(this.getMethodMapDatastream((Date)versDateTime).xmlContent)));
    }

    @Override
    public DeploymentDSBindSpec getServiceDSInputSpec(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        return this.serviceMapper.getDSInputSpec(new InputSource(new ByteArrayInputStream(this.getDSInputSpecDatastream((Date)versDateTime).xmlContent)));
    }

    @Override
    public InputStream getServiceMethodsXML(Date versDateTime) throws DatastreamNotFoundException, ObjectIntegrityException {
        return new ByteArrayInputStream(this.getMethodMapDatastream((Date)versDateTime).xmlContent);
    }

    private MethodParmDef[] getParms(MethodDef[] methods, String methodName) throws MethodNotFoundException, ServerException {
        for (MethodDef element : methods) {
            if (!element.methodName.equalsIgnoreCase(methodName)) continue;
            return element.methodParms;
        }
        throw new MethodNotFoundException("[getParms] The service deployment object, " + this.m_obj.getPid() + ", does not have a service method named '" + methodName);
    }
}

