/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.LowlevelStorageInconsistencyException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.lowlevel.PathRegistry;
import org.fcrepo.server.utilities.SQLUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPathRegistry
extends PathRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DBPathRegistry.class);
    private ConnectionPool connectionPool = null;
    private final boolean backslashIsEscape;

    public DBPathRegistry(Map<String, ?> configuration) {
        super(configuration);
        this.connectionPool = (ConnectionPool)configuration.get("connectionPool");
        this.backslashIsEscape = Boolean.valueOf((String)configuration.get("backslashIsEscape"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get(String pid) throws ObjectNotInLowlevelStorageException, LowlevelStorageInconsistencyException, LowlevelStorageException {
        String path = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            int paths = 0;
            connection = this.connectionPool.getReadOnlyConnection();
            String query = "SELECT path FROM " + this.getRegistryName() + " WHERE token=?";
            statement = connection.prepareStatement(query);
            statement.setString(1, pid);
            rs = statement.executeQuery();
            while (rs.next()) {
                path = rs.getString(1);
                ++paths;
            }
            if (paths == 0) {
                throw new ObjectNotInLowlevelStorageException("no path in db registry for [" + pid + "]");
            }
            if (paths > 1) {
                throw new LowlevelStorageInconsistencyException("[" + pid + "] in db registry -multiple- times");
            }
            if (path == null) throw new LowlevelStorageInconsistencyException("[" + pid + "] has -null- path in db registry");
            if (path.length() != 0) return path;
            throw new LowlevelStorageInconsistencyException("[" + pid + "] has -null- path in db registry");
        }
        catch (SQLException e1) {
            throw new LowlevelStorageException(true, "sql failure (get)", e1);
        }
        finally {
            try {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionPool.free(connection);
                    }
                    rs = null;
                    statement = null;
                }
                catch (Exception e2) {
                    throw new LowlevelStorageException(true, "sql failure closing statement, connection, pool (get)", e2);
                }
            }
            catch (Throwable throwable) {
                rs = null;
                statement = null;
                throw throwable;
            }
        }
    }

    private void ensureSingleUpdate(Statement statement) throws ObjectNotInLowlevelStorageException, LowlevelStorageInconsistencyException, LowlevelStorageException {
        try {
            int updateCount = statement.getUpdateCount();
            if (updateCount == 0) {
                throw new ObjectNotInLowlevelStorageException("Object not found in low-level storage: -no- rows updated in db registry");
            }
            if (updateCount > 1) {
                throw new LowlevelStorageInconsistencyException("-multiple- rows updated in db registry");
            }
        }
        catch (SQLException e1) {
            throw new LowlevelStorageException(true, "sql failurex (exec)", e1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void executeSql(String sql) throws ObjectNotInLowlevelStorageException, LowlevelStorageInconsistencyException, LowlevelStorageException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.connectionPool.getReadWriteConnection();
            statement = connection.createStatement();
            if (statement.execute(sql)) {
                throw new LowlevelStorageException(true, "sql returned query results for a nonquery");
            }
            this.ensureSingleUpdate(statement);
            return;
        }
        catch (SQLException e1) {
            throw new LowlevelStorageException(true, "sql failurex (exec)", e1);
        }
        finally {
            try {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionPool.free(connection);
                    }
                    statement = null;
                }
                catch (Exception e2) {
                    throw new LowlevelStorageException(true, "sql failure closing statement, connection, pool (exec)", e2);
                }
            }
            catch (Throwable throwable) {
                statement = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeUpdate(String sql, String pid) throws ObjectNotInLowlevelStorageException, LowlevelStorageInconsistencyException, LowlevelStorageException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.connectionPool.getReadWriteConnection();
            statement = connection.prepareStatement(sql);
            if (pid != null) {
                statement.setString(1, pid);
            }
            if (statement.execute()) {
                throw new LowlevelStorageException(true, "sql returned query results for a nonquery");
            }
            this.ensureSingleUpdate(statement);
            return;
        }
        catch (SQLException e1) {
            throw new LowlevelStorageException(true, "sql failurex (exec)", e1);
        }
        finally {
            try {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionPool.free(connection);
                    }
                    statement = null;
                }
                catch (Exception e2) {
                    throw new LowlevelStorageException(true, "sql failure closing statement, connection, pool (exec)", e2);
                }
            }
            catch (Throwable throwable) {
                statement = null;
                throw throwable;
            }
        }
    }

    @Override
    public void put(String pid, String path) throws ObjectNotInLowlevelStorageException, LowlevelStorageInconsistencyException, LowlevelStorageException {
        if (this.backslashIsEscape) {
            StringBuffer buffer = new StringBuffer();
            String backslash = "\\";
            String escapedBackslash = "\\\\";
            for (int i = 0; i < path.length(); ++i) {
                String s = path.substring(i, i + 1);
                buffer.append(s.equals(backslash) ? escapedBackslash : s);
            }
            path = buffer.toString();
        }
        Connection conn = null;
        try {
            conn = this.connectionPool.getReadWriteConnection();
            SQLUtility.replaceInto(conn, this.getRegistryName(), new String[]{"token", "path"}, new String[]{pid, path}, "token");
        }
        catch (SQLException e1) {
            throw new ObjectNotInLowlevelStorageException("put into db registry failed for [" + pid + "]", e1);
        }
        finally {
            if (conn != null) {
                this.connectionPool.free(conn);
            }
        }
    }

    @Override
    public void remove(String pid) throws ObjectNotInLowlevelStorageException, LowlevelStorageInconsistencyException, LowlevelStorageException {
        try {
            String query = "DELETE FROM " + this.getRegistryName() + " WHERE " + this.getRegistryName() + ".token=?";
            this.executeUpdate(query, pid);
        }
        catch (ObjectNotInLowlevelStorageException e1) {
            throw new ObjectNotInLowlevelStorageException("[" + pid + "] not in db registry to delete", e1);
        }
        catch (LowlevelStorageInconsistencyException e2) {
            throw new LowlevelStorageInconsistencyException("[" + pid + "] deleted from db registry -multiple- times", e2);
        }
    }

    @Override
    public void rebuild() throws LowlevelStorageException {
        int report = 2;
        try {
            this.executeUpdate("DELETE FROM " + this.getRegistryName(), null);
        }
        catch (ObjectNotInLowlevelStorageException e1) {
        }
        catch (LowlevelStorageInconsistencyException e2) {
            // empty catch block
        }
        try {
            logger.info("begin rebuilding registry from files");
            this.traverseFiles(this.storeBases, 2, false, report);
            logger.info("end rebuilding registry from files (ending normally)");
        }
        catch (Exception e) {
            if (report != 0) {
                logger.error("ending rebuild unsuccessfully", (Throwable)e);
            }
            throw new LowlevelStorageException(true, "ending rebuild unsuccessfully", e);
        }
    }

    @Override
    public void auditFiles() throws LowlevelStorageException {
        logger.info("begin audit: files-against-registry");
        this.traverseFiles(this.storeBases, 1, false, 2);
        logger.info("end audit: files-against-registry (ending normally)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Enumeration<String> keys() throws LowlevelStorageException, LowlevelStorageInconsistencyException {
        Object key;
        File tempFile = null;
        PrintWriter writer = null;
        ResultSet rs = null;
        Connection connection = null;
        Statement statement = null;
        try {
            tempFile = File.createTempFile("fedora-keys", ".tmp");
            writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
            connection = this.connectionPool.getReadOnlyConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery("SELECT token FROM " + this.getRegistryName());
            while (rs.next()) {
                key = rs.getString(1);
                if (null == key) throw new LowlevelStorageInconsistencyException("Null token found in " + this.getRegistryName());
                if (0 == ((String)key).length()) {
                    throw new LowlevelStorageInconsistencyException("Null token found in " + this.getRegistryName());
                }
                writer.println((String)key);
            }
            writer.close();
            key = new KeyEnumeration(tempFile);
        }
        catch (Exception e) {
            try {
                throw new LowlevelStorageException(true, "Unexpected error", e);
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection == null) throw throwable;
                    this.connectionPool.free(connection);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new LowlevelStorageException(true, "Unexpected error", e2);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                        writer = null;
                    }
                    rs = null;
                    statement = null;
                }
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection == null) return key;
            this.connectionPool.free(connection);
            return key;
        }
        catch (Exception e) {
            throw new LowlevelStorageException(true, "Unexpected error", e);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
            rs = null;
            statement = null;
        }
    }

    private class KeyEnumeration
    implements Enumeration<String> {
        private final File file;
        private final BufferedReader reader;
        private boolean closed;
        private String nextKey;

        public KeyEnumeration(File file) throws FileNotFoundException {
            this.file = file;
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            this.setNextKey();
        }

        private void setNextKey() {
            try {
                this.nextKey = this.reader.readLine();
                if (this.nextKey == null) {
                    this.close();
                } else if (this.nextKey.length() == 0) {
                    this.setNextKey();
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextKey != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String nextElement() {
            if (this.nextKey != null) {
                try {
                    String string = this.nextKey;
                    return string;
                }
                finally {
                    this.setNextKey();
                }
            }
            throw new NoSuchElementException();
        }

        protected void finalize() {
            if (!this.closed) {
                this.close();
            }
        }

        private void close() {
            try {
                this.reader.close();
                this.file.delete();
            }
            catch (IOException e) {
                throw new Error(e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

