/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.common.FaultException;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ObjectAlreadyInLowlevelStorageException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.storage.lowlevel.FileSystem;
import org.fcrepo.server.storage.lowlevel.IListable;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.lowlevel.ISizable;
import org.fcrepo.server.storage.lowlevel.PathAlgorithm;
import org.fcrepo.server.storage.lowlevel.PathRegistry;

public class DefaultLowlevelStorage
implements ILowlevelStorage,
IListable,
ISizable {
    public static final String REGISTRY_NAME = "registryName";
    public static final String OBJECT_REGISTRY_TABLE = "objectPaths";
    public static final String DATASTREAM_REGISTRY_TABLE = "datastreamPaths";
    public static final String OBJECT_STORE_BASE = "object_store_base";
    public static final String DATASTREAM_STORE_BASE = "datastream_store_base";
    public static final String FILESYSTEM = "file_system";
    public static final String PATH_ALGORITHM = "path_algorithm";
    public static final String PATH_REGISTRY = "path_registry";
    private final Store objectStore;
    private final Store datastreamStore;

    public DefaultLowlevelStorage(Map<String, Object> configuration) throws LowlevelStorageException {
        String objectStoreBase = (String)configuration.get(OBJECT_STORE_BASE);
        String datastreamStoreBase = (String)configuration.get(DATASTREAM_STORE_BASE);
        HashMap<String, Object> objConfig = new HashMap<String, Object>();
        objConfig.putAll(configuration);
        objConfig.put(REGISTRY_NAME, OBJECT_REGISTRY_TABLE);
        objConfig.put("storeBase", objectStoreBase);
        objConfig.put("storeBases", new String[]{objectStoreBase});
        this.objectStore = new Store(objConfig);
        HashMap<String, Object> dsConfig = new HashMap<String, Object>();
        dsConfig.putAll(configuration);
        dsConfig.put(REGISTRY_NAME, DATASTREAM_REGISTRY_TABLE);
        dsConfig.put("storeBase", datastreamStoreBase);
        dsConfig.put("storeBases", new String[]{datastreamStoreBase});
        this.datastreamStore = new Store(dsConfig);
    }

    @Override
    public void addObject(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        this.objectStore.add(pid, content);
    }

    @Override
    public void replaceObject(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        this.objectStore.replace(pid, content);
    }

    @Override
    public InputStream retrieveObject(String pid) throws LowlevelStorageException {
        return this.objectStore.retrieve(pid);
    }

    @Override
    public void removeObject(String pid) throws LowlevelStorageException {
        this.objectStore.remove(pid);
    }

    @Override
    public void rebuildObject() throws LowlevelStorageException {
        this.objectStore.rebuild();
    }

    @Override
    public void auditObject() throws LowlevelStorageException {
        this.objectStore.audit();
    }

    @Override
    public long addDatastream(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return this.datastreamStore.add(pid, content);
    }

    @Override
    public long replaceDatastream(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return this.datastreamStore.replace(pid, content);
    }

    @Override
    public InputStream retrieveDatastream(String pid) throws LowlevelStorageException {
        return this.datastreamStore.retrieve(pid);
    }

    @Override
    public void removeDatastream(String pid) throws LowlevelStorageException {
        this.datastreamStore.remove(pid);
    }

    @Override
    public void rebuildDatastream() throws LowlevelStorageException {
        this.datastreamStore.rebuild();
    }

    @Override
    public void auditDatastream() throws LowlevelStorageException {
        this.datastreamStore.audit();
    }

    @Override
    public Iterator<String> listObjects() {
        return this.objectStore.list();
    }

    @Override
    public Iterator<String> listDatastreams() {
        return this.datastreamStore.list();
    }

    @Override
    public long getDatastreamSize(String dsKey) throws LowlevelStorageException {
        return this.datastreamStore.getSize(dsKey);
    }

    class Store {
        private final PathAlgorithm pathAlgorithm;
        private final PathRegistry pathRegistry;
        private final FileSystem fileSystem;

        public Store(Map<String, Object> configuration) throws LowlevelStorageException {
            String registryName = (String)configuration.get(DefaultLowlevelStorage.REGISTRY_NAME);
            String filesystem = (String)configuration.get(DefaultLowlevelStorage.FILESYSTEM);
            String pathAlgorithm = (String)configuration.get(DefaultLowlevelStorage.PATH_ALGORITHM);
            String pathRegistry = (String)configuration.get(DefaultLowlevelStorage.PATH_REGISTRY);
            Object[] parameters = new Object[]{configuration};
            Class[] parameterTypes = new Class[]{Map.class};
            ClassLoader loader = this.getClass().getClassLoader();
            String failureReason = "";
            try {
                failureReason = DefaultLowlevelStorage.FILESYSTEM;
                Class<?> cclass = loader.loadClass(filesystem);
                Constructor<?> constructor = cclass.getConstructor(parameterTypes);
                this.fileSystem = (FileSystem)constructor.newInstance(parameters);
                failureReason = DefaultLowlevelStorage.PATH_ALGORITHM;
                cclass = loader.loadClass(pathAlgorithm);
                constructor = cclass.getConstructor(parameterTypes);
                this.pathAlgorithm = (PathAlgorithm)constructor.newInstance(parameters);
                failureReason = DefaultLowlevelStorage.PATH_REGISTRY;
                cclass = loader.loadClass(pathRegistry);
                constructor = cclass.getConstructor(parameterTypes);
                this.pathRegistry = (PathRegistry)constructor.newInstance(parameters);
            }
            catch (Exception e) {
                LowlevelStorageException wrapper = new LowlevelStorageException(true, "couldn't set up " + failureReason + " for " + registryName, e);
                throw wrapper;
            }
        }

        public Iterator<String> list() {
            try {
                final Enumeration<String> keys = this.pathRegistry.keys();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return keys.hasMoreElements();
                    }

                    @Override
                    public String next() {
                        return (String)keys.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            catch (LowlevelStorageException e) {
                throw new FaultException((Throwable)e);
            }
        }

        public void audit() throws LowlevelStorageException {
            this.pathRegistry.auditFiles();
            this.pathRegistry.auditRegistry();
        }

        public void rebuild() throws LowlevelStorageException {
            this.pathRegistry.rebuild();
        }

        public final long add(String pid, InputStream content) throws LowlevelStorageException {
            File file = null;
            try {
                String filePath = this.pathRegistry.get(pid);
                ObjectAlreadyInLowlevelStorageException already = new ObjectAlreadyInLowlevelStorageException("" + pid);
                throw already;
            }
            catch (ObjectNotInLowlevelStorageException not) {
                String filePath = this.pathAlgorithm.get(pid);
                if (filePath == null || filePath.equals("")) {
                    LowlevelStorageException nullPath = new LowlevelStorageException(true, "null path from algorithm for pid " + pid);
                    throw nullPath;
                }
                try {
                    file = new File(filePath);
                }
                catch (Exception eFile) {
                    LowlevelStorageException newFile = new LowlevelStorageException(true, "couldn't make File for " + filePath, eFile);
                    throw newFile;
                }
                this.fileSystem.write(file, content);
                this.pathRegistry.put(pid, filePath);
                return file.length();
            }
        }

        public final long replace(String pid, InputStream content) throws LowlevelStorageException {
            String filePath;
            File file = null;
            try {
                filePath = this.pathRegistry.get(pid);
            }
            catch (ObjectNotInLowlevelStorageException ffff) {
                LowlevelStorageException noPath = new LowlevelStorageException(false, "pid " + pid + " not in registry", ffff);
                throw noPath;
            }
            if (filePath == null || filePath.equals("")) {
                LowlevelStorageException nullPath = new LowlevelStorageException(true, "pid " + pid + " not in registry");
                throw nullPath;
            }
            try {
                file = new File(filePath);
            }
            catch (Exception eFile) {
                LowlevelStorageException newFile = new LowlevelStorageException(true, "couldn't make new File for " + filePath, eFile);
                throw newFile;
            }
            this.fileSystem.rewrite(file, content);
            return file.length();
        }

        public final InputStream retrieve(String pid) throws LowlevelStorageException {
            File file;
            String filePath = this.pathRegistry.get(pid);
            if (filePath == null || filePath.equals("")) {
                LowlevelStorageException nullPath = new LowlevelStorageException(true, "null path from registry for pid " + pid);
                throw nullPath;
            }
            try {
                file = new File(filePath);
            }
            catch (Exception eFile) {
                LowlevelStorageException newFile = new LowlevelStorageException(true, "couldn't make File for " + filePath, eFile);
                throw newFile;
            }
            return this.fileSystem.read(file);
        }

        public final long getSize(String pid) throws LowlevelStorageException {
            File file;
            String filePath = this.pathRegistry.get(pid);
            if (filePath == null || filePath.equals("")) {
                LowlevelStorageException nullPath = new LowlevelStorageException(true, "null path from registry for pid " + pid);
                throw nullPath;
            }
            try {
                file = new File(filePath);
            }
            catch (Exception eFile) {
                LowlevelStorageException newFile = new LowlevelStorageException(true, "couldn't make File for " + filePath, eFile);
                throw newFile;
            }
            return file.length();
        }

        public final void remove(String pid) throws LowlevelStorageException {
            File file = null;
            String filePath = this.pathRegistry.get(pid);
            if (filePath == null || filePath.equals("")) {
                LowlevelStorageException nullPath = new LowlevelStorageException(true, "null path from registry for pid " + pid);
                throw nullPath;
            }
            try {
                file = new File(filePath);
            }
            catch (Exception eFile) {
                LowlevelStorageException newFile = new LowlevelStorageException(true, "couldn't make File for " + filePath, eFile);
                throw newFile;
            }
            this.pathRegistry.remove(pid);
            this.fileSystem.delete(file);
        }
    }
}

