/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ConnectionPoolNotFoundException;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.fcrepo.server.storage.lowlevel.DefaultLowlevelStorage;
import org.fcrepo.server.storage.lowlevel.IListable;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.lowlevel.ISizable;

public class DefaultLowlevelStorageModule
extends Module
implements ILowlevelStorage,
IListable,
ISizable {
    private ILowlevelStorage m_llstore;

    public DefaultLowlevelStorageModule(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        try {
            this.m_llstore = new DefaultLowlevelStorage(this.getModuleParameters());
        }
        catch (LowlevelStorageException e) {
            throw new ModuleInitializationException(e.getMessage(), this.getRole());
        }
    }

    protected Map<String, Object> getModuleParameters() throws ModuleInitializationException {
        ConnectionPool cPool;
        String objectStoreBase = this.getModuleParameter("object_store_base", true);
        String datastreamStoreBase = this.getModuleParameter("datastream_store_base", true);
        String filesystem = this.getModuleParameter("file_system", false);
        String pathAlgorithm = this.getModuleParameter("path_algorithm", false);
        String pathRegistry = this.getModuleParameter("path_registry", false);
        String param = this.getModuleParameter("backslash_is_escape", false).toLowerCase();
        if (!param.equals("true") && !param.equals("false")) {
            throw new ModuleInitializationException("backslash_is_escape parameter must be either true or false", this.getRole());
        }
        String backslashIsEscape = param;
        ConnectionPoolManager cpm = (ConnectionPoolManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ConnectionPoolManager"));
        if (cpm == null) {
            throw new ModuleInitializationException("ConnectionPoolManager module was required, but apparently has not been loaded.", this.getRole());
        }
        try {
            cPool = cpm.getPool();
        }
        catch (ConnectionPoolNotFoundException e1) {
            throw new ModuleInitializationException("Could not find requested connectionPool.", this.getRole());
        }
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("file_system", filesystem);
        configuration.put("path_algorithm", pathAlgorithm);
        configuration.put("path_registry", pathRegistry);
        configuration.put("object_store_base", objectStoreBase);
        configuration.put("datastream_store_base", datastreamStoreBase);
        configuration.put("connectionPool", cPool);
        configuration.put("backslashIsEscape", backslashIsEscape);
        return configuration;
    }

    protected String getModuleParameter(String parameterName, boolean parameterAsAbsolutePath) throws ModuleInitializationException {
        String parameterValue = this.getParameter(parameterName, parameterAsAbsolutePath);
        if (parameterValue == null) {
            throw new ModuleInitializationException(parameterName + " parameter must be specified", this.getRole());
        }
        return parameterValue;
    }

    @Override
    public void addObject(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        this.m_llstore.addObject(pid, content, hints);
    }

    @Override
    public void replaceObject(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        this.m_llstore.replaceObject(pid, content, hints);
    }

    @Override
    public InputStream retrieveObject(String pid) throws LowlevelStorageException {
        return this.m_llstore.retrieveObject(pid);
    }

    @Override
    public void removeObject(String pid) throws LowlevelStorageException {
        this.m_llstore.removeObject(pid);
    }

    @Override
    public void rebuildObject() throws LowlevelStorageException {
        this.m_llstore.rebuildObject();
    }

    @Override
    public void auditObject() throws LowlevelStorageException {
        this.m_llstore.auditObject();
    }

    @Override
    public long addDatastream(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return this.m_llstore.addDatastream(pid, content, hints);
    }

    @Override
    public long replaceDatastream(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return this.m_llstore.replaceDatastream(pid, content, hints);
    }

    @Override
    public InputStream retrieveDatastream(String pid) throws LowlevelStorageException {
        return this.m_llstore.retrieveDatastream(pid);
    }

    @Override
    public void removeDatastream(String pid) throws LowlevelStorageException {
        this.m_llstore.removeDatastream(pid);
    }

    @Override
    public void rebuildDatastream() throws LowlevelStorageException {
        this.m_llstore.rebuildDatastream();
    }

    @Override
    public void auditDatastream() throws LowlevelStorageException {
        this.m_llstore.auditDatastream();
    }

    @Override
    public Iterator<String> listObjects() {
        return ((IListable)((Object)this.m_llstore)).listObjects();
    }

    @Override
    public Iterator<String> listDatastreams() {
        return ((IListable)((Object)this.m_llstore)).listDatastreams();
    }

    @Override
    public long getDatastreamSize(String dsKey) throws LowlevelStorageException {
        return ((ISizable)((Object)this.m_llstore)).getDatastreamSize(dsKey);
    }
}

