/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.io.File;
import java.util.GregorianCalendar;
import java.util.Map;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.storage.lowlevel.PathAlgorithm;

class TimestampPathAlgorithm
extends PathAlgorithm {
    private final String storeBase;
    private static final String[] PADDING = new String[]{"", "0", "00", "000"};
    private static final String SEP = File.separator;

    public TimestampPathAlgorithm(Map<String, ?> configuration) {
        super(configuration);
        this.storeBase = (String)configuration.get("storeBase");
    }

    @Override
    public final String get(String pid) throws LowlevelStorageException {
        return this.format(TimestampPathAlgorithm.encode(pid));
    }

    public String format(String pid) throws LowlevelStorageException {
        GregorianCalendar calendar = new GregorianCalendar();
        String year = Integer.toString(calendar.get(1));
        String month = this.leftPadded(1 + calendar.get(2), 2);
        String dayOfMonth = this.leftPadded(calendar.get(5), 2);
        String hourOfDay = this.leftPadded(calendar.get(11), 2);
        String minute = this.leftPadded(calendar.get(12), 2);
        return this.storeBase + SEP + year + SEP + month + dayOfMonth + SEP + hourOfDay + SEP + minute + SEP + pid;
    }

    private final String leftPadded(int i, int n) throws LowlevelStorageException {
        if (n > 3 || n < 0 || i < 0 || i > 999) {
            throw new LowlevelStorageException(true, this.getClass().getName() + ": faulty date padding");
        }
        int m = i > 99 ? 3 : (i > 9 ? 2 : 1);
        int p = n - m;
        return PADDING[p] + Integer.toString(i);
    }
}

