/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel.akubra;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.storage.lowlevel.IListable;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.lowlevel.ISizable;
import org.springframework.beans.factory.annotation.Required;

public class AkubraLowlevelStorageModule
extends Module
implements ILowlevelStorage,
IListable,
ISizable {
    private ILowlevelStorage m_impl;

    @Required
    public void setImpl(ILowlevelStorage store) {
        this.m_impl = store;
    }

    public AkubraLowlevelStorageModule(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    public void setLLStoreImpl(ILowlevelStorage impl) {
        this.m_impl = impl;
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        if (this.m_impl == null) {
            throw new ModuleInitializationException("Error initializing: no ILowlevelStorage impl ", this.getRole());
        }
    }

    @Override
    public void addObject(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        this.m_impl.addObject(pid, content, hints);
    }

    @Override
    public void replaceObject(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        this.m_impl.replaceObject(pid, content, hints);
    }

    @Override
    public InputStream retrieveObject(String pid) throws LowlevelStorageException {
        return this.m_impl.retrieveObject(pid);
    }

    @Override
    public void removeObject(String pid) throws LowlevelStorageException {
        this.m_impl.removeObject(pid);
    }

    @Override
    public void rebuildObject() throws LowlevelStorageException {
        this.m_impl.rebuildObject();
    }

    @Override
    public void auditObject() throws LowlevelStorageException {
        this.m_impl.auditObject();
    }

    @Override
    public long addDatastream(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return this.m_impl.addDatastream(pid, content, hints);
    }

    @Override
    public long replaceDatastream(String pid, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return this.m_impl.replaceDatastream(pid, content, hints);
    }

    @Override
    public InputStream retrieveDatastream(String pid) throws LowlevelStorageException {
        return this.m_impl.retrieveDatastream(pid);
    }

    @Override
    public void removeDatastream(String pid) throws LowlevelStorageException {
        this.m_impl.removeDatastream(pid);
    }

    @Override
    public void rebuildDatastream() throws LowlevelStorageException {
        this.m_impl.rebuildDatastream();
    }

    @Override
    public void auditDatastream() throws LowlevelStorageException {
        this.m_impl.auditDatastream();
    }

    @Override
    public Iterator<String> listObjects() {
        return ((IListable)((Object)this.m_impl)).listObjects();
    }

    @Override
    public Iterator<String> listDatastreams() {
        return ((IListable)((Object)this.m_impl)).listDatastreams();
    }

    @Override
    public long getDatastreamSize(String dsKey) throws LowlevelStorageException {
        return ((ISizable)((Object)this.m_impl)).getDatastreamSize(dsKey);
    }
}

