/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.service;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.storage.service.Mmap;
import org.fcrepo.server.storage.service.MmapMethodDef;
import org.fcrepo.server.storage.service.MmapMethodParmDef;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class MmapParser
extends DefaultHandler
implements Constants {
    private HashMap nsPrefixMap;
    private boolean inMethod = false;
    private boolean inUserInputParm = false;
    private Mmap methodMap;
    private MmapMethodDef methodMapMethod;
    private MmapMethodParmDef methodMapParm;
    private Hashtable wsdlOperationToMethodDefTbl;
    private Hashtable wsdlMsgPartToParmDefTbl;
    private Vector tmp_enum;
    private Vector tmp_parms;
    private Vector tmp_methods;

    public MmapParser(String parentPID) {
    }

    public MmapParser(String parentPID, InputStream in) throws RepositoryConfigurationException, ObjectIntegrityException {
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxfactory = SAXParserFactory.newInstance();
            saxfactory.setValidating(false);
            SAXParser parser = saxfactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Internal SAX error while preparing for Method Map datastream parsing: " + e.getMessage());
        }
        try {
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ObjectIntegrityException("Error parsing Method Map datastream" + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    protected Mmap getMethodMap() {
        return this.methodMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.nsPrefixMap = new HashMap();
        this.wsdlOperationToMethodDefTbl = new Hashtable();
    }

    @Override
    public void endDocument() throws SAXException {
        this.nsPrefixMap = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsPrefixMap.put(uri, prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        StringBuffer sb = new StringBuffer();
        sb.append('&');
        sb.append(name);
        sb.append(';');
        char[] text = new char[sb.length()];
        sb.getChars(0, sb.length(), text, 0);
        this.characters(text, 0, text.length);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("MethodMap")) {
            this.methodMap = new Mmap();
            this.methodMap.mmapName = attrs.getValue("name");
            this.tmp_methods = new Vector();
        } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("Method")) {
            this.inMethod = true;
            this.methodMapMethod = new MmapMethodDef();
            this.methodMapMethod.methodName = attrs.getValue("operationName");
            this.methodMapMethod.methodLabel = "fix me";
            this.methodMapMethod.wsdlOperationName = attrs.getValue("operationName");
            this.methodMapMethod.wsdlMessageName = attrs.getValue("wsdlMsgName");
            this.methodMapMethod.wsdlOutputMessageName = attrs.getValue("wsdlMsgOutput");
            this.tmp_parms = new Vector();
            this.wsdlMsgPartToParmDefTbl = new Hashtable();
        } else if (this.inMethod) {
            if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("DatastreamInputParm")) {
                this.methodMapParm = new MmapMethodParmDef();
                this.methodMapParm.wsdlMessagePartName = attrs.getValue("parmName");
                this.methodMapParm.parmName = attrs.getValue("parmName");
                this.methodMapParm.parmLabel = "fix me";
                this.methodMapParm.parmPassBy = attrs.getValue("passBy");
                this.methodMapParm.parmType = "fedora:datastreamInputType";
                this.methodMapParm.parmRequired = attrs.getValue("required") == null ? true : new Boolean(attrs.getValue("required"));
                this.methodMapParm.parmDefaultValue = null;
                this.methodMapParm.parmDomainValues = new String[0];
            } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("DefaultInputParm")) {
                this.methodMapParm = new MmapMethodParmDef();
                this.methodMapParm.wsdlMessagePartName = attrs.getValue("parmName");
                this.methodMapParm.parmName = attrs.getValue("parmName");
                this.methodMapParm.parmLabel = "fix me";
                this.methodMapParm.parmPassBy = "VALUE";
                this.methodMapParm.parmType = "fedora:defaultInputType";
                this.methodMapParm.parmRequired = attrs.getValue("required") == null ? true : new Boolean(attrs.getValue("required"));
                this.methodMapParm.parmDefaultValue = attrs.getValue("defaultValue");
                this.methodMapParm.parmDomainValues = new String[0];
            } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("UserInputParm")) {
                this.inUserInputParm = true;
                this.methodMapParm = new MmapMethodParmDef();
                this.methodMapParm.wsdlMessagePartName = attrs.getValue("parmName");
                this.methodMapParm.parmName = attrs.getValue("parmName");
                this.methodMapParm.parmLabel = "fix me";
                this.methodMapParm.parmPassBy = "VALUE";
                this.methodMapParm.parmType = "fedora:userInputType";
                this.methodMapParm.parmRequired = attrs.getValue("required") == null ? true : new Boolean(attrs.getValue("required"));
                this.methodMapParm.parmDefaultValue = attrs.getValue("defaultValue");
            } else if (this.inUserInputParm) {
                if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("ValidParmValues")) {
                    this.tmp_enum = new Vector();
                } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("ValidParm")) {
                    this.tmp_enum.add(attrs.getValue("value"));
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("MethodMap")) {
            this.methodMap.mmapMethods = this.tmp_methods.toArray(new MmapMethodDef[0]);
            this.methodMap.wsdlOperationToMethodDef = this.wsdlOperationToMethodDefTbl;
            this.tmp_methods = null;
        } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("Method")) {
            this.methodMapMethod.methodParms = this.tmp_parms.toArray(new MethodParmDef[0]);
            this.methodMapMethod.wsdlMsgParts = this.tmp_parms.toArray(new MmapMethodParmDef[0]);
            this.methodMapMethod.wsdlMsgPartToParmDefTbl = this.wsdlMsgPartToParmDefTbl;
            this.tmp_methods.add(this.methodMapMethod);
            this.wsdlOperationToMethodDefTbl.put(this.methodMapMethod.methodName, this.methodMapMethod);
            this.wsdlMsgPartToParmDefTbl = null;
            this.methodMapMethod = null;
            this.tmp_parms = null;
            this.inMethod = false;
        } else if (this.inMethod) {
            if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("DatastreamInputParm")) {
                this.tmp_parms.add(this.methodMapParm);
                this.wsdlMsgPartToParmDefTbl.put(this.methodMapParm.wsdlMessagePartName, this.methodMapParm);
                this.methodMapParm = null;
            } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("DefaultInputParm")) {
                this.tmp_parms.add(this.methodMapParm);
                this.wsdlMsgPartToParmDefTbl.put(this.methodMapParm.wsdlMessagePartName, this.methodMapParm);
                this.methodMapParm = null;
            } else if (namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("UserInputParm")) {
                this.tmp_parms.add(this.methodMapParm);
                this.wsdlMsgPartToParmDefTbl.put(this.methodMapParm.wsdlMessagePartName, this.methodMapParm);
                this.methodMapParm = null;
                this.inUserInputParm = false;
            } else if (this.inUserInputParm && namespaceURI.equalsIgnoreCase(MmapParser.METHOD_MAP.uri) && localName.equalsIgnoreCase("ValidParmValues")) {
                this.methodMapParm.parmDomainValues = this.tmp_enum.toArray(new String[0]);
                this.tmp_enum = null;
            }
        }
    }
}

