/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.MimeType;
import javax.xml.stream.XMLStreamException;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.thread.ThreadHelper;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.xpath.XPath;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.common.xml.format.XMLFormat;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.validation.ValidationUtility;
import org.fcrepo.utilities.DateUtility;
import org.fcrepo.utilities.FileUtils;
import org.fcrepo.utilities.NormalizedURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomDODeserializer
implements DODeserializer,
Constants {
    public static final XMLFormat DEFAULT_FORMAT = ATOM1_1;
    private static final Logger logger = LoggerFactory.getLogger(AtomDODeserializer.class);
    private DigitalObject m_obj;
    private String m_encoding;
    private int m_transContext;
    private final XMLFormat m_format;
    private final Abdera abdera = Abdera.getInstance();
    private Feed m_feed;
    private XPath m_xpath;
    private ZipInputStream m_zin;
    private File m_tempDir;

    public AtomDODeserializer() {
        this(DEFAULT_FORMAT);
    }

    public AtomDODeserializer(XMLFormat format) {
        if (!format.equals((Object)ATOM1_1) && !format.equals((Object)ATOM_ZIP1_1)) {
            throw new IllegalArgumentException("Not an Atom format: " + format.uri);
        }
        this.m_format = format;
    }

    @Override
    public void deserialize(InputStream in, DigitalObject obj, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
            try {
                ZipEntry entry;
                this.m_tempDir = FileUtils.createTempDir((String)"atomzip", null);
                this.m_zin = new ZipInputStream(new BufferedInputStream(in));
                while ((entry = this.m_zin.getNextEntry()) != null) {
                    FileUtils.copy((InputStream)this.m_zin, (OutputStream)new FileOutputStream(new File(this.m_tempDir, entry.getName())));
                }
                in = new FileInputStream(new File(this.m_tempDir, "atommanifest.xml"));
            }
            catch (FileNotFoundException e) {
                throw new StreamIOException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new StreamIOException(e.getMessage(), e);
            }
        }
        Parser parser = this.abdera.getParser();
        Document feedDoc = parser.parse(in);
        this.m_feed = (Feed)feedDoc.getRoot();
        this.m_xpath = this.abdera.getXPath();
        this.m_obj = obj;
        this.m_encoding = encoding;
        this.m_transContext = transContext;
        this.addObjectProperties();
        this.addDatastreams();
        DOTranslationUtility.normalizeDatastreams(this.m_obj, this.m_transContext, this.m_encoding);
        FileUtils.delete((File)this.m_tempDir);
    }

    @Override
    public DODeserializer getInstance() {
        return new AtomDODeserializer(this.m_format);
    }

    private void addObjectProperties() throws ObjectIntegrityException {
        PID pid;
        try {
            pid = new PID(this.m_feed.getId().toString());
        }
        catch (MalformedPIDException e) {
            throw new ObjectIntegrityException(e.getMessage(), e);
        }
        String label = this.m_feed.getTitle();
        String state = this.m_xpath.valueOf("/a:feed/a:category[@scheme='" + AtomDODeserializer.MODEL.STATE.uri + "']/@term", (Base)this.m_feed);
        String createDate = this.m_xpath.valueOf("/a:feed/a:category[@scheme='" + AtomDODeserializer.MODEL.CREATED_DATE.uri + "']/@term", (Base)this.m_feed);
        this.m_obj.setPid(pid.toString());
        try {
            this.m_obj.setState(DOTranslationUtility.readStateAttribute(state));
        }
        catch (ParseException e) {
            throw new ObjectIntegrityException("Could not read object state", e);
        }
        this.m_obj.setLabel(label);
        this.m_obj.setOwnerId(this.getOwnerId());
        this.m_obj.setCreateDate(DateUtility.convertStringToDate((String)createDate));
        this.m_obj.setLastModDate(this.m_feed.getUpdated());
        this.setExtProps();
    }

    private void addDatastreams() throws UnsupportedEncodingException, StreamIOException, ObjectIntegrityException {
        this.m_feed.sortEntries((Comparator)new UpdatedIdComparator(true));
        List entries = this.m_feed.getEntries();
        for (Entry entry : entries) {
            if (ThreadHelper.getInReplyTo((Entry)entry) == null) continue;
            this.addDatastreamVersion(entry);
        }
    }

    private void addDatastreamVersion(Entry entry) throws UnsupportedEncodingException, StreamIOException, ObjectIntegrityException {
        IRI ref = ThreadHelper.getInReplyTo((Entry)entry).getRef();
        Entry parent = this.m_feed.getEntry(ref.toString());
        String controlGroup = this.getDSControlGroup(parent);
        Datastream ds = controlGroup.equals("X") ? this.addInlineDatastreamVersion(entry) : (controlGroup.equals("M") ? this.addManagedDatastreamVersion(entry) : this.addExternalReferencedDatastreamVersion(entry));
        this.m_obj.addDatastreamVersion(ds, true);
    }

    private Datastream addInlineDatastreamVersion(Entry entry) throws ObjectIntegrityException, StreamIOException {
        MimeType mimeType;
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        this.setDSCommonProperties(ds, entry);
        String dsId = ds.DatastreamID;
        String dsvId = ds.DSVersionID;
        ds.DSLocation = this.m_obj.getPid() + "+" + dsId + "+" + dsvId;
        if (ds.DSVersionID.equals("AUDIT.0")) {
            this.addAuditDatastream(entry);
        } else {
            try {
                if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    FileUtils.copy((InputStream)new FileInputStream(this.getContentSrcAsFile(entry.getContentSrc())), (OutputStream)bout);
                    ds.xmlContent = bout.toByteArray();
                } else {
                    ds.xmlContent = entry.getContent().getBytes(this.m_encoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new StreamIOException(e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                throw new ObjectIntegrityException(e.getMessage(), e);
            }
        }
        if (ds.xmlContent != null) {
            ds.DSSize = ds.xmlContent.length;
        }
        ds.DSMIME = (mimeType = entry.getContentMimeType()) == null ? "text/xml" : mimeType.toString();
        return ds;
    }

    private Datastream addExternalReferencedDatastreamVersion(Entry entry) throws ObjectIntegrityException {
        DatastreamReferencedContent ds = new DatastreamReferencedContent();
        this.setDSCommonProperties(ds, entry);
        ds.DSLocation = entry.getContentSrc().toString();
        ds.DSLocation = DOTranslationUtility.normalizeDSLocationURLs((String)this.m_obj.getPid(), (Datastream)ds, (int)this.m_transContext).DSLocation;
        ds.DSLocationType = "URL";
        ds.DSMIME = entry.getContentMimeType().toString();
        return ds;
    }

    private Datastream addManagedDatastreamVersion(Entry entry) throws StreamIOException, ObjectIntegrityException {
        DatastreamManagedContent ds = new DatastreamManagedContent();
        this.setDSCommonProperties(ds, entry);
        ds.DSLocationType = "INTERNAL_ID";
        ds.DSMIME = this.getDSMimeType(entry);
        IRI contentLocation = entry.getContentSrc();
        if (contentLocation != null) {
            if (this.m_obj.isNew() && !this.m_format.equals((Object)ATOM_ZIP1_1)) {
                ValidationUtility.validateURL(contentLocation.toString(), ds.DSControlGrp);
            }
            if (this.m_format.equals((Object)ATOM_ZIP1_1) && !contentLocation.isAbsolute() && !contentLocation.isPathAbsolute()) {
                File f = this.getContentSrcAsFile(contentLocation);
                contentLocation = new IRI("temp://" + f.getAbsolutePath());
            }
            ds.DSLocation = contentLocation.toString();
            ds.DSLocation = DOTranslationUtility.normalizeDSLocationURLs((String)this.m_obj.getPid(), (Datastream)ds, (int)this.m_transContext).DSLocation;
            return ds;
        }
        try {
            File temp = File.createTempFile("binary-datastream", null);
            FileOutputStream out = new FileOutputStream(temp);
            if (MimeTypeHelper.isText((String)ds.DSMIME) || MimeTypeHelper.isXml((String)ds.DSMIME)) {
                IOUtils.copy((Reader)new StringReader(entry.getContent()), (OutputStream)out, (String)this.m_encoding);
            } else {
                IOUtils.copy((InputStream)entry.getContentStream(), (OutputStream)out);
            }
            ds.DSLocation = "temp://" + temp.getAbsolutePath();
        }
        catch (IOException e) {
            throw new StreamIOException(e.getMessage(), e);
        }
        return ds;
    }

    private void addAuditDatastream(Entry entry) throws ObjectIntegrityException, StreamIOException {
        try {
            Reader auditTrail;
            if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
                File f = this.getContentSrcAsFile(entry.getContentSrc());
                auditTrail = new InputStreamReader((InputStream)new FileInputStream(f), this.m_encoding);
            } else {
                auditTrail = new StringReader(entry.getContent());
            }
            this.m_obj.getAuditRecords().addAll(DOTranslationUtility.getAuditRecords(auditTrail));
            ((Reader)auditTrail).close();
        }
        catch (XMLStreamException e) {
            throw new ObjectIntegrityException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new StreamIOException(e.getMessage(), e);
        }
    }

    private String getOwnerId() {
        Person owner = this.m_feed.getAuthor();
        if (owner == null) {
            return "";
        }
        return owner.getName();
    }

    private String getDatastreamId(Entry entry) {
        String entryId = entry.getId().toString();
        Pattern pattern = Pattern.compile("^" + Constants.FEDORA.uri + ".+?/([^/]+)/?.*");
        Matcher matcher = pattern.matcher(entryId);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return this.m_obj.newDatastreamID();
    }

    private String getDatastreamVersionId(Entry entry) {
        String dsId = this.getDatastreamId(entry);
        String dsvId = entry.getTitle();
        if (dsvId.matches("^" + dsId + ".*\\.[\\w]")) {
            return dsvId;
        }
        if (!this.m_obj.datastreams(dsId).iterator().hasNext()) {
            return dsId + ".0";
        }
        return this.m_obj.newDatastreamID(dsId);
    }

    private String getDSControlGroup(Entry entry) throws ObjectIntegrityException {
        List controlGroups = entry.getCategories(AtomDODeserializer.MODEL.CONTROL_GROUP.uri);
        if (controlGroups.isEmpty() || controlGroups.size() > 1) {
            if (entry.getContentType() != null) {
                if (entry.getContentType().equals((Object)Content.Type.XML)) {
                    return "X";
                }
                return "M";
            }
            if (entry.getContentSrc() != null) {
                return "M";
            }
            throw new ObjectIntegrityException("No control group provided by " + this.m_obj.getPid());
        }
        return ((Category)controlGroups.get(0)).getTerm();
    }

    private String getDSState(Entry entry) {
        List state = entry.getCategories(AtomDODeserializer.MODEL.STATE.uri);
        if (state.isEmpty() || state.size() > 1) {
            return "A";
        }
        return ((Category)state.get(0)).getTerm();
    }

    private boolean getDSVersionable(Entry entry) {
        if (this.getDatastreamId(entry).equals("AUDIT")) {
            return false;
        }
        List versionable = entry.getCategories(AtomDODeserializer.MODEL.VERSIONABLE.uri);
        if (versionable.isEmpty() || versionable.size() > 1) {
            return true;
        }
        return Boolean.valueOf(((Category)versionable.get(0)).getTerm());
    }

    private String[] getDSAltIds(Entry entry) {
        List altIds = entry.getCategories(AtomDODeserializer.MODEL.ALT_IDS.uri);
        if (altIds.isEmpty()) {
            return new String[0];
        }
        return ((Category)altIds.get(0)).getTerm().split(" ");
    }

    private String getDSFormatURI(Entry entry) {
        List formatURI = entry.getCategories(AtomDODeserializer.MODEL.FORMAT_URI.uri);
        if (formatURI.isEmpty() || formatURI.size() > 1) {
            return null;
        }
        return ((Category)formatURI.get(0)).getTerm();
    }

    private String getDSLabel(Entry entry) {
        List label = entry.getCategories(AtomDODeserializer.MODEL.LABEL.uri);
        if (label.isEmpty()) {
            return "";
        }
        return ((Category)label.get(0)).getTerm();
    }

    private String getDSMimeType(Entry entry) {
        String dsMimeType = "application/unknown";
        MimeType mimeType = entry.getContentMimeType();
        if (mimeType == null) {
            Content.Type type = entry.getContentType();
            if (type != null) {
                if (type == Content.Type.HTML) {
                    dsMimeType = "text/html";
                } else if (type == Content.Type.TEXT) {
                    dsMimeType = "text/plain";
                } else if (type == Content.Type.XHTML) {
                    dsMimeType = "application/xhtml+xml";
                } else if (type == Content.Type.XML) {
                    dsMimeType = "text/xml";
                }
            }
        } else {
            dsMimeType = mimeType.toString();
        }
        return dsMimeType;
    }

    private String getDSChecksumType(Entry entry) {
        List digestType = entry.getCategories(AtomDODeserializer.MODEL.DIGEST_TYPE.uri);
        if (digestType.isEmpty()) {
            return "DISABLED";
        }
        return ((Category)digestType.get(0)).getTerm();
    }

    private String getDSChecksum(Entry entry) {
        List digest = entry.getCategories(AtomDODeserializer.MODEL.DIGEST.uri);
        if (digest.isEmpty()) {
            return "none";
        }
        return ((Category)digest.get(0)).getTerm();
    }

    private void setDSCommonProperties(Datastream dsVersion, Entry entry) throws ObjectIntegrityException {
        IRI ref = ThreadHelper.getInReplyTo((Entry)entry).getRef();
        Entry parent = this.m_feed.getEntry(ref.toString());
        dsVersion.DatastreamID = this.getDatastreamId(parent);
        dsVersion.DSControlGrp = this.getDSControlGroup(parent);
        dsVersion.DSState = this.getDSState(parent);
        dsVersion.DSVersionable = this.getDSVersionable(parent);
        this.setDatastreamVersionProperties(dsVersion, entry);
    }

    private void setDatastreamVersionProperties(Datastream ds, Entry entry) throws ValidationException {
        ds.DatastreamAltIDs = this.getDSAltIds(entry);
        ds.DSCreateDT = entry.getUpdated();
        ds.DSFormatURI = this.getDSFormatURI(entry);
        ds.DSLabel = this.getDSLabel(entry);
        ds.DSVersionID = this.getDatastreamVersionId(entry);
        ds.DSChecksumType = this.getDSChecksumType(entry);
        String checksum = this.getDSChecksum(entry);
        if (this.m_obj.isNew()) {
            if (logger.isDebugEnabled()) {
                logger.debug("New Object: checking supplied checksum");
            }
            if (checksum != null && !checksum.equals("") && !checksum.equals("none")) {
                String tmpChecksum = ds.getChecksum();
                if (logger.isDebugEnabled()) {
                    logger.debug("checksum = " + tmpChecksum);
                }
                if (!checksum.equals(tmpChecksum)) {
                    throw new ValidationException("Checksum Mismatch: " + tmpChecksum);
                }
            }
            ds.DSChecksumType = ds.getChecksumType();
        } else {
            ds.DSChecksum = checksum;
        }
    }

    private void setExtProps() {
        List epCategories = this.m_feed.getCategories(AtomDODeserializer.MODEL.EXT_PROPERTY.uri);
        for (Category epCategory : epCategories) {
            this.m_obj.setExtProperty(epCategory.getTerm(), epCategory.getLabel());
        }
    }

    protected File getContentSrcAsFile(IRI contentSrc) throws ObjectIntegrityException {
        if (contentSrc.isAbsolute() || contentSrc.isPathAbsolute()) {
            throw new ObjectIntegrityException("contentSrc must not be absolute");
        }
        try {
            NormalizedURI nUri = new NormalizedURI(this.m_tempDir.toURI().toString() + contentSrc.toString());
            nUri.normalize();
            File f = new File(nUri.toURI());
            if (f.getParentFile().equals(this.m_tempDir)) {
                return f;
            }
            throw new ObjectIntegrityException(contentSrc.toString() + " is not a valid path.");
        }
        catch (URISyntaxException e) {
            throw new ObjectIntegrityException(e.getMessage(), e);
        }
    }

    private static class UpdatedIdComparator
    implements Comparator<Entry> {
        private boolean ascending = true;

        UpdatedIdComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            Date d1 = o1.getUpdated();
            Date d2 = o2.getUpdated();
            String id1 = o1.getId().toString();
            String id2 = o2.getId().toString();
            int r = d1.compareTo(d2);
            if (d1.equals(d2)) {
                r = id1.compareTo(id2);
            }
            return this.ascending ? r : -r;
        }
    }
}

