/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.thread.ThreadHelper;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.common.xml.format.XMLFormat;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.fcrepo.utilities.MimeTypeUtils;
import org.jrdf.graph.ObjectNode;

public class AtomDOSerializer
implements DOSerializer,
Constants {
    public static final XMLFormat DEFAULT_FORMAT = ATOM1_1;
    private static final Abdera abdera = Abdera.getInstance();
    private DigitalObject m_obj;
    private String m_encoding;
    private int m_transContext;
    private final XMLFormat m_format;
    private PID m_pid;
    protected Feed m_feed;
    private ZipOutputStream m_zout;

    public AtomDOSerializer() {
        this(DEFAULT_FORMAT);
    }

    public AtomDOSerializer(XMLFormat format) {
        if (!format.equals((Object)ATOM1_1) && !format.equals((Object)ATOM_ZIP1_1)) {
            throw new IllegalArgumentException("Not an ATOM format: " + format.uri);
        }
        this.m_format = format;
    }

    @Override
    public DOSerializer getInstance() {
        return new AtomDOSerializer(this.m_format);
    }

    @Override
    public void serialize(DigitalObject obj, OutputStream out, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        this.m_obj = obj;
        this.m_encoding = encoding == null || encoding == "" ? "UTF-8" : encoding;
        this.m_transContext = transContext;
        this.m_pid = PID.getInstance((String)this.m_obj.getPid());
        this.m_feed = abdera.newFeed();
        if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
            this.m_zout = new ZipOutputStream(out);
        }
        this.addObjectProperties();
        this.m_feed.setIcon("http://www.fedora-commons.org/images/logo_vertical_transparent_200_251.png");
        this.addDatastreams();
        if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
            try {
                this.m_zout.putNextEntry(new ZipEntry("atommanifest.xml"));
                this.m_feed.writeTo("prettyxml", (OutputStream)this.m_zout);
                this.m_zout.closeEntry();
                this.m_zout.close();
            }
            catch (IOException e) {
                throw new StreamIOException(e.getMessage(), e);
            }
        }
        try {
            this.m_feed.writeTo("prettyxml", out);
        }
        catch (IOException e) {
            throw new StreamIOException(e.getMessage(), e);
        }
    }

    private void addObjectProperties() throws ObjectIntegrityException {
        String state = DOTranslationUtility.getStateAttribute(this.m_obj);
        String ownerId = this.m_obj.getOwnerId();
        String label = this.m_obj.getLabel();
        Date cdate = this.m_obj.getCreateDate();
        Date mdate = this.m_obj.getLastModDate();
        this.m_feed.setId(this.m_pid.toURI());
        this.m_feed.setTitle(label == null ? "" : label);
        this.m_feed.setUpdated(mdate);
        this.m_feed.addAuthor(ownerId == null ? "" : StreamUtility.enc(ownerId));
        this.m_feed.addCategory(AtomDOSerializer.MODEL.STATE.uri, state, null);
        if (cdate != null) {
            this.m_feed.addCategory(AtomDOSerializer.MODEL.CREATED_DATE.uri, DateUtility.convertDateToString((Date)cdate), null);
        }
        for (String extProp : this.m_obj.getExtProperties().keySet()) {
            this.m_feed.addCategory(AtomDOSerializer.MODEL.EXT_PROPERTY.uri, extProp, this.m_obj.getExtProperty(extProp));
        }
    }

    private void addDatastreams() throws ObjectIntegrityException, UnsupportedEncodingException, StreamIOException {
        Iterator<String> iter = this.m_obj.datastreamIdIterator();
        while (iter.hasNext()) {
            String dsid = iter.next();
            if (dsid.equals("AUDIT") || dsid.equals("FEDORA-AUDITTRAIL")) continue;
            Entry dsEntry = this.m_feed.addEntry();
            Datastream latestCreated = null;
            long latestCreateTime = -1L;
            for (Datastream v : this.m_obj.datastreams(dsid)) {
                Datastream dsv = DOTranslationUtility.setDatastreamDefaults(v);
                if (dsv.DSCreateDT.getTime() > latestCreateTime) {
                    latestCreateTime = dsv.DSCreateDT.getTime();
                    latestCreated = dsv;
                }
                Entry dsvEntry = this.m_feed.addEntry();
                dsvEntry.setId(this.m_pid.toURI() + "/" + dsv.DatastreamID + "/" + DateUtility.convertDateToString((Date)dsv.DSCreateDT));
                dsvEntry.setTitle(dsv.DSVersionID);
                dsvEntry.setUpdated(dsv.DSCreateDT);
                ThreadHelper.addInReplyTo((Entry)dsvEntry, (String)(this.m_pid.toURI() + "/" + dsv.DatastreamID));
                String altIds = DOTranslationUtility.oneString(dsv.DatastreamAltIDs);
                if (altIds != null && !altIds.equals("")) {
                    dsvEntry.addCategory(AtomDOSerializer.MODEL.ALT_IDS.uri, altIds, null);
                }
                if (dsv.DSFormatURI != null && !dsv.DSFormatURI.equals("")) {
                    dsvEntry.addCategory(AtomDOSerializer.MODEL.FORMAT_URI.uri, dsv.DSFormatURI, null);
                }
                dsvEntry.addCategory(AtomDOSerializer.MODEL.LABEL.uri, dsv.DSLabel == null ? "" : dsv.DSLabel, null);
                String csType = dsv.getChecksumType();
                if (csType != null && csType.length() > 0 && !csType.equals("DISABLED")) {
                    dsvEntry.addCategory(AtomDOSerializer.MODEL.DIGEST_TYPE.uri, csType, null);
                    dsvEntry.addCategory(AtomDOSerializer.MODEL.DIGEST.uri, dsv.getChecksum(), null);
                }
                if (dsv.DSSize != 0L) {
                    dsvEntry.addCategory(AtomDOSerializer.MODEL.LENGTH.uri, Long.toString(dsv.DSSize), null);
                }
                this.setContent(dsvEntry, dsv);
            }
            dsEntry.setId(this.m_pid.toURI() + "/" + latestCreated.DatastreamID);
            dsEntry.setTitle(latestCreated.DatastreamID);
            dsEntry.setUpdated(latestCreated.DSCreateDT);
            dsEntry.addLink(this.m_pid.toURI() + "/" + latestCreated.DatastreamID + "/" + DateUtility.convertDateToString((Date)latestCreated.DSCreateDT), "alternate");
            dsEntry.addCategory(AtomDOSerializer.MODEL.STATE.uri, latestCreated.DSState, null);
            dsEntry.addCategory(AtomDOSerializer.MODEL.CONTROL_GROUP.uri, latestCreated.DSControlGrp, null);
            dsEntry.addCategory(AtomDOSerializer.MODEL.VERSIONABLE.uri, Boolean.toString(latestCreated.DSVersionable), null);
        }
        this.addAuditDatastream();
    }

    private void addAuditDatastream() throws ObjectIntegrityException, StreamIOException {
        if (this.m_obj.getAuditRecords().size() == 0) {
            return;
        }
        String dsId = this.m_pid.toURI() + "/AUDIT";
        String dsvId = dsId + "/" + DateUtility.convertDateToString((Date)this.m_obj.getCreateDate());
        Entry dsEntry = this.m_feed.addEntry();
        dsEntry.setId(dsId);
        dsEntry.setTitle("AUDIT");
        dsEntry.setUpdated(this.m_obj.getCreateDate());
        dsEntry.addCategory(AtomDOSerializer.MODEL.STATE.uri, "A", null);
        dsEntry.addCategory(AtomDOSerializer.MODEL.CONTROL_GROUP.uri, "X", null);
        dsEntry.addCategory(AtomDOSerializer.MODEL.VERSIONABLE.uri, "false", null);
        dsEntry.addLink(dsvId, "alternate");
        Entry dsvEntry = this.m_feed.addEntry();
        dsvEntry.setId(dsvId);
        dsvEntry.setTitle("AUDIT.0");
        dsvEntry.setUpdated(this.m_obj.getCreateDate());
        ThreadHelper.addInReplyTo((Entry)dsvEntry, (String)(this.m_pid.toURI() + "/AUDIT"));
        dsvEntry.addCategory(AtomDOSerializer.MODEL.FORMAT_URI.uri, AtomDOSerializer.AUDIT1_0.uri, null);
        dsvEntry.addCategory(AtomDOSerializer.MODEL.LABEL.uri, "Audit Trail for this object", null);
        if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
            String name = "AUDIT.0.xml";
            try {
                this.m_zout.putNextEntry(new ZipEntry(name));
                StringReader r = new StringReader(DOTranslationUtility.getAuditTrail(this.m_obj));
                IOUtils.copy((Reader)r, (OutputStream)this.m_zout, (String)this.m_encoding);
                this.m_zout.closeEntry();
                ((Reader)r).close();
            }
            catch (IOException e) {
                throw new StreamIOException(e.getMessage(), e);
            }
            IRI iri = new IRI(name);
            dsvEntry.setSummary("AUDIT.0");
            dsvEntry.setContent(iri, "text/xml");
        } else {
            dsvEntry.setContent(DOTranslationUtility.getAuditTrail(this.m_obj), "text/xml");
        }
    }

    private void setContent(Entry entry, Datastream vds) throws UnsupportedEncodingException, StreamIOException {
        if (vds.DSControlGrp.equalsIgnoreCase("X")) {
            this.setInlineXML(entry, (DatastreamXMLMetadata)vds);
        } else if (vds.DSControlGrp.equalsIgnoreCase("E") || vds.DSControlGrp.equalsIgnoreCase("R")) {
            this.setReferencedContent(entry, vds);
        } else if (vds.DSControlGrp.equalsIgnoreCase("M")) {
            this.setManagedContent(entry, vds);
        }
    }

    private void setInlineXML(Entry entry, DatastreamXMLMetadata ds) throws UnsupportedEncodingException, StreamIOException {
        String content = this.m_obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0) && (ds.DatastreamID.equals("SERVICE-PROFILE") || ds.DatastreamID.equals("WSDL")) ? DOTranslationUtility.normalizeInlineXML(new String(ds.xmlContent, this.m_encoding), this.m_transContext) : new String(ds.xmlContent, this.m_encoding);
        if (this.m_format.equals((Object)ATOM_ZIP1_1)) {
            String name = ds.DSVersionID + ".xml";
            try {
                this.m_zout.putNextEntry(new ZipEntry(name));
                ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(this.m_encoding));
                IOUtils.copy((InputStream)is, (OutputStream)this.m_zout);
                this.m_zout.closeEntry();
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new StreamIOException(e.getMessage(), e);
            }
            IRI iri = new IRI(name);
            entry.setSummary(ds.DSVersionID);
            entry.setContent(iri, ds.DSMIME);
        } else {
            entry.setContent(content, ds.DSMIME);
        }
    }

    private void setReferencedContent(Entry entry, Datastream vds) throws StreamIOException {
        entry.setSummary(vds.DSVersionID);
        String dsLocation = StreamUtility.enc(DOTranslationUtility.normalizeDSLocationURLs((String)this.m_obj.getPid(), (Datastream)vds, (int)this.m_transContext).DSLocation);
        IRI iri = new IRI(dsLocation);
        entry.setContent(iri, vds.DSMIME);
    }

    private void setManagedContent(Entry entry, Datastream vds) throws StreamIOException {
        if (this.m_transContext == 4 && !this.m_format.equals((Object)ATOM_ZIP1_1)) {
            String mimeType = vds.DSMIME;
            if (MimeTypeHelper.isText((String)mimeType) || MimeTypeHelper.isXml((String)mimeType)) {
                try {
                    entry.setContent(IOUtils.toString((InputStream)vds.getContentStream(), (String)this.m_encoding), mimeType);
                }
                catch (IOException e) {
                    throw new StreamIOException(e.getMessage(), e);
                }
            } else {
                entry.setContent(vds.getContentStream(), mimeType);
            }
        } else {
            String dsLocation;
            if (this.m_format.equals((Object)ATOM_ZIP1_1) && this.m_transContext != 5) {
                dsLocation = vds.DSVersionID + "." + MimeTypeUtils.fileExtensionForMIMEType((String)vds.DSMIME);
                try {
                    this.m_zout.putNextEntry(new ZipEntry(dsLocation));
                    InputStream is = vds.getContentStream();
                    IOUtils.copy((InputStream)is, (OutputStream)this.m_zout);
                    is.close();
                    this.m_zout.closeEntry();
                }
                catch (IOException e) {
                    throw new StreamIOException(e.getMessage(), e);
                }
            } else {
                dsLocation = StreamUtility.enc(DOTranslationUtility.normalizeDSLocationURLs((String)this.m_obj.getPid(), (Datastream)vds, (int)this.m_transContext).DSLocation);
            }
            IRI iri = new IRI(dsLocation);
            entry.setSummary(vds.DSVersionID);
            entry.setContent(iri, vds.DSMIME);
        }
    }
}

