/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.utilities.LogConfig;
import org.trippi.io.TripleIteratorFactory;
import org.w3c.dom.Document;

public class ConvertObjectSerialization {
    private static final String ENCODING = "UTF-8";
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final OutputFormat fmt;
    private final Date m_now = new Date();
    private final DODeserializer m_deserializer;
    private final DOSerializer m_serializer;
    private final boolean m_pretty;
    private final String m_inExt;
    private final String m_outExt;

    public ConvertObjectSerialization(Class<DODeserializer> deserializer, Class<DOSerializer> serializer, boolean pretty, String inExt, String outExt) {
        this.m_deserializer = ConvertObjectSerialization.getInstance(deserializer);
        this.m_serializer = ConvertObjectSerialization.getInstance(serializer);
        this.m_pretty = pretty;
        this.m_inExt = inExt;
        this.m_outExt = outExt;
    }

    private boolean convert(InputStream source, OutputStream destination) {
        BasicDigitalObject obj = new BasicDigitalObject();
        try {
            this.m_deserializer.deserialize(source, obj, ENCODING, 5);
            this.setObjectDefaults(obj);
            if (this.m_pretty) {
                this.prettyPrint(obj, destination);
            } else {
                this.m_serializer.serialize(obj, destination, ENCODING, 5);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void prettyPrint(DigitalObject obj, OutputStream destination) throws Exception {
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        this.m_serializer.serialize(obj, outBuf, ENCODING, 5);
        ByteArrayInputStream inBuf = new ByteArrayInputStream(outBuf.toByteArray());
        ConvertObjectSerialization.prettyPrint(inBuf, destination);
    }

    private static void prettyPrint(InputStream source, OutputStream destination) throws Exception {
        XMLSerializer ser = new XMLSerializer(destination, fmt);
        Document doc = factory.newDocumentBuilder().parse(source);
        ser.serialize(doc);
        destination.close();
    }

    public boolean convert(File source, File destination) {
        boolean result = true;
        if (source.isDirectory()) {
            File[] children;
            if (source.getName().startsWith(".")) {
                return result;
            }
            result = destination.exists() ? result && destination.isDirectory() : result && destination.mkdirs();
            for (File element : children = source.listFiles()) {
                String inName = element.getName();
                String outName = element.isDirectory() ? inName : inName.substring(0, inName.lastIndexOf(46) + 1) + this.m_outExt;
                result = result && this.convert(new File(source, inName), new File(destination, outName));
            }
            return result;
        }
        try {
            if (!source.getName().endsWith("." + this.m_inExt)) {
                return result;
            }
            FileInputStream in = new FileInputStream(source);
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(destination);
            result = result && this.convert(in, out);
            ((OutputStream)out).close();
            ((InputStream)in).close();
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void setObjectDefaults(DigitalObject obj) {
        if (obj.getCreateDate() == null) {
            obj.setCreateDate(this.m_now);
        }
        if (obj.getLastModDate() == null) {
            obj.setLastModDate(this.m_now);
        }
        Iterator<String> dsIds = obj.datastreamIdIterator();
        while (dsIds.hasNext()) {
            String dsid = dsIds.next();
            for (Datastream ds : obj.datastreams(dsid)) {
                ds.DSSize = 0L;
                if (ds.DSCreateDT != null) continue;
                ds.DSCreateDT = this.m_now;
            }
        }
    }

    public static void main(String[] args) throws ClassNotFoundException {
        File sourceDir;
        LogConfig.initMinimal();
        if (args.length < 4 || args.length > 7) {
            ConvertObjectSerialization.die("Expected 4 to 7 arguments", true);
        }
        if (!(sourceDir = new File(args[0])).isDirectory()) {
            ConvertObjectSerialization.die("Not a directory: " + sourceDir.getPath(), false);
        }
        File destDir = new File(args[1]);
        Class<DODeserializer> deserializer = Class.forName(args[2]);
        Class<DOSerializer> serializer = Class.forName(args[3]);
        System.setProperty("fedora.hostname", "localhost");
        System.setProperty("fedora.port", "8080");
        System.setProperty("fedora.appServerContext", "fedora");
        boolean pretty = args.length > 4 && args[4].equals("true");
        String inExt = "xml";
        if (args.length > 5) {
            inExt = args[5];
        }
        String outExt = "xml";
        if (args.length > 6) {
            outExt = args[6];
        }
        ConvertObjectSerialization converter = new ConvertObjectSerialization(deserializer, serializer, pretty, inExt, outExt);
        converter.convert(sourceDir, destDir);
        TripleIteratorFactory.defaultInstance().shutdown();
    }

    private static <T> T getInstance(Class<T> className) {
        try {
            return className.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            ConvertObjectSerialization.die("Unable to instantiate: " + className, false);
            return null;
        }
    }

    private static void die(String message, boolean showUsage) {
        System.out.println("ERROR: " + message);
        if (showUsage) {
            System.out.println("Usage: ConvertObjectSerialization srcDir dstDir serClass deserClass");
            System.out.println("                                  [pretty] [inExt] [outExt]");
            System.out.println("Where: srcDir     : source directory");
            System.out.println("       dstDir     : destination directory (created if necessary)");
            System.out.println("       deserClass : DODeserializer class name");
            System.out.println("       serClass   : DOSerializer class name");
            System.out.println("       pretty     : if true and output is xml, it will be pretty-printed");
            System.out.println("       inExt      : extension for input files, default is xml");
            System.out.println("       outExt     : extension for output files, default is xml");
        }
        System.exit(1);
    }

    static {
        factory.setNamespaceAware(true);
        fmt = new OutputFormat("XML", ENCODING, true);
        fmt.setIndent(2);
        fmt.setLineWidth(80);
        fmt.setPreserveSpace(false);
    }
}

