/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.translation.DOTranslatorImpl;
import org.fcrepo.server.storage.types.DigitalObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOTranslatorModule
extends Module
implements DOTranslator {
    private static final Logger logger = LoggerFactory.getLogger(DOTranslatorModule.class);
    private static final String DESER_PARAM_PREFIX = "deserializer_";
    private static final String SER_PARAM_PREFIX = "serializer_";
    private DOTranslator m_wrappedTranslator;

    public DOTranslatorModule(Map<String, String> params, Server server, String role) throws ModuleInitializationException {
        super(params, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        HashMap<String, DOSerializer> serMap = new HashMap<String, DOSerializer>();
        HashMap<String, DODeserializer> deserMap = new HashMap<String, DODeserializer>();
        Iterator<String> nameIter = this.parameterNames();
        while (nameIter.hasNext()) {
            String paramName = nameIter.next();
            if (paramName.startsWith(SER_PARAM_PREFIX)) {
                String serName = paramName.substring(SER_PARAM_PREFIX.length());
                try {
                    DOSerializer ser = (DOSerializer)Class.forName(this.getParameter(paramName)).newInstance();
                    serMap.put(serName, ser);
                    continue;
                }
                catch (Exception e) {
                    throw new ModuleInitializationException("Can't instantiate serializer class for format " + serName, this.getRole(), e);
                }
            }
            if (!paramName.startsWith(DESER_PARAM_PREFIX)) continue;
            String deserName = paramName.substring(DESER_PARAM_PREFIX.length());
            try {
                DODeserializer deser = (DODeserializer)Class.forName(this.getParameter(paramName)).newInstance();
                deserMap.put(deserName, deser);
            }
            catch (Exception e) {
                throw new ModuleInitializationException("Can't instantiate deserializer class for format " + deserName, this.getRole(), e);
            }
        }
        this.m_wrappedTranslator = new DOTranslatorImpl(serMap, deserMap);
    }

    @Override
    public void deserialize(InputStream in, DigitalObject out, String format, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        this.m_wrappedTranslator.deserialize(in, out, format, encoding, transContext);
    }

    @Override
    public void serialize(DigitalObject in, OutputStream out, String format, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        this.m_wrappedTranslator.serialize(in, out, format, encoding, transContext);
    }
}

