/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.xml.format.XMLFormat;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.DSBinding;
import org.fcrepo.server.storage.types.DSBindingMap;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.validation.ValidationUtility;
import org.fcrepo.utilities.Base64;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FOXMLDODeserializer
extends DefaultHandler
implements DODeserializer,
Constants {
    public static final XMLFormat DEFAULT_FORMAT = FOXML1_1;
    private static final Logger logger = LoggerFactory.getLogger(FOXMLDODeserializer.class);
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();
    private final XMLFormat m_format;
    private int m_transContext;
    private DigitalObject m_obj;
    private SAXParser m_parser;
    private HashMap<String, String> m_prefixMap;
    private HashMap<String, String> m_localPrefixMap;
    private ArrayList<String> m_prefixList;
    private String m_characterEncoding;
    private boolean m_rootElementFound;
    private String m_objPropertyName;
    private boolean m_readingBinaryContent;
    private File m_binaryContentTempFile;
    private boolean m_inXMLMetadata;
    private int m_xmlDataLevel;
    private String m_dsId;
    private boolean m_dsVersionable;
    private String m_dsVersId;
    private Date m_dsCreateDate;
    private String m_dsState;
    private String[] m_dsAltIds;
    private String m_dsFormatURI;
    private String m_dsLabel;
    private long m_dsSize;
    private String m_dsLocationType;
    private String m_dsLocation;
    private String m_dsMimeType;
    private String m_dsControlGrp;
    private String m_dsInfoType;
    private String m_dsOtherInfoType;
    private int m_dsMDClass;
    private final Pattern metsPattern = Pattern.compile("info:fedora/fedora-system:format/xml.mets.");
    private String m_dsChecksumType;
    private String m_dsChecksum;
    private Disseminator m_diss;
    private String m_dissID;
    @Deprecated
    private String m_sDefID;
    private String m_dissState;
    private boolean m_dissVersionable;
    private ArrayList<DSBinding> m_dsBindings;
    private AuditRecord m_auditRec;
    private boolean m_gotAudit = false;
    private String m_auditComponentID;
    private String m_auditProcessType;
    private String m_auditAction;
    private String m_auditResponsibility;
    private String m_auditDate;
    private String m_auditJustification;
    private StringBuffer m_elementContent;
    private StringBuffer m_dsXMLBuffer;

    public FOXMLDODeserializer() {
        this(DEFAULT_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FOXMLDODeserializer(XMLFormat format) {
        if (!format.equals((Object)FOXML1_0) && !format.equals((Object)FOXML1_1)) {
            throw new IllegalArgumentException("Not a FOXML format: " + format.uri);
        }
        this.m_format = format;
        try {
            SAXParserFactory sAXParserFactory = spf;
            synchronized (sAXParserFactory) {
                this.m_parser = spf.newSAXParser();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing SAX parser", e);
        }
    }

    @Override
    public DODeserializer getInstance() {
        return new FOXMLDODeserializer(this.m_format);
    }

    @Override
    public synchronized void deserialize(InputStream in, DigitalObject obj, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Deserializing " + this.m_format.uri + " for transContext: " + transContext);
        }
        this.m_obj = obj;
        this.m_obj.setLabel("");
        this.m_obj.setOwnerId("");
        this.m_characterEncoding = encoding;
        this.m_transContext = transContext;
        this.initialize();
        try {
            this.m_parser.parse(in, (DefaultHandler)this);
        }
        catch (IOException ioe) {
            throw new StreamIOException("low-level stream io problem occurred while sax was parsing this object.");
        }
        catch (SAXException se) {
            throw new ObjectIntegrityException("FOXML IO stream was bad : " + se.getMessage(), se);
        }
        logger.debug("Just finished parse.");
        if (!this.m_rootElementFound) {
            throw new ObjectIntegrityException("FOXMLDODeserializer: Input stream is not valid FOXML. The digitalObject root element was not detected.");
        }
        DOTranslationUtility.normalizeDatastreams(this.m_obj, this.m_transContext, this.m_characterEncoding);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.m_prefixMap.put(prefix, uri);
        if (this.m_inXMLMetadata) {
            this.m_localPrefixMap.put(prefix, uri);
            this.m_prefixList.add(prefix);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.m_prefixMap.remove(prefix);
        if (this.m_inXMLMetadata) {
            this.m_localPrefixMap.remove(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        this.m_elementContent = new StringBuffer();
        if (uri.equals(FOXMLDODeserializer.FOXML.uri) && !this.m_inXMLMetadata) {
            if (localName.equals("digitalObject")) {
                this.m_rootElementFound = true;
                this.m_obj.setPid(FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "PID"));
            } else if (localName.equals("property") || localName.equals("extproperty")) {
                this.m_objPropertyName = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "NAME");
                if (this.m_objPropertyName.equals(FOXMLDODeserializer.MODEL.STATE.uri)) {
                    try {
                        this.m_obj.setState(DOTranslationUtility.readStateAttribute(FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VALUE")));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Could not read state", e);
                    }
                } else if (this.m_objPropertyName.equals(FOXMLDODeserializer.MODEL.LABEL.uri)) {
                    this.m_obj.setLabel(FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VALUE"));
                } else if (this.m_objPropertyName.equals(FOXMLDODeserializer.MODEL.OWNER.uri)) {
                    this.m_obj.setOwnerId(FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VALUE"));
                } else if (this.m_objPropertyName.equals(FOXMLDODeserializer.MODEL.CREATED_DATE.uri)) {
                    this.m_obj.setCreateDate(DateUtility.convertStringToDate((String)FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VALUE")));
                } else if (this.m_objPropertyName.equals(FOXMLDODeserializer.VIEW.LAST_MODIFIED_DATE.uri)) {
                    this.m_obj.setLastModDate(DateUtility.convertStringToDate((String)FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VALUE")));
                } else {
                    this.m_obj.setExtProperty(this.m_objPropertyName, FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VALUE"));
                }
            } else if (localName.equals("datastream")) {
                this.m_dsId = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "ID");
                this.m_dsState = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "STATE");
                this.m_dsControlGrp = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "CONTROL_GROUP");
                String versionable = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VERSIONABLE");
                this.m_dsVersionable = versionable == null || versionable.equals("") ? true : new Boolean(versionable);
                if (this.m_dsId.equals("AUDIT")) {
                    this.m_dsVersionable = false;
                }
            } else if (localName.equals("datastreamVersion")) {
                this.m_dsVersId = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "ID");
                this.m_dsLabel = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "LABEL");
                this.m_dsCreateDate = DateUtility.convertStringToDate((String)FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "CREATED"));
                String altIDsString = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "ALT_IDS");
                this.m_dsAltIds = altIDsString.length() == 0 ? new String[0] : altIDsString.split(" ");
                this.m_dsFormatURI = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "FORMAT_URI");
                if (this.m_dsFormatURI.length() == 0) {
                    this.m_dsFormatURI = null;
                }
                this.checkMETSFormat(this.m_dsFormatURI);
                this.m_dsMimeType = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "MIMETYPE");
                String sizeString = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "SIZE");
                if (sizeString != null && !sizeString.equals("")) {
                    try {
                        this.m_dsSize = Long.parseLong(sizeString);
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException("If specified, a datastream's SIZE attribute must be an xsd:long.");
                    }
                } else {
                    this.m_dsSize = -1L;
                }
                if (this.m_dsVersId.equals("AUDIT.0")) {
                    this.m_gotAudit = true;
                }
                this.m_dsChecksumType = "DISABLED";
                this.m_dsChecksum = "none";
            } else if (localName.equals("contentDigest")) {
                this.m_dsChecksumType = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "TYPE");
                this.m_dsChecksum = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "DIGEST");
            } else if (localName.equals("xmlContent")) {
                this.m_dsXMLBuffer = new StringBuffer();
                this.m_xmlDataLevel = 0;
                this.m_inXMLMetadata = true;
            } else if (localName.equals("contentLocation")) {
                String dsLocation = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "REF");
                if (dsLocation == null || dsLocation.equals("")) {
                    throw new SAXException("REF attribute must be specified in contentLocation element");
                }
                if (this.m_dsControlGrp.equalsIgnoreCase("E") || this.m_dsControlGrp.equalsIgnoreCase("R")) {
                    try {
                        ValidationUtility.validateURL(dsLocation, this.m_dsControlGrp);
                    }
                    catch (ValidationException ve) {
                        throw new SAXException(ve.getMessage());
                    }
                    this.m_dsLocationType = "URL";
                    this.m_dsLocation = dsLocation;
                    this.instantiateDatastream(new DatastreamReferencedContent());
                } else if (this.m_dsControlGrp.equalsIgnoreCase("M")) {
                    if (this.m_obj.isNew()) {
                        try {
                            ValidationUtility.validateURL(dsLocation, this.m_dsControlGrp);
                            this.m_dsLocationType = "URL";
                        }
                        catch (ValidationException ve) {
                            throw new SAXException(ve.getMessage());
                        }
                    } else {
                        this.m_dsLocationType = "INTERNAL_ID";
                    }
                    this.m_dsLocation = dsLocation;
                    this.instantiateDatastream(new DatastreamManagedContent());
                }
            } else if (localName.equals("binaryContent")) {
                if (this.m_dsControlGrp.equalsIgnoreCase("M")) {
                    this.m_readingBinaryContent = true;
                    this.m_binaryContentTempFile = null;
                    try {
                        this.m_binaryContentTempFile = File.createTempFile("binary-datastream", null);
                    }
                    catch (IOException ioe) {
                        throw new SAXException(new StreamIOException("Unable to create temporary file for binary content"));
                    }
                }
            } else if (this.m_format.equals((Object)FOXML1_0)) {
                this.startDisseminators(localName, a);
            }
        } else if (this.m_inXMLMetadata) {
            this.appendElementStart(uri, localName, qName, a, this.m_dsXMLBuffer);
            if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("xmlContent")) {
                ++this.m_xmlDataLevel;
            }
            if (this.m_gotAudit) {
                if (localName.equals("record")) {
                    this.m_auditRec = new AuditRecord();
                    this.m_auditRec.id = FOXMLDODeserializer.grab(a, uri, "ID");
                } else if (localName.equals("process")) {
                    this.m_auditProcessType = FOXMLDODeserializer.grab(a, uri, "type");
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_elementContent != null) {
            this.m_elementContent.append(ch, start, length);
        }
        if (this.m_inXMLMetadata) {
            StreamUtility.enc(ch, start, length, this.m_dsXMLBuffer);
        } else if (this.m_readingBinaryContent) {
            // empty if block
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_inXMLMetadata) {
            if (this.m_gotAudit) {
                if (localName.equals("action")) {
                    this.m_auditAction = this.m_elementContent.toString();
                } else if (localName.equals("componentID")) {
                    this.m_auditComponentID = this.m_elementContent.toString();
                } else if (localName.equals("responsibility")) {
                    this.m_auditResponsibility = this.m_elementContent.toString();
                } else if (localName.equals("date")) {
                    this.m_auditDate = this.m_elementContent.toString();
                } else if (localName.equals("justification")) {
                    this.m_auditJustification = this.m_elementContent.toString();
                } else if (localName.equals("record")) {
                    this.m_auditRec.processType = this.m_auditProcessType;
                    this.m_auditRec.action = this.m_auditAction;
                    this.m_auditRec.componentID = this.m_auditComponentID;
                    this.m_auditRec.responsibility = this.m_auditResponsibility;
                    this.m_auditRec.date = DateUtility.convertStringToDate((String)this.m_auditDate);
                    this.m_auditRec.justification = this.m_auditJustification;
                    this.m_obj.getAuditRecords().add(this.m_auditRec);
                    this.m_auditProcessType = "";
                    this.m_auditAction = "";
                    this.m_auditComponentID = "";
                    this.m_auditResponsibility = "";
                    this.m_auditDate = "";
                    this.m_auditJustification = "";
                } else if (localName.equals("auditTrail")) {
                    this.m_gotAudit = false;
                }
            } else if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("xmlContent") && this.m_xmlDataLevel == 0) {
                if (this.m_dsId.equals("AUDIT")) {
                    this.m_inXMLMetadata = false;
                } else {
                    DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
                    this.instantiateXMLDatastream(ds);
                    this.m_inXMLMetadata = false;
                    this.m_localPrefixMap.clear();
                }
            } else {
                this.m_dsXMLBuffer.append("</" + qName + ">");
                if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("xmlContent")) {
                    --this.m_xmlDataLevel;
                }
            }
        } else if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("binaryContent")) {
            if (this.m_binaryContentTempFile != null) {
                try {
                    FileOutputStream os = new FileOutputStream(this.m_binaryContentTempFile);
                    String elementStr = this.m_elementContent.toString().replaceAll("\\s", "");
                    byte[] elementBytes = Base64.decode((String)elementStr);
                    os.write(elementBytes);
                    os.close();
                    this.m_dsLocationType = "INTERNAL_ID";
                    this.m_dsLocation = "temp://" + this.m_binaryContentTempFile.getAbsolutePath();
                    this.instantiateDatastream(new DatastreamManagedContent());
                }
                catch (FileNotFoundException fnfe) {
                    throw new SAXException(new StreamIOException("Unable to open temporary file created for binary content"));
                }
                catch (IOException fnfe) {
                    throw new SAXException(new StreamIOException("Error writing to temporary file created for binary content"));
                }
            }
            this.m_binaryContentTempFile = null;
            this.m_readingBinaryContent = false;
        } else if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("datastreamVersion")) {
            this.m_dsVersId = "";
            this.m_dsLabel = "";
            this.m_dsCreateDate = null;
            this.m_dsAltIds = new String[0];
            this.m_dsFormatURI = "";
            this.m_dsMimeType = "";
            this.m_dsSize = -1L;
        } else if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("datastream")) {
            this.m_dsId = "";
            this.m_dsVersionable = true;
            this.m_dsState = "";
            this.m_dsInfoType = "";
            this.m_dsOtherInfoType = "";
            this.m_dsMDClass = 0;
        } else if (this.m_format.equals((Object)FOXML1_0)) {
            this.endDisseminators(uri, localName);
        }
    }

    private void startDisseminators(String localName, Attributes a) {
        if (localName.equals("disseminator")) {
            this.m_dissID = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "ID");
            this.m_sDefID = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "BDEF_CONTRACT_PID");
            this.m_dissState = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "STATE");
            String versionable = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VERSIONABLE");
            this.m_dissVersionable = versionable == null || versionable.equals("") ? true : new Boolean(versionable);
        } else if (localName.equals("disseminatorVersion")) {
            this.m_diss = new Disseminator();
            this.m_diss.dissID = this.m_dissID;
            this.m_diss.bDefID = this.m_sDefID;
            this.m_diss.dissState = this.m_dissState;
            String versionable = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "VERSIONABLE");
            this.m_dissVersionable = versionable == null || versionable.equals("") ? true : new Boolean(versionable);
            this.m_diss.dissVersionID = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "ID");
            this.m_diss.dissLabel = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "LABEL");
            this.m_diss.sDepID = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "BMECH_SERVICE_PID");
            this.m_diss.dissCreateDT = DateUtility.convertStringToDate((String)FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "CREATED"));
        } else if (localName.equals("serviceInputMap")) {
            this.m_diss.dsBindMap = new DSBindingMap();
            this.m_dsBindings = new ArrayList();
            this.m_diss.dsBindMap.dsBindMapID = this.m_diss.dsBindMapID = this.m_diss.dissVersionID + "b";
            this.m_diss.dsBindMap.dsBindMechanismPID = this.m_diss.sDepID;
            this.m_diss.dsBindMap.dsBindMapLabel = "";
            this.m_diss.dsBindMap.state = this.m_diss.dissState;
        } else if (localName.equals("datastreamBinding")) {
            DSBinding dsb = new DSBinding();
            dsb.bindKeyName = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "KEY");
            dsb.bindLabel = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "LABEL");
            dsb.datastreamID = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "DATASTREAM_ID");
            dsb.seqNo = FOXMLDODeserializer.grab(a, FOXMLDODeserializer.FOXML.uri, "ORDER");
            this.m_dsBindings.add(dsb);
        }
    }

    private void endDisseminators(String uri, String localName) {
        if (localName.equals("serviceInputMap")) {
            this.m_diss.dsBindMap.dsBindings = this.m_dsBindings.toArray(new DSBinding[0]);
            this.m_dsBindings = null;
        } else if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("disseminatorVersion")) {
            this.m_obj.disseminators(this.m_diss.dissID).add(this.m_diss);
            this.m_diss = null;
        } else if (uri.equals(FOXMLDODeserializer.FOXML.uri) && localName.equals("disseminator")) {
            this.m_dissID = "";
            this.m_sDefID = "";
            this.m_dissState = "";
            this.m_dissVersionable = true;
        }
    }

    private void appendElementStart(String uri, String localName, String qName, Attributes a, StringBuffer out) {
        String nsuri;
        out.append("<" + qName);
        String[] parts = qName.split(":");
        if (parts.length == 2 && (nsuri = this.m_localPrefixMap.get(parts[0])) == null) {
            this.m_localPrefixMap.put(parts[0], parts[1]);
            this.m_prefixList.add(parts[0]);
        }
        while (this.m_prefixList.size() > 0) {
            String prefix = this.m_prefixList.remove(0);
            out.append(" xmlns");
            if (prefix.length() > 0) {
                out.append(":");
            }
            out.append(prefix + "=\"" + StreamUtility.enc(this.m_prefixMap.get(prefix)) + "\"");
        }
        for (int i = 0; i < a.getLength(); ++i) {
            out.append(" " + a.getQName(i) + "=\"" + StreamUtility.enc(a.getValue(i)) + "\"");
        }
        out.append(">");
    }

    private static String grab(Attributes a, String namespace, String elementName) {
        String ret = a.getValue(namespace, elementName);
        if (ret == null) {
            ret = a.getValue(elementName);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private void instantiateDatastream(Datastream ds) throws SAXException {
        ds.DatastreamID = this.m_dsId;
        ds.DatastreamAltIDs = this.m_dsAltIds;
        ds.DSVersionable = this.m_dsVersionable;
        ds.DSFormatURI = this.m_dsFormatURI;
        ds.DSVersionID = this.m_dsVersId;
        ds.DSLabel = this.m_dsLabel;
        ds.DSCreateDT = this.m_dsCreateDate;
        ds.DSMIME = this.m_dsMimeType;
        ds.DSControlGrp = this.m_dsControlGrp;
        ds.DSState = this.m_dsState;
        if (this.m_dsControlGrp.equals("M")) {
            ds.DSSize = this.m_dsSize;
        }
        ds.DSLocation = this.m_dsLocation;
        ds.DSLocationType = this.m_dsLocationType;
        ds.DSInfoType = "";
        ds.DSChecksumType = this.m_dsChecksumType;
        logger.debug("instantiate datastream: dsid = " + this.m_dsId + "checksumType = " + this.m_dsChecksumType + "checksum = " + this.m_dsChecksum);
        if (this.m_obj.isNew()) {
            logger.debug("New Object: checking supplied checksum");
            if (this.m_dsChecksum != null && !this.m_dsChecksum.equals("") && !this.m_dsChecksum.equals("none")) {
                String tmpChecksum = ds.getChecksum();
                logger.debug("checksum = " + tmpChecksum);
                if (!this.m_dsChecksum.equals(tmpChecksum)) {
                    throw new SAXException(new ValidationException("Checksum Mismatch: " + tmpChecksum));
                }
            }
            ds.DSChecksumType = ds.getChecksumType();
        } else {
            ds.DSChecksum = this.m_dsChecksum;
        }
        ds.DSLocation = DOTranslationUtility.normalizeDSLocationURLs((String)this.m_obj.getPid(), (Datastream)ds, (int)this.m_transContext).DSLocation;
        this.m_obj.addDatastreamVersion(ds, true);
    }

    private void instantiateXMLDatastream(DatastreamXMLMetadata ds) throws SAXException {
        ds.DatastreamID = this.m_dsId;
        ds.DatastreamAltIDs = this.m_dsAltIds;
        ds.DSVersionable = this.m_dsVersionable;
        ds.DSFormatURI = this.m_dsFormatURI;
        ds.DSVersionID = this.m_dsVersId;
        ds.DSLabel = this.m_dsLabel;
        ds.DSCreateDT = this.m_dsCreateDate;
        ds.DSMIME = this.m_dsMimeType == null || this.m_dsMimeType.equals("") ? "text/xml" : this.m_dsMimeType;
        ds.DSControlGrp = "X";
        ds.DSState = this.m_dsState;
        ds.DSLocation = this.m_obj.getPid() + "+" + this.m_dsId + "+" + this.m_dsVersId;
        ds.DSLocationType = this.m_dsLocationType;
        ds.DSInfoType = this.m_dsInfoType;
        ds.DSMDClass = this.m_dsMDClass;
        try {
            String xmlString = this.m_dsXMLBuffer.toString();
            StringBuilder streams = new StringBuilder();
            Iterator<String> ids = this.m_obj.datastreamIdIterator();
            while (ids.hasNext()) {
                streams.append(ids.next() + " ");
            }
            ds.xmlContent = xmlString.getBytes(this.m_characterEncoding);
            StringBuilder rels = new StringBuilder();
            if (this.m_dsId.equals("WSDL")) {
                if (this.m_obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
                    rels.append(Models.SERVICE_DEPLOYMENT_3_0 + "\n");
                }
                logger.debug("Not processing WSDL from " + this.m_obj.getPid() + " with models:\n" + rels);
            }
            ds.DSSize = ds.xmlContent.length;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Error processing inline xml content in SAX parse", uee);
        }
        logger.debug("instantiate datastream: dsid = " + this.m_dsId + "checksumType = " + this.m_dsChecksumType + "checksum = " + this.m_dsChecksum);
        ds.DSChecksumType = this.m_dsChecksumType;
        if (this.m_obj.isNew()) {
            if (this.m_dsChecksum != null && !this.m_dsChecksum.equals("") && !this.m_dsChecksum.equals("none")) {
                String tmpChecksum = ds.getChecksum();
                logger.debug("checksum = " + tmpChecksum);
                if (!this.m_dsChecksum.equals(tmpChecksum)) {
                    throw new SAXException(new ValidationException("Checksum Mismatch: " + tmpChecksum));
                }
            }
            ds.DSChecksumType = ds.getChecksumType();
        } else {
            ds.DSChecksum = this.m_dsChecksum;
        }
        this.m_obj.addDatastreamVersion(ds, true);
    }

    private void checkMETSFormat(String formatURI) {
        Matcher m;
        if (formatURI != null && !formatURI.equals("") && (m = this.metsPattern.matcher(formatURI)).lookingAt()) {
            int index = m.end();
            StringTokenizer st = new StringTokenizer(formatURI.substring(index), ".");
            String mdClass = st.nextToken();
            if (st.hasMoreTokens()) {
                this.m_dsInfoType = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.m_dsOtherInfoType = st.nextToken();
            }
            if (mdClass.equals("techMD")) {
                this.m_dsMDClass = 1;
            } else if (mdClass.equals("sourceMD")) {
                this.m_dsMDClass = 2;
            } else if (mdClass.equals("rightsMD")) {
                this.m_dsMDClass = 3;
            } else if (mdClass.equals("digiprovMD")) {
                this.m_dsMDClass = 4;
            } else if (mdClass.equals("descMD")) {
                this.m_dsMDClass = 5;
            }
            if (this.m_dsInfoType.equals("OTHER")) {
                this.m_dsInfoType = this.m_dsOtherInfoType;
            }
        }
    }

    private void initialize() {
        this.m_rootElementFound = false;
        this.m_objPropertyName = "";
        this.m_readingBinaryContent = false;
        this.m_inXMLMetadata = false;
        this.m_prefixMap = new HashMap();
        this.m_localPrefixMap = new HashMap();
        this.m_prefixList = new ArrayList();
        this.m_dsId = "";
        this.m_dsVersionable = true;
        this.m_dsVersId = "";
        this.m_dsCreateDate = null;
        this.m_dsState = "";
        this.m_dsFormatURI = "";
        this.m_dsSize = -1L;
        this.m_dsLocationType = "";
        this.m_dsLocation = "";
        this.m_dsMimeType = "";
        this.m_dsControlGrp = "";
        this.m_dsInfoType = "";
        this.m_dsOtherInfoType = "";
        this.m_dsMDClass = 0;
        this.m_dsLabel = "";
        this.m_dsXMLBuffer = null;
        this.m_diss = null;
        this.m_dissID = "";
        this.m_sDefID = "";
        this.m_dissState = "";
        this.m_dissVersionable = true;
        this.m_dsBindings = null;
        this.m_auditRec = null;
        this.m_gotAudit = false;
        this.m_auditComponentID = "";
        this.m_auditProcessType = "";
        this.m_auditAction = "";
        this.m_auditResponsibility = "";
        this.m_auditDate = "";
        this.m_auditJustification = "";
    }

    static {
        spf.setValidating(false);
        spf.setNamespaceAware(true);
    }
}

