/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.common.xml.format.XMLFormat;
import org.fcrepo.common.xml.namespace.XMLNamespace;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.DSBinding;
import org.fcrepo.server.storage.types.DSBindingMap;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.validation.ValidationUtility;
import org.fcrepo.utilities.Base64;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class METSFedoraExtDODeserializer
extends DefaultHandler
implements Constants,
DODeserializer {
    public static final XMLFormat DEFAULT_FORMAT = METS_EXT1_1;
    private static final Logger logger = LoggerFactory.getLogger(METSFedoraExtDODeserializer.class);
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();
    private final XMLFormat m_format;
    private final XMLNamespace m_xlink;
    private int m_transContext;
    private DigitalObject m_obj;
    private StringBuffer m_relsBuffer;
    private boolean hasRels = false;
    private HashMap<String, List<String>> m_dsDMDIDs;
    private HashMap<String, List<String>> m_dsADMIDs;
    private HashMap<String, String> m_AuditIdToComponentId;
    private SAXParser m_parser;
    private String m_characterEncoding;
    private HashMap<String, String> m_prefixMap;
    private HashMap<String, String> m_localPrefixMap;
    private ArrayList<String> m_prefixList;
    private boolean m_rootElementFound;
    private String m_agentRole;
    private String m_dsId;
    private String m_dsVersId;
    private Date m_dsCreateDate;
    private String m_dissemId;
    private String m_dissemState;
    private String m_dsState;
    private String m_dsInfoType;
    private String m_dsOtherInfoType;
    private String m_dsLabel;
    private int m_dsMDClass;
    private long m_dsSize;
    private String m_dsLocation;
    private String m_dsLocationType;
    private String m_dsMimeType;
    private String m_dsControlGrp;
    private boolean m_dsVersionable;
    private String m_dsFormatURI;
    private String[] m_dsAltIDs;
    private String m_dsChecksum;
    private String m_dsChecksumType;
    private StringBuffer m_dsXMLBuffer;
    private boolean m_readingContent;
    private boolean m_readingBinaryContent;
    private File m_binaryContentTempFile;
    private StringBuffer m_elementContent;
    private boolean m_inXMLMetadata;
    private int m_xmlDataLevel;
    private StringBuffer m_auditBuffer;
    private String m_auditId;
    private String m_auditProcessType;
    private String m_auditAction;
    private String m_auditComponentID;
    private String m_auditResponsibility;
    private String m_auditDate;
    private String m_auditJustification;
    private HashMap<String, Disseminator> m_dissems;
    private Disseminator m_diss;
    private boolean m_indiv;
    private String m_structId;

    public METSFedoraExtDODeserializer() {
        this(DEFAULT_FORMAT);
    }

    public METSFedoraExtDODeserializer(XMLFormat format) {
        if (format.equals((Object)METS_EXT1_0)) {
            this.m_xlink = OLD_XLINK;
        } else if (format.equals((Object)METS_EXT1_1)) {
            this.m_xlink = XLINK;
        } else {
            throw new IllegalArgumentException("Not a METSFedoraExt format: " + format.uri);
        }
        this.m_format = format;
    }

    @Override
    public DODeserializer getInstance() {
        return new METSFedoraExtDODeserializer(this.m_format);
    }

    @Override
    public void deserialize(InputStream in, DigitalObject obj, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        logger.debug("Deserializing " + this.m_format.uri + " for transContext: " + transContext);
        try {
            this.m_parser = spf.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing SAX parser", e);
        }
        this.m_obj = obj;
        this.m_obj.setOwnerId("");
        this.m_obj.setLabel("");
        this.m_characterEncoding = encoding;
        this.m_transContext = transContext;
        this.initialize();
        try {
            this.m_parser.parse(in, (DefaultHandler)this);
        }
        catch (IOException ioe) {
            throw new StreamIOException("Low-level stream IO problem occurred while SAX parsing this object.");
        }
        catch (SAXException se) {
            throw new ObjectIntegrityException("METS stream was bad : " + se.getMessage());
        }
        if (!this.m_rootElementFound) {
            throw new ObjectIntegrityException("METS root element not found");
        }
        this.convertAudits();
        this.createRelsInt();
        DOTranslationUtility.normalizeDatastreams(this.m_obj, this.m_transContext, this.m_characterEncoding);
        if (this.m_format.equals((Object)METS_EXT1_0)) {
            for (Disseminator diss : this.m_dissems.values()) {
                this.m_obj.disseminators(diss.dissID).add(diss);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.m_prefixMap.put(prefix, uri);
        if (this.m_inXMLMetadata) {
            this.m_localPrefixMap.put(prefix, uri);
            this.m_prefixList.add(prefix);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.m_prefixMap.remove(prefix);
        if (this.m_inXMLMetadata) {
            this.m_localPrefixMap.remove(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && !this.m_inXMLMetadata) {
            if (localName.equals("mets")) {
                this.m_rootElementFound = true;
                this.m_obj.setPid(METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "OBJID"));
                this.m_obj.setLabel(METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "LABEL"));
                if (this.m_format.equals((Object)METS_EXT1_0)) {
                    this.m_obj.setExtProperty(METSFedoraExtDODeserializer.MODEL.CONTENT_MODEL.uri, METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "PROFILE"));
                    this.m_obj.setExtProperty(METSFedoraExtDODeserializer.RDF.TYPE.uri, METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "TYPE"));
                }
            } else {
                if (localName.equals("metsHdr")) {
                    this.m_obj.setCreateDate(DateUtility.convertStringToDate((String)METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CREATEDATE")));
                    this.m_obj.setLastModDate(DateUtility.convertStringToDate((String)METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "LASTMODDATE")));
                    try {
                        this.m_obj.setState(DOTranslationUtility.readStateAttribute(METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "RECORDSTATUS")));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Could not read object state", e);
                    }
                }
                if (localName.equals("agent")) {
                    this.m_agentRole = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ROLE");
                } else if (localName.equals("name") && this.m_agentRole.equals("IPOWNER")) {
                    this.m_readingContent = true;
                    this.m_elementContent = new StringBuffer();
                } else if (localName.equals("amdSec")) {
                    this.m_dsId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
                    this.m_dsState = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "STATUS");
                    String dsVersionable = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "VERSIONABLE");
                    this.m_dsVersionable = dsVersionable != null && !dsVersionable.equals("") ? new Boolean(METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "VERSIONABLE")) : true;
                } else if (localName.equals("dmdSecFedora")) {
                    this.m_dsId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
                    this.m_dsState = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "STATUS");
                    String dsVersionable = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "VERSIONABLE");
                    this.m_dsVersionable = dsVersionable != null && !dsVersionable.equals("") ? new Boolean(METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "VERSIONABLE")) : true;
                } else if (localName.equals("techMD") || localName.equals("descMD") || localName.equals("sourceMD") || localName.equals("rightsMD") || localName.equals("digiprovMD")) {
                    String dateString;
                    this.m_dsVersId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
                    if (localName.equals("techMD")) {
                        this.m_dsMDClass = 1;
                    }
                    if (localName.equals("sourceMD")) {
                        this.m_dsMDClass = 2;
                    }
                    if (localName.equals("rightsMD")) {
                        this.m_dsMDClass = 3;
                    }
                    if (localName.equals("digiprovMD")) {
                        this.m_dsMDClass = 4;
                    }
                    if (localName.equals("descMD")) {
                        this.m_dsMDClass = 5;
                    }
                    if ((dateString = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CREATED")) != null && !dateString.equals("")) {
                        this.m_dsCreateDate = DateUtility.convertStringToDate((String)dateString);
                    }
                } else if (localName.equals("mdWrap")) {
                    this.m_dsInfoType = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "MDTYPE");
                    this.m_dsOtherInfoType = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "OTHERMDTYPE");
                    this.m_dsLabel = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "LABEL");
                    this.m_dsMimeType = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "MIMETYPE");
                    this.m_dsFormatURI = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "FORMAT_URI");
                    String altIDs = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ALT_IDS");
                    this.m_dsAltIDs = altIDs.length() == 0 ? new String[0] : altIDs.split(" ");
                    this.m_dsChecksum = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CHECKSUM");
                    this.m_dsChecksumType = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CHECKSUMTYPE");
                } else if (localName.equals("xmlData")) {
                    this.m_dsXMLBuffer = new StringBuffer();
                    this.m_xmlDataLevel = 0;
                    this.m_inXMLMetadata = true;
                } else if (localName.equals("fileGrp")) {
                    this.m_dsId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
                    String dsVersionable = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "VERSIONABLE");
                    this.m_dsVersionable = dsVersionable != null && !dsVersionable.equals("") ? new Boolean(METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "VERSIONABLE")) : true;
                    this.m_dsVersId = "";
                    this.m_dsCreateDate = null;
                    this.m_dsMimeType = "";
                    this.m_dsControlGrp = "";
                    this.m_dsFormatURI = "";
                    this.m_dsAltIDs = new String[0];
                    this.m_dsState = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "STATUS");
                    this.m_dsSize = -1L;
                    this.m_dsChecksum = "";
                    this.m_dsChecksumType = "";
                } else if (localName.equals("file")) {
                    String altIDs;
                    String formatURI;
                    String sizeString;
                    String DMDID;
                    this.m_dsVersId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
                    String dateString = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CREATED");
                    if (dateString != null && !dateString.equals("")) {
                        this.m_dsCreateDate = DateUtility.convertStringToDate((String)dateString);
                    }
                    this.m_dsMimeType = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "MIMETYPE");
                    this.m_dsControlGrp = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "OWNERID");
                    String ADMID = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ADMID");
                    if (ADMID != null && !"".equals(ADMID)) {
                        ArrayList<String> al = new ArrayList<String>();
                        if (ADMID.indexOf(" ") != -1) {
                            String[] admIds;
                            for (String element : admIds = ADMID.split(" ")) {
                                al.add(element);
                            }
                        } else {
                            al.add(ADMID);
                        }
                        this.m_dsADMIDs.put(this.m_dsVersId, al);
                    }
                    if ((DMDID = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "DMDID")) != null && !"".equals(DMDID)) {
                        ArrayList<String> al = new ArrayList<String>();
                        if (DMDID.indexOf(" ") != -1) {
                            String[] dmdIds;
                            for (String element : dmdIds = DMDID.split(" ")) {
                                al.add(element);
                            }
                        } else {
                            al.add(DMDID);
                        }
                        this.m_dsDMDIDs.put(this.m_dsVersId, al);
                    }
                    if ((sizeString = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "SIZE")) != null && !sizeString.equals("")) {
                        try {
                            this.m_dsSize = Long.parseLong(sizeString);
                        }
                        catch (NumberFormatException nfe) {
                            throw new SAXException("If specified, a datastream's SIZE attribute must be an xsd:long.");
                        }
                    }
                    if ((formatURI = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "FORMAT_URI")) != null && !formatURI.equals("")) {
                        this.m_dsFormatURI = formatURI;
                    }
                    this.m_dsAltIDs = (altIDs = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ALT_IDS")).length() == 0 ? new String[0] : altIDs.split(" ");
                    this.m_dsChecksum = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CHECKSUM");
                    this.m_dsChecksumType = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CHECKSUMTYPE");
                } else if (localName.equals("FLocat")) {
                    this.m_dsLabel = METSFedoraExtDODeserializer.grab(a, this.m_xlink.uri, "title");
                    String dsLocation = METSFedoraExtDODeserializer.grab(a, this.m_xlink.uri, "href");
                    if (dsLocation == null || dsLocation.equals("")) {
                        throw new SAXException("xlink:href must be specified in FLocat element");
                    }
                    if (this.m_dsControlGrp.equalsIgnoreCase("E") || this.m_dsControlGrp.equalsIgnoreCase("R")) {
                        try {
                            ValidationUtility.validateURL(dsLocation, this.m_dsControlGrp);
                        }
                        catch (ValidationException ve) {
                            throw new SAXException(ve.getMessage());
                        }
                        this.m_dsLocationType = "URL";
                        this.m_dsInfoType = "DATA";
                        this.m_dsLocation = dsLocation;
                        this.instantiateDatastream(new DatastreamReferencedContent());
                    } else if (this.m_dsControlGrp.equalsIgnoreCase("M")) {
                        if (this.m_obj.isNew()) {
                            try {
                                ValidationUtility.validateURL(dsLocation, this.m_dsControlGrp);
                                this.m_dsLocationType = "URL";
                            }
                            catch (ValidationException ve) {
                                throw new SAXException(ve.getMessage());
                            }
                        } else {
                            this.m_dsLocationType = "INTERNAL_ID";
                        }
                        this.m_dsInfoType = "DATA";
                        this.m_dsLocation = dsLocation;
                        this.instantiateDatastream(new DatastreamManagedContent());
                    }
                } else if (localName.equals("FContent")) {
                    this.m_readingContent = true;
                    this.m_elementContent = new StringBuffer();
                    if (this.m_dsControlGrp.equalsIgnoreCase("M")) {
                        this.m_readingBinaryContent = true;
                        this.m_binaryContentTempFile = null;
                        try {
                            this.m_binaryContentTempFile = File.createTempFile("binary-datastream", null);
                        }
                        catch (IOException ioe) {
                            throw new SAXException(new StreamIOException("Unable to create temporary file for binary content"));
                        }
                    }
                } else if (this.m_format.equals((Object)METS_EXT1_0)) {
                    this.startDisseminators(localName, a);
                }
            }
        } else if (this.m_inXMLMetadata) {
            this.appendElementStart(uri, localName, qName, a, this.m_dsXMLBuffer);
            if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && localName.equals("xmlData")) {
                ++this.m_xmlDataLevel;
            }
            if (this.m_dsId.equals("FEDORA-AUDITTRAIL") || this.m_dsId.equals("AUDIT")) {
                if (localName.equals("record")) {
                    this.m_auditId = METSFedoraExtDODeserializer.grab(a, uri, "ID");
                } else if (localName.equals("process")) {
                    this.m_auditProcessType = METSFedoraExtDODeserializer.grab(a, uri, "type");
                } else if (localName.equals("action") || localName.equals("componentID") || localName.equals("responsibility") || localName.equals("date") || localName.equals("justification")) {
                    this.m_auditBuffer = new StringBuffer();
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_inXMLMetadata) {
            if (this.m_auditBuffer != null) {
                this.m_auditBuffer.append(ch, start, length);
            } else {
                StreamUtility.enc(ch, start, length, this.m_dsXMLBuffer);
            }
        } else if (this.m_readingContent && this.m_elementContent != null) {
            this.m_elementContent.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_inXMLMetadata) {
            if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && localName.equals("xmlData") && this.m_xmlDataLevel == 0) {
                if (this.m_dsId.equals("FEDORA-AUDITTRAIL") || this.m_dsId.equals("AUDIT")) {
                    AuditRecord a = new AuditRecord();
                    a.id = this.m_auditId;
                    a.processType = this.m_auditProcessType;
                    a.action = this.m_auditAction;
                    a.componentID = this.m_auditComponentID;
                    a.responsibility = this.m_auditResponsibility;
                    a.date = DateUtility.convertStringToDate((String)this.m_auditDate);
                    a.justification = this.m_auditJustification;
                    this.m_obj.getAuditRecords().add(a);
                    this.m_inXMLMetadata = false;
                } else {
                    DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
                    this.instantiateXMLDatastream(ds);
                    this.m_inXMLMetadata = false;
                    this.m_localPrefixMap.clear();
                }
            } else {
                this.m_dsXMLBuffer.append("</" + qName + ">");
                if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && localName.equals("xmlData")) {
                    --this.m_xmlDataLevel;
                }
                if (this.m_dsId.equals("FEDORA-AUDITTRAIL") || this.m_dsId.equals("AUDIT")) {
                    if (localName.equals("action")) {
                        this.m_auditAction = this.m_auditBuffer.toString();
                        this.m_auditBuffer = null;
                    } else if (localName.equals("componentID")) {
                        this.m_auditComponentID = this.m_auditBuffer.toString();
                        this.m_auditBuffer = null;
                    } else if (localName.equals("responsibility")) {
                        this.m_auditResponsibility = this.m_auditBuffer.toString();
                        this.m_auditBuffer = null;
                    } else if (localName.equals("date")) {
                        this.m_auditDate = this.m_auditBuffer.toString();
                        this.m_auditBuffer = null;
                    } else if (localName.equals("justification")) {
                        this.m_auditJustification = this.m_auditBuffer.toString();
                        this.m_auditBuffer = null;
                    }
                }
            }
        } else if (this.m_readingBinaryContent) {
            if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && localName.equals("FContent") && this.m_binaryContentTempFile != null) {
                try {
                    FileOutputStream os = new FileOutputStream(this.m_binaryContentTempFile);
                    String elementStr = this.m_elementContent.toString().replaceAll("\\s", "");
                    byte[] elementBytes = Base64.decode((String)elementStr);
                    os.write(elementBytes);
                    os.close();
                    this.m_dsLocationType = "INTERNAL_ID";
                    this.m_dsLocation = "temp://" + this.m_binaryContentTempFile.getAbsolutePath();
                    this.instantiateDatastream(new DatastreamManagedContent());
                }
                catch (FileNotFoundException fnfe) {
                    throw new SAXException(new StreamIOException("Unable to open temporary file created for binary content"));
                }
                catch (IOException fnfe) {
                    throw new SAXException(new StreamIOException("Error writing to temporary file created for binary content"));
                }
            }
            this.m_binaryContentTempFile = null;
            this.m_readingBinaryContent = false;
            this.m_elementContent = null;
        } else if (this.m_readingContent) {
            if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && localName.equals("name") && this.m_agentRole.equals("IPOWNER")) {
                this.m_obj.setOwnerId(this.m_elementContent.toString());
            } else if (uri.equals(METSFedoraExtDODeserializer.METS.uri) && localName.equals("agent")) {
                this.m_agentRole = null;
            }
            this.m_readingContent = false;
            this.m_elementContent = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startDisseminators(String localName, Attributes a) throws SAXException {
        if (localName.equals("structMap")) {
            if (!METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "TYPE").equals("fedora:dsBindingMap")) throw new SAXException("StructMap must have TYPE fedora:dsBindingMap");
            String bmId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
            if (bmId == null || bmId.equals("")) {
                throw new SAXException("structMap with TYPE fedora:dsBindingMap must specify a non-empty ID attribute.");
            }
            Disseminator diss = new Disseminator();
            diss.dsBindMapID = bmId;
            this.m_dissems.put(bmId, diss);
            this.m_diss = diss;
            this.m_diss.dsBindMap = new DSBindingMap();
            this.m_diss.dsBindMap.dsBindMapID = bmId;
            this.m_indiv = false;
            return;
        } else if (localName.equals("div")) {
            if (this.m_indiv) {
                DSBinding binding = new DSBinding();
                if (this.m_diss.dsBindMap.dsBindings == null) {
                    DSBinding[] bindings = new DSBinding[1];
                    this.m_diss.dsBindMap.dsBindings = bindings;
                    this.m_diss.dsBindMap.dsBindings[0] = binding;
                } else {
                    int curSize = this.m_diss.dsBindMap.dsBindings.length;
                    DSBinding[] oldArray = this.m_diss.dsBindMap.dsBindings;
                    DSBinding[] newArray = new DSBinding[curSize + 1];
                    for (int i = 0; i < curSize; ++i) {
                        newArray[i] = oldArray[i];
                    }
                    newArray[curSize] = binding;
                    this.m_diss.dsBindMap.dsBindings = newArray;
                }
                binding.bindKeyName = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "TYPE");
                binding.bindLabel = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "LABEL");
                binding.seqNo = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ORDER");
                return;
            } else {
                this.m_indiv = true;
                this.m_diss.dsBindMap.dsBindMechanismPID = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "TYPE");
                this.m_diss.dsBindMap.dsBindMapLabel = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "LABEL");
            }
            return;
        } else if (localName.equals("fptr")) {
            DSBinding binding = this.m_diss.dsBindMap.dsBindings[this.m_diss.dsBindMap.dsBindings.length - 1];
            binding.datastreamID = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "FILEID");
            return;
        } else if (localName.equals("behaviorSec")) {
            this.m_dissemId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
            this.m_dissemState = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "STATUS");
            return;
        } else if (localName.equals("serviceBinding")) {
            this.m_structId = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "STRUCTID");
            Disseminator dissem = this.m_dissems.get(this.m_structId);
            dissem.dissID = this.m_dissemId;
            dissem.dissState = this.m_dissemState;
            dissem.dissVersionID = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "ID");
            dissem.bDefID = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "BTYPE");
            dissem.dissCreateDT = DateUtility.convertStringToDate((String)METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "CREATED"));
            dissem.dissLabel = METSFedoraExtDODeserializer.grab(a, METSFedoraExtDODeserializer.METS.uri, "LABEL");
            return;
        } else if (localName.equals("interfaceMD")) {
            Disseminator dissem = this.m_dissems.get(this.m_structId);
            return;
        } else {
            if (!localName.equals("serviceBindMD")) return;
            Disseminator dissem = this.m_dissems.get(this.m_structId);
            dissem.sDepID = METSFedoraExtDODeserializer.grab(a, this.m_xlink.uri, "href");
        }
    }

    private void appendElementStart(String uri, String localName, String qName, Attributes a, StringBuffer out) {
        String nsuri;
        out.append("<" + qName);
        String[] parts = qName.split(":");
        if (parts.length == 2 && (nsuri = this.m_localPrefixMap.get(parts[0])) == null) {
            this.m_localPrefixMap.put(parts[0], parts[1]);
            this.m_prefixList.add(parts[0]);
        }
        while (this.m_prefixList.size() > 0) {
            String prefix = this.m_prefixList.remove(0);
            out.append(" xmlns");
            if (prefix.length() > 0) {
                out.append(":");
            }
            out.append(prefix + "=\"" + StreamUtility.enc(this.m_prefixMap.get(prefix)) + "\"");
        }
        for (int i = 0; i < a.getLength(); ++i) {
            out.append(" " + a.getQName(i) + "=\"" + StreamUtility.enc(a.getValue(i)) + "\"");
        }
        out.append(">");
    }

    private void instantiateDatastream(Datastream ds) throws SAXException {
        ds.DatastreamID = this.m_dsId;
        ds.DSVersionable = this.m_dsVersionable;
        ds.DSFormatURI = this.m_dsFormatURI;
        ds.DatastreamAltIDs = this.m_dsAltIDs;
        ds.DSVersionID = this.m_dsVersId;
        ds.DSLabel = this.m_dsLabel;
        ds.DSCreateDT = this.m_dsCreateDate;
        ds.DSMIME = this.m_dsMimeType;
        ds.DSControlGrp = this.m_dsControlGrp;
        ds.DSState = this.m_dsState;
        ds.DSLocation = this.m_dsLocation;
        ds.DSLocationType = this.m_dsLocationType;
        ds.DSInfoType = this.m_dsInfoType;
        ds.DSChecksumType = this.m_dsChecksumType;
        logger.debug("instantiate datastream: dsid = " + this.m_dsId + "checksumType = " + this.m_dsChecksumType + "checksum = " + this.m_dsChecksum);
        if (this.m_obj.isNew()) {
            if (this.m_dsChecksum != null && !this.m_dsChecksum.equals("") && !this.m_dsChecksum.equals("none")) {
                String tmpChecksum = ds.getChecksum();
                logger.debug("checksum = " + tmpChecksum);
                if (!this.m_dsChecksum.equals(tmpChecksum)) {
                    throw new SAXException(new ValidationException("Checksum Mismatch: " + tmpChecksum));
                }
            }
            ds.DSChecksumType = ds.getChecksumType();
        } else {
            ds.DSChecksum = this.m_dsChecksum;
        }
        ds.DSLocation = DOTranslationUtility.normalizeDSLocationURLs((String)this.m_obj.getPid(), (Datastream)ds, (int)this.m_transContext).DSLocation;
        this.m_obj.addDatastreamVersion(ds, true);
    }

    private void instantiateXMLDatastream(DatastreamXMLMetadata ds) throws SAXException {
        ds.DatastreamID = this.m_dsId;
        ds.DSVersionable = this.m_dsVersionable;
        ds.DSFormatURI = this.m_dsFormatURI;
        ds.DatastreamAltIDs = this.m_dsAltIDs;
        ds.DSVersionID = this.m_dsVersId;
        ds.DSLabel = this.m_dsLabel;
        ds.DSCreateDT = this.m_dsCreateDate;
        ds.DSMIME = this.m_dsMimeType == null || this.m_dsMimeType.equals("") ? "text/xml" : this.m_dsMimeType;
        ds.DSControlGrp = "X";
        ds.DSState = this.m_dsState;
        ds.DSLocation = this.m_obj.getPid() + "+" + this.m_dsId + "+" + this.m_dsVersId;
        ds.DSLocationType = this.m_dsLocationType;
        ds.DSInfoType = this.m_dsInfoType;
        ds.DSMDClass = this.m_dsMDClass;
        ds.DSChecksumType = this.m_dsChecksumType;
        try {
            String xmlString = this.m_dsXMLBuffer.toString();
            ds.xmlContent = xmlString.getBytes(this.m_characterEncoding);
            ds.DSSize = ds.xmlContent.length;
        }
        catch (Exception uee) {
            logger.debug("Error processing inline xml content in SAX parse: " + uee.getMessage());
        }
        logger.debug("instantiate datastream: dsid = " + this.m_dsId + "checksumType = " + this.m_dsChecksumType + "checksum = " + this.m_dsChecksum);
        if (this.m_obj.isNew()) {
            if (this.m_dsChecksum != null && !this.m_dsChecksum.equals("") && !this.m_dsChecksum.equals("none")) {
                String tmpChecksum = ds.getChecksum();
                logger.debug("checksum = " + tmpChecksum);
                if (!this.m_dsChecksum.equals(tmpChecksum)) {
                    throw new SAXException(new ValidationException("Checksum Mismatch: " + tmpChecksum));
                }
            }
            ds.DSChecksumType = ds.getChecksumType();
        } else {
            ds.DSChecksum = this.m_dsChecksum;
        }
        this.m_obj.addDatastreamVersion(ds, true);
    }

    private void convertAudits() {
        if (this.m_dsADMIDs.size() > 0) {
            Iterator<String> dsIdIter = this.m_obj.datastreamIdIterator();
            while (dsIdIter.hasNext()) {
                for (Datastream ds : this.m_obj.datastreams(dsIdIter.next())) {
                    List<String> admIdList = this.m_dsADMIDs.get(ds.DSVersionID);
                    ArrayList<String> cleanAdmIdList = new ArrayList<String>();
                    if (admIdList != null) {
                        for (String admId : admIdList) {
                            Iterator<Datastream> matchedDatastreams = this.m_obj.datastreams(admId).iterator();
                            if (matchedDatastreams.hasNext()) {
                                this.m_AuditIdToComponentId.put(admId, ds.DSVersionID);
                                continue;
                            }
                            cleanAdmIdList.add(admId);
                        }
                    }
                    if (cleanAdmIdList.size() <= 0) {
                        this.m_dsADMIDs.remove(ds.DSVersionID);
                        continue;
                    }
                    this.m_dsADMIDs.put(ds.DSVersionID, cleanAdmIdList);
                }
            }
            for (AuditRecord au : this.m_obj.getAuditRecords()) {
                String dsVersId;
                if (au.componentID != null && !au.componentID.equals("") || (dsVersId = this.m_AuditIdToComponentId.get(au.id)) == null || dsVersId.equals("")) continue;
                au.componentID = dsVersId.substring(0, dsVersId.indexOf("."));
            }
        }
    }

    private void createRelsInt() {
        Iterator<Datastream> metsrels = this.m_obj.datastreams("RELS-INT").iterator();
        if (metsrels.hasNext()) {
            this.m_relsBuffer = new StringBuffer();
            this.appendRDFStart(this.m_relsBuffer);
            Iterator<String> dsIds = this.m_obj.datastreamIdIterator();
            while (dsIds.hasNext()) {
                HashSet<String> uniqueDMDIDs = new HashSet<String>();
                HashSet<String> uniqueADMIDs = new HashSet<String>();
                for (Datastream dsVersion : this.m_obj.datastreams(dsIds.next())) {
                    List<String> cleanAdmIdList;
                    List<String> dmdIdList = this.m_dsDMDIDs.get(dsVersion.DSVersionID);
                    if (dmdIdList != null) {
                        this.hasRels = true;
                        for (String dmdId : dmdIdList) {
                            if (!uniqueDMDIDs.contains(dmdId)) {
                                this.appendRDFRel(this.m_relsBuffer, this.m_obj.getPid(), dsVersion.DatastreamID, "hasDescMetadata", dmdId);
                            }
                            uniqueDMDIDs.add(dmdId);
                        }
                    }
                    if ((cleanAdmIdList = this.m_dsADMIDs.get(dsVersion.DSVersionID)) == null) continue;
                    this.hasRels = true;
                    for (String admId : cleanAdmIdList) {
                        if (!uniqueADMIDs.contains(admId)) {
                            this.appendRDFRel(this.m_relsBuffer, this.m_obj.getPid(), dsVersion.DatastreamID, "hasAdminMetadata", admId);
                        }
                        uniqueADMIDs.add(admId);
                    }
                }
            }
            if (this.hasRels) {
                METSFedoraExtDODeserializer.appendRDFEnd(this.m_relsBuffer);
                this.setRDFAsDatastream(this.m_relsBuffer);
            } else {
                this.m_relsBuffer = null;
            }
        }
    }

    private void setRDFAsDatastream(StringBuffer buf) {
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        ds.DatastreamID = "RELS-INT";
        ds.DSVersionable = false;
        ds.DSFormatURI = this.m_dsFormatURI;
        ds.DatastreamAltIDs = this.m_dsAltIDs;
        ds.DSVersionID = "RELS-INT.0";
        ds.DSLabel = "DO NOT EDIT: System-generated datastream to preserve METS DMDID/ADMID relationships.";
        ds.DSCreateDT = new Date();
        ds.DSMIME = "application/rdf+xml";
        ds.DSControlGrp = "X";
        ds.DSState = "A";
        ds.DSLocation = this.m_obj.getPid() + "+" + ds.DatastreamID + "+" + ds.DSVersionID;
        ds.DSLocationType = "INTERNAL_ID";
        ds.DSInfoType = "DATA";
        ds.DSMDClass = 1;
        try {
            ds.xmlContent = buf.toString().getBytes(this.m_characterEncoding);
            ds.DSSize = ds.xmlContent.length;
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Encoding error when creating RELS-INT datastream", (Throwable)uee);
        }
        this.m_obj.addDatastreamVersion(ds, true);
    }

    private StringBuffer appendRDFStart(StringBuffer buf) {
        buf.append("<" + METSFedoraExtDODeserializer.RDF.prefix + ":RDF" + " xmlns:" + METSFedoraExtDODeserializer.RDF.prefix + "=\"" + METSFedoraExtDODeserializer.RDF.uri + "\"" + " xmlns:" + METSFedoraExtDODeserializer.RELS_EXT.prefix + "=\"" + METSFedoraExtDODeserializer.RELS_EXT.uri + "\">\n");
        return buf;
    }

    private StringBuffer appendRDFRel(StringBuffer buf, String pid, String subjectNodeId, String relType, String objectNodeId) {
        buf.append("    <" + METSFedoraExtDODeserializer.RDF.prefix + ":Description " + METSFedoraExtDODeserializer.RDF.prefix + ":about=\"" + "info:fedora/" + pid + "/" + subjectNodeId + "\">\n");
        buf.append("        <" + METSFedoraExtDODeserializer.RELS_EXT.prefix + ":" + relType + " " + METSFedoraExtDODeserializer.RDF.prefix + ":resource=\"" + "info:fedora/" + pid + "/" + objectNodeId + "\"/>\n");
        buf.append("    </" + METSFedoraExtDODeserializer.RDF.prefix + ":Description" + ">\n");
        return buf;
    }

    private void initialize() {
        this.m_rootElementFound = false;
        this.m_inXMLMetadata = false;
        this.m_prefixMap = new HashMap();
        this.m_localPrefixMap = new HashMap();
        this.m_prefixList = new ArrayList();
        this.m_dsId = "";
        this.m_dsVersionable = true;
        this.m_dsVersId = "";
        this.m_dsCreateDate = null;
        this.m_dsState = "";
        this.m_dsFormatURI = "";
        this.m_dsAltIDs = new String[0];
        this.m_dsSize = -1L;
        this.m_dsLocationType = "";
        this.m_dsLocation = "";
        this.m_dsMimeType = "";
        this.m_dsControlGrp = "";
        this.m_dsInfoType = "";
        this.m_dsOtherInfoType = "";
        this.m_dsMDClass = 0;
        this.m_dsLabel = "";
        this.m_dsXMLBuffer = null;
        this.m_dsADMIDs = new HashMap();
        this.m_dsDMDIDs = new HashMap();
        this.m_dsChecksum = "";
        this.m_dsChecksumType = "";
        this.m_dissems = new HashMap();
        this.m_auditBuffer = null;
        this.m_auditId = "";
        this.m_auditComponentID = "";
        this.m_auditProcessType = "";
        this.m_auditAction = "";
        this.m_auditResponsibility = "";
        this.m_auditDate = "";
        this.m_auditJustification = "";
        this.m_AuditIdToComponentId = new HashMap();
        this.m_relsBuffer = null;
    }

    private static StringBuffer appendRDFEnd(StringBuffer buf) {
        buf.append("</" + METSFedoraExtDODeserializer.RDF.prefix + ":RDF>\n");
        return buf;
    }

    private static String grab(Attributes a, String namespace, String elementName) {
        String ret = a.getValue(namespace, elementName);
        if (ret == null) {
            ret = a.getValue(elementName);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    static {
        spf.setValidating(false);
        spf.setNamespaceAware(true);
    }
}

