/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.JRDF;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.RDFRelationshipReader;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;

public class BasicDigitalObject
implements DigitalObject {
    private boolean m_isNew;
    private String m_pid;
    private String m_state;
    private String m_ownerId;
    private String m_label;
    private Set<RelationshipTuple> m_rels;
    private Date m_createDate;
    private Date m_lastModDate;
    private final DatastreamProcessor m_datastreamProcessor;
    private final ArrayList<AuditRecord> m_auditRecords = new ArrayList();
    private final LinkedHashMap<String, List<Datastream>> m_datastreams = new LinkedHashMap();
    private final HashMap<String, List<Disseminator>> m_disseminators = new HashMap();
    private final Map<String, String> m_extProperties = new HashMap<String, String>();

    public BasicDigitalObject() {
        this.m_datastreamProcessor = new RelationshipProcessor();
        this.setNew(false);
    }

    @Override
    public boolean isNew() {
        return this.m_isNew;
    }

    @Override
    public void setNew(boolean isNew) {
        this.m_isNew = isNew;
    }

    @Override
    public String getPid() {
        return this.m_pid;
    }

    @Override
    public void setPid(String pid) {
        this.m_pid = pid;
    }

    @Override
    public String getState() {
        return this.m_state;
    }

    @Override
    public void setState(String state) {
        this.m_state = state;
    }

    @Override
    public String getOwnerId() {
        return this.m_ownerId;
    }

    @Override
    public void setOwnerId(String owner) {
        this.m_ownerId = owner;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public Date getCreateDate() {
        return this.m_createDate;
    }

    @Override
    public void setCreateDate(Date createDate) {
        this.m_createDate = createDate;
    }

    @Override
    public Date getLastModDate() {
        return this.m_lastModDate;
    }

    @Override
    public void setLastModDate(Date lastModDate) {
        this.m_lastModDate = lastModDate;
    }

    @Override
    public List<AuditRecord> getAuditRecords() {
        return this.m_auditRecords;
    }

    @Override
    public Iterator<String> datastreamIdIterator() {
        return BasicDigitalObject.copyOfKeysForNonEmptyLists(this.m_datastreams).iterator();
    }

    private static <T> Set<String> copyOfKeysForNonEmptyLists(Map<String, List<T>> map) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Map.Entry<String, List<T>> e : map.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            set.add(e.getKey());
        }
        return set;
    }

    @Override
    public Iterable<Datastream> datastreams(String id) {
        if (!this.m_datastreams.containsKey(id)) {
            return new ArrayList<Datastream>();
        }
        return Collections.unmodifiableList(new ArrayList(this.m_datastreams.get(id)));
    }

    @Override
    public void removeDatastreamVersion(Datastream ds) {
        this.remove(ds);
    }

    @Override
    public void addDatastreamVersion(Datastream ds, boolean addNewVersion) {
        if (!addNewVersion) {
            Datastream latestCreated = null;
            long latestCreateTime = -1L;
            for (Datastream d : this.datastreams(ds.DatastreamID)) {
                if (d.DSCreateDT.getTime() <= latestCreateTime) continue;
                latestCreateTime = d.DSCreateDT.getTime();
                latestCreated = d;
            }
            this.remove(latestCreated);
        }
        this.add(ds);
    }

    private void add(Datastream d) {
        String id = d.DatastreamID;
        if (!this.m_datastreams.containsKey(id)) {
            this.m_datastreams.put(id, new ArrayList());
        }
        this.m_datastreams.get(id).add(d);
        this.m_datastreamProcessor.processAdd(d);
    }

    private void remove(Datastream d) {
        if (d == null) {
            return;
        }
        List<Datastream> datastreams = this.m_datastreams.get(d.DatastreamID);
        if (datastreams == null) {
            return;
        }
        int size = datastreams.size();
        for (int i = 0; i < size; ++i) {
            Datastream v = datastreams.get(i);
            if (!d.DSVersionID.equals(v.DSVersionID)) continue;
            datastreams.remove(i);
            this.m_datastreamProcessor.processRemove(v);
            break;
        }
        if (datastreams.size() == 0) {
            this.m_datastreams.remove(d.DatastreamID);
        }
    }

    @Override
    @Deprecated
    public Iterator<String> disseminatorIdIterator() {
        return BasicDigitalObject.copyOfKeysForNonEmptyLists(this.m_disseminators).iterator();
    }

    @Override
    @Deprecated
    public List<Disseminator> disseminators(String id) {
        ArrayList ret = (ArrayList)this.m_disseminators.get(id);
        if (ret == null) {
            ret = new ArrayList();
            this.m_disseminators.put(id, ret);
        }
        return ret;
    }

    @Override
    public String newDatastreamID() {
        return this.newID(this.datastreamIdIterator(), "DS");
    }

    @Override
    public String newDatastreamID(String id) {
        ArrayList<String> versionIDs = new ArrayList<String>();
        for (Datastream ds : this.m_datastreams.get(id)) {
            versionIDs.add(ds.DSVersionID);
        }
        return this.newID(versionIDs.iterator(), id + ".");
    }

    @Override
    public String newAuditRecordID() {
        ArrayList<String> auditIDs = new ArrayList<String>();
        for (AuditRecord record : this.m_auditRecords) {
            auditIDs.add(record.id);
        }
        return this.newID(auditIDs.iterator(), "AUDREC");
    }

    @Override
    public void setExtProperty(String propName, String propValue) {
        this.m_extProperties.put(propName, propValue);
    }

    @Override
    public String getExtProperty(String propName) {
        return this.m_extProperties.get(propName);
    }

    @Override
    public Map<String, String> getExtProperties() {
        return this.m_extProperties;
    }

    @Override
    public boolean hasRelationship(PredicateNode predicate, ObjectNode object) {
        return this.hasRelationship((SubjectNode)PID.toURIReference((String)this.m_pid), predicate, object);
    }

    @Override
    public boolean hasRelationship(SubjectNode subject, PredicateNode predicate, ObjectNode object) {
        return this.getRelationships(subject, predicate, object).size() > 0;
    }

    @Override
    public Set<RelationshipTuple> getRelationships(PredicateNode predicate, ObjectNode object) {
        return this.getRelationships((SubjectNode)PID.toURIReference((String)this.m_pid), predicate, object);
    }

    @Override
    public Set<RelationshipTuple> getRelationships() {
        return this.getRelationships(null, null, null);
    }

    @Override
    public Set<RelationshipTuple> getRelationships(SubjectNode subject, PredicateNode predicate, ObjectNode object) {
        HashSet<RelationshipTuple> foundRels = new HashSet<RelationshipTuple>();
        if (this.m_rels == null) {
            this.readRels();
        }
        boolean basicExplicit = false;
        for (RelationshipTuple t : this.m_rels) {
            if (Constants.MODEL.HAS_MODEL.uri.equals(t.predicate) && Models.isBasicModel((String)t.object)) {
                basicExplicit = true;
            }
            if (subject != null && !JRDF.sameSubject((SubjectNode)subject, (String)t.subject) || predicate != null && !JRDF.samePredicate((PredicateNode)predicate, (String)t.predicate) || object != null && !JRDF.sameObject((ObjectNode)object, (String)t.object, (boolean)t.isLiteral, (URI)t.datatype, (String)t.language)) continue;
            foundRels.add(t);
        }
        try {
            if (!(basicExplicit || subject != null && !JRDF.sameSubject((SubjectNode)subject, (SubjectNode)new SimpleURIReference(new URI(PID.toURI((String)this.m_pid)))) || predicate != null && !JRDF.samePredicate((PredicateNode)predicate, (PredicateNode)Constants.MODEL.HAS_MODEL) || object != null && !JRDF.sameObject((ObjectNode)object, (ObjectNode)Models.FEDORA_OBJECT_CURRENT))) {
                foundRels.add(new RelationshipTuple(Constants.FEDORA.uri + this.m_pid, Constants.MODEL.HAS_MODEL.uri, Models.FEDORA_OBJECT_CURRENT.uri, false, null));
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return foundRels;
    }

    @Override
    public List<String> getContentModels() {
        Set<RelationshipTuple> cmTubles = this.getRelationships((PredicateNode)Constants.MODEL.HAS_MODEL, null);
        ArrayList<String> cms = new ArrayList<String>();
        for (RelationshipTuple cmTuble : cmTubles) {
            cms.add(cmTuble.object);
        }
        return cms;
    }

    @Override
    public boolean hasContentModel(ObjectNode contentModel) {
        return this.hasRelationship((PredicateNode)Constants.MODEL.HAS_MODEL, contentModel);
    }

    private String newID(Iterator<String> iter, String start) {
        int highest = 0;
        while (iter.hasNext()) {
            String id = iter.next();
            if (!id.startsWith(start) || id.length() <= start.length()) continue;
            try {
                int num = Integer.parseInt(id.substring(start.length()));
                if (num <= highest) continue;
                highest = num;
            }
            catch (NumberFormatException ignored) {}
        }
        int newNum = highest + 1;
        return start + newNum;
    }

    private void readRels() {
        this.m_rels = this.getRels("RELS-EXT");
        this.m_rels.addAll(this.getRels("RELS-INT"));
    }

    private Set<RelationshipTuple> getRels(String relsDatastreamName) {
        List<Datastream> relsDatastreamVersions = this.m_datastreams.get(relsDatastreamName);
        if (relsDatastreamVersions == null || relsDatastreamVersions.size() == 0) {
            return new HashSet<RelationshipTuple>();
        }
        Datastream latestRels = relsDatastreamVersions.get(0);
        for (Datastream v : relsDatastreamVersions) {
            if (v.DSCreateDT == null) {
                latestRels = v;
                break;
            }
            if (v.DSCreateDT.getTime() <= latestRels.DSCreateDT.getTime()) continue;
            latestRels = v;
        }
        try {
            return RDFRelationshipReader.readRelationships(latestRels);
        }
        catch (ServerException e) {
            throw new RuntimeException("Error reading object relationships in " + relsDatastreamName, e);
        }
    }

    private class RelationshipProcessor
    extends DatastreamProcessor {
        private static final String RELS_EXT = "RELS-EXT";
        private static final String RELS_INT = "RELS-INT";

        private RelationshipProcessor() {
        }

        @Override
        void processRemove(Datastream d) {
            this.invalidateIfLatestRels(d);
        }

        @Override
        void processAdd(Datastream d) {
            this.invalidateIfLatestRels(d);
        }

        private void invalidateIfLatestRels(Datastream d) {
            if ((d.DatastreamID.equals(RELS_EXT) || d.DatastreamID.equals(RELS_INT)) && this.isLatestVersion(d)) {
                BasicDigitalObject.this.m_rels = null;
            }
        }
    }

    private abstract class DatastreamProcessor {
        private DatastreamProcessor() {
        }

        abstract void processAdd(Datastream var1);

        abstract void processRemove(Datastream var1);

        boolean isLatestVersion(Datastream d) {
            List versions = (List)BasicDigitalObject.this.m_datastreams.get(d.DatastreamID);
            if (d.DSCreateDT == null || versions == null || versions.size() == 0) {
                return true;
            }
            long created = d.DSCreateDT.getTime();
            for (Datastream v : versions) {
                if (v.DSCreateDT.getTime() <= created) continue;
                return false;
            }
            return true;
        }
    }
}

