/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.utilities.StringUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datastream {
    private static final Logger logger = LoggerFactory.getLogger(Datastream.class);
    public static final String CHECKSUMTYPE_DISABLED = "DISABLED";
    public static final String CHECKSUM_NONE = "none";
    public static final String CHECKSUM_IOEXCEPTION = "ExceptionReadingStream";
    public static final String DS_LOCATION_TYPE_INTERNAL = "INTERNAL_ID";
    public static final String DS_LOCATION_TYPE_URL = "URL";
    public boolean isNew = false;
    public String DatastreamID;
    public String[] DatastreamAltIDs = new String[0];
    public String DSFormatURI;
    public String DSMIME;
    public String DSControlGrp;
    public String DSInfoType;
    public String DSState;
    public boolean DSVersionable;
    public String DSVersionID;
    public String DSLabel;
    public Date DSCreateDT;
    public long DSSize;
    public String DSLocation;
    public String DSLocationType;
    public String DSChecksumType;
    public String DSChecksum;
    public static boolean autoChecksum = false;
    public static String defaultChecksumType = "DISABLED";

    public InputStream getContentStream() throws StreamIOException {
        ReadOnlyContext context = null;
        try {
            context = ReadOnlyContext.getContext(null, null, "", false);
        }
        catch (Throwable t) {
            context = null;
        }
        return this.getContentStream(context);
    }

    public InputStream getContentStream(Context context) throws StreamIOException {
        return null;
    }

    public InputStream getContentStreamForChecksum() throws StreamIOException {
        ReadOnlyContext context;
        MultiValueMap environmentAttributes = Datastream.beginEnvironmentMap("");
        try {
            environmentAttributes.set(Constants.HTTP_REQUEST.CLIENT_IP_ADDRESS.uri, "127.0.0.1");
        }
        catch (Exception e) {
            logger.warn("Could not set client IP for checksum context!");
        }
        try {
            context = ReadOnlyContext.getContext(null, null, "fcrepo-checksum", false);
        }
        catch (Exception e) {
            throw new StreamIOException(e.getMessage(), e);
        }
        context.setEnvironmentValues(environmentAttributes);
        return this.getContentStream(context);
    }

    public static String getDefaultChecksumType() {
        return defaultChecksumType;
    }

    public String getChecksumType() {
        if (this.DSChecksumType == null || this.DSChecksumType.equals("") || this.DSChecksumType.equals(CHECKSUM_NONE)) {
            this.DSChecksumType = Datastream.getDefaultChecksumType();
            if (this.DSChecksumType == null) {
                logger.warn("checksumType is null");
            }
        }
        return this.DSChecksumType;
    }

    public String getChecksum() {
        if (this.DSChecksum == null || this.DSChecksum.equals(CHECKSUM_NONE)) {
            this.DSChecksum = this.computeChecksum(this.getChecksumType());
        }
        logger.debug("Checksum = " + this.DSChecksum);
        return this.DSChecksum;
    }

    public String setChecksum(String csType) {
        if (csType != null) {
            this.DSChecksumType = csType;
        }
        logger.debug("setting checksum using type: " + this.DSChecksumType);
        this.DSChecksum = this.computeChecksum(this.DSChecksumType);
        return this.DSChecksum;
    }

    public boolean compareChecksum() {
        if (this.DSChecksumType == null || this.DSChecksumType.equals("") || this.DSChecksumType.equals(CHECKSUM_NONE)) {
            return false;
        }
        if (this.DSChecksum == null) {
            return false;
        }
        if (this.DSChecksumType.equals(CHECKSUMTYPE_DISABLED)) {
            return true;
        }
        String curChecksum = this.computeChecksum(this.DSChecksumType);
        return curChecksum.equals(this.DSChecksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeChecksum(String csType) {
        logger.debug("checksumType is {}", (Object)csType);
        String checksum = CHECKSUM_NONE;
        if (csType == null) {
            logger.warn("checksumType is null");
        }
        if (csType.equals(CHECKSUMTYPE_DISABLED)) {
            checksum = CHECKSUM_NONE;
            return checksum;
        }
        InputStream is = null;
        try {
            MessageDigest md = MessageDigest.getInstance(csType);
            logger.debug("Classname = {}", (Object)this.getClass().getName());
            logger.debug("location = {}", (Object)this.DSLocation);
            is = this.getContentStreamForChecksum();
            if (is != null) {
                int numread;
                byte[] buffer = new byte[5000];
                logger.debug("Reading content...");
                while ((numread = is.read(buffer, 0, 5000)) > 0) {
                    md.update(buffer, 0, numread);
                }
                is.close();
                logger.debug("...Done reading content");
                checksum = StringUtility.byteArraytoHexString(md.digest());
            }
        }
        catch (NoSuchAlgorithmException e) {
            checksum = CHECKSUM_NONE;
        }
        catch (StreamIOException e) {
            checksum = CHECKSUM_IOEXCEPTION;
            logger.warn("IOException reading datastream to generate checksum");
        }
        catch (IOException e) {
            checksum = CHECKSUM_IOEXCEPTION;
            logger.warn("IOException reading datastream to generate checksum");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("IOException closing stream (computeChecksum) in finally");
                }
            }
        }
        return checksum;
    }

    public static String validateChecksumType(String checksumType) throws GeneralException {
        String csType = null;
        if (checksumType == null || checksumType.equalsIgnoreCase("DEFAULT")) {
            return Datastream.getDefaultChecksumType();
        }
        if (checksumType.equalsIgnoreCase(CHECKSUMTYPE_DISABLED)) {
            return CHECKSUMTYPE_DISABLED;
        }
        if (checksumType.equalsIgnoreCase("MD5")) {
            csType = "MD5";
        }
        if (checksumType.equalsIgnoreCase("SHA-1")) {
            csType = "SHA-1";
        }
        if (checksumType.equalsIgnoreCase("SHA-256")) {
            csType = "SHA-256";
        }
        if (checksumType.equalsIgnoreCase("SHA-384")) {
            csType = "SHA-384";
        }
        if (checksumType.equalsIgnoreCase("SHA-512")) {
            csType = "SHA-512";
        }
        if (checksumType.equalsIgnoreCase("HAVAL")) {
            csType = "HAVAL";
        }
        if (checksumType.equalsIgnoreCase("TIGER")) {
            csType = "TIGER";
        }
        if (checksumType.equalsIgnoreCase("WHIRLPOOL")) {
            csType = "WHIRLPOOL";
        }
        if (csType == null) {
            throw new GeneralException("Unknown checksum algorithm specified: " + checksumType);
        }
        try {
            MessageDigest.getInstance(csType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralException("Checksum algorithm not yet implemented: " + csType);
        }
        return csType;
    }

    public Datastream copy() {
        Datastream ds = new Datastream();
        this.copy(ds);
        return ds;
    }

    public void copy(Datastream target) {
        target.isNew = this.isNew;
        target.DatastreamID = this.DatastreamID;
        if (this.DatastreamAltIDs != null) {
            target.DatastreamAltIDs = new String[this.DatastreamAltIDs.length];
            for (int i = 0; i < this.DatastreamAltIDs.length; ++i) {
                target.DatastreamAltIDs[i] = this.DatastreamAltIDs[i];
            }
        }
        target.DSFormatURI = this.DSFormatURI;
        target.DSMIME = this.DSMIME;
        target.DSControlGrp = this.DSControlGrp;
        target.DSInfoType = this.DSInfoType;
        target.DSState = this.DSState;
        target.DSVersionable = this.DSVersionable;
        target.DSVersionID = this.DSVersionID;
        target.DSLabel = this.DSLabel;
        target.DSCreateDT = this.DSCreateDT;
        target.DSSize = this.DSSize;
        target.DSLocation = this.DSLocation;
        target.DSLocationType = this.DSLocationType;
        target.DSChecksumType = this.DSChecksumType;
        target.DSChecksum = this.DSChecksum;
    }

    private static final MultiValueMap beginEnvironmentMap(String messageProtocol) {
        MultiValueMap environmentMap = new MultiValueMap();
        try {
            environmentMap.set(Constants.HTTP_REQUEST.MESSAGE_PROTOCOL.uri, messageProtocol);
            Date now = new Date();
            environmentMap.set(Constants.ENVIRONMENT.CURRENT_DATE_TIME.uri, DateUtility.convertDateToString((Date)now));
            environmentMap.set(Constants.ENVIRONMENT.CURRENT_DATE.uri, DateUtility.convertDateToDateString((Date)now));
            environmentMap.set(Constants.ENVIRONMENT.CURRENT_TIME.uri, DateUtility.convertDateToTimeString((Date)now));
        }
        catch (Exception e) {
            logger.warn("Datastream could not set envAttributes for checksum context");
        }
        return environmentMap;
    }
}

