/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.io.File;
import java.io.InputStream;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.InitializationException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.MIMETypedStream;

public class DatastreamReferencedContent
extends Datastream {
    private static ExternalContentManager s_ecm;

    @Override
    public Datastream copy() {
        DatastreamReferencedContent ds = new DatastreamReferencedContent();
        this.copy(ds);
        return ds;
    }

    private ExternalContentManager getExternalContentManager() throws Exception {
        if (s_ecm == null) {
            try {
                Server server = Server.getInstance(new File(Constants.FEDORA_HOME), false);
                s_ecm = (ExternalContentManager)((Object)server.getModule("org.fcrepo.server.storage.ExternalContentManager"));
            }
            catch (InitializationException e) {
                throw new Exception("Unable to get ExternalContentManager Module: " + e.getMessage(), e);
            }
        }
        return s_ecm;
    }

    @Override
    public InputStream getContentStream(Context context) throws StreamIOException {
        try {
            ContentManagerParams params = new ContentManagerParams(this.DSLocation);
            if (context != null) {
                params.setContext(context);
            }
            MIMETypedStream stream = this.getExternalContentManager().getExternalContent(params);
            this.DSSize = this.getContentLength(stream);
            return stream.getStream();
        }
        catch (Exception ex) {
            throw new StreamIOException("Error getting content stream", ex);
        }
    }

    public long getContentLength(MIMETypedStream stream) {
        long length = 0L;
        if (stream.header != null) {
            for (int i = 0; i < stream.header.length; ++i) {
                if (stream.header[i].name == null || stream.header[i].name.equalsIgnoreCase("") || !stream.header[i].name.equalsIgnoreCase("content-length")) continue;
                length = Long.parseLong(stream.header[i].value);
                break;
            }
        }
        return length;
    }
}

