/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fcrepo.server.Context;
import org.fcrepo.server.storage.types.Datastream;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DatastreamXMLMetadata
extends Datastream {
    public static final int TECHNICAL = 1;
    public static final int SOURCE = 2;
    public static final int RIGHTS = 3;
    public static final int DIGIPROV = 4;
    public static final int DESCRIPTIVE = 5;
    public byte[] xmlContent;
    public int DSMDClass = 0;
    private final String m_encoding;

    public DatastreamXMLMetadata() {
        this.m_encoding = "UTF-8";
    }

    public DatastreamXMLMetadata(String encoding) {
        this.m_encoding = encoding;
    }

    @Override
    public Datastream copy() {
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata(this.m_encoding);
        this.copy(ds);
        if (this.xmlContent != null) {
            ds.xmlContent = new byte[this.xmlContent.length];
            for (int i = 0; i < this.xmlContent.length; ++i) {
                ds.xmlContent[i] = this.xmlContent[i];
            }
        }
        ds.DSMDClass = this.DSMDClass;
        return ds;
    }

    @Override
    public InputStream getContentStream() {
        return new ByteArrayInputStream(this.xmlContent);
    }

    @Override
    public InputStream getContentStream(Context context) {
        return new ByteArrayInputStream(this.xmlContent);
    }

    @Override
    public InputStream getContentStreamForChecksum() {
        try {
            String line;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            OutputFormat fmt = new OutputFormat("XML", "UTF-8", false);
            fmt.setIndent(0);
            fmt.setLineWidth(0);
            fmt.setPreserveSpace(false);
            XMLSerializer ser = new XMLSerializer(outStream, fmt);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(this.xmlContent));
            ser.serialize(doc);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(outStream.toByteArray()), this.m_encoding));
            StringBuffer buf = new StringBuffer();
            while ((line = br.readLine()) != null) {
                line = line.trim();
                buf = buf.append(line);
            }
            String bufStr = buf.toString();
            return new ByteArrayInputStream(bufStr.getBytes(this.m_encoding));
        }
        catch (UnsupportedEncodingException e) {
            return this.getContentStream();
        }
        catch (IOException e) {
            return this.getContentStream();
        }
        catch (ParserConfigurationException e) {
            return this.getContentStream();
        }
        catch (SAXException e) {
            return this.getContentStream();
        }
    }

    public InputStream getContentStreamAsDocument() throws UnsupportedEncodingException {
        int i;
        String firstLine = "<?xml version=\"1.0\" encoding=\"" + this.m_encoding + "\" ?>\n";
        byte[] firstLineBytes = firstLine.getBytes(this.m_encoding);
        byte[] out = new byte[this.xmlContent.length + firstLineBytes.length];
        for (i = 0; i < firstLineBytes.length; ++i) {
            out[i] = firstLineBytes[i];
        }
        for (i = firstLineBytes.length; i < firstLineBytes.length + this.xmlContent.length; ++i) {
            out[i] = this.xmlContent[i - firstLineBytes.length];
        }
        return new ByteArrayInputStream(out);
    }
}

