/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.io.IOException;
import java.io.InputStream;
import org.fcrepo.server.storage.types.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIMETypedStream {
    private static final Logger logger = LoggerFactory.getLogger(MIMETypedStream.class);
    public String MIMEType;
    private InputStream stream;
    public Property[] header;
    private long size = -1L;
    private boolean gotStream = false;

    public MIMETypedStream(String MIMEType, InputStream stream, Property[] header) {
        this.MIMEType = MIMEType;
        this.header = header;
        this.setStream(stream);
    }

    public MIMETypedStream(String MIMEType, InputStream stream, Property[] header, long size) {
        this.MIMEType = MIMEType;
        this.header = header;
        this.size = size;
        this.setStream(stream);
    }

    public synchronized InputStream getStream() {
        this.gotStream = true;
        return this.stream;
    }

    public synchronized void setStream(InputStream stream) {
        this.gotStream = false;
        this.stream = stream;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException e) {
                logger.warn("Error closing stream", (Throwable)e);
            }
        }
    }

    public void finalize() {
        if (!this.gotStream) {
            this.close();
        }
    }

    public long getSize() {
        return this.size;
    }
}

