/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.rdf.SimpleLiteral;
import org.fcrepo.common.rdf.SimpleTriple;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;

public class RelationshipTuple
implements Constants {
    public final String subject;
    public final String predicate;
    public final String object;
    public final boolean isLiteral;
    public final URI datatype;
    public final String language;

    public RelationshipTuple(String subject, String predicate, String object, boolean isLiteral, URI datatype) {
        this(subject, predicate, object, isLiteral, datatype, null);
    }

    public RelationshipTuple(String subject, String predicate, String object, boolean isLiteral, URI datatype, String language) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.isLiteral = isLiteral;
        this.datatype = datatype;
        this.language = language;
    }

    public String getObjectPID() {
        if (this.object != null && !this.isLiteral && this.object.startsWith("info:fedora/")) {
            String PID2 = this.object.substring(12);
            return PID2;
        }
        return null;
    }

    public String getRelationship() {
        String prefixRel = RelationshipTuple.RELS_EXT.uri;
        if (this.predicate != null && this.predicate.startsWith(prefixRel)) {
            String rel = "rel:" + this.predicate.substring(prefixRel.length());
            return rel;
        }
        String prefixModel = RelationshipTuple.MODEL.uri;
        if (this.predicate != null && this.predicate.startsWith(prefixModel)) {
            String rel = "fedora-model:" + this.predicate.substring(prefixModel.length());
            return rel;
        }
        return this.predicate;
    }

    public String toString() {
        String retVal = "Sub: " + this.subject + "  Pred: " + this.predicate + "  Obj: [" + this.object + ", " + this.isLiteral + ", " + this.datatype + "]";
        return retVal;
    }

    public int hashCode() {
        return RelationshipTuple.hc(this.subject) + RelationshipTuple.hc(this.predicate) + RelationshipTuple.hc(this.object) + RelationshipTuple.hc(this.datatype);
    }

    public boolean equals(Object o) {
        if (o instanceof RelationshipTuple) {
            RelationshipTuple t = (RelationshipTuple)o;
            return RelationshipTuple.eq(this.subject, t.subject) && RelationshipTuple.eq(this.predicate, t.predicate) && RelationshipTuple.eq(this.object, t.object) && RelationshipTuple.eq(this.datatype, t.datatype) && this.isLiteral == t.isLiteral;
        }
        return false;
    }

    public Triple toTriple(Map<String, String> namespaces) throws URISyntaxException {
        return new SimpleTriple((SubjectNode)new SimpleURIReference(new URI(this.subject)), RelationshipTuple.makePredicateResourceFromRel(this.predicate, namespaces), RelationshipTuple.makeObjectFromURIandLiteral(this.object, this.isLiteral, this.datatype, this.language));
    }

    public static URI makePredicateFromRel(String relationship, Map<String, String> map) throws URISyntaxException {
        String predicate = relationship;
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (!predicate.startsWith(key + ":")) continue;
            predicate = predicate.replaceFirst(key + ":", map.get(key));
        }
        URI retVal = null;
        retVal = new URI(predicate);
        return retVal;
    }

    public static PredicateNode makePredicateResourceFromRel(String predicate, Map<String, String> map) throws URISyntaxException {
        URI predURI = RelationshipTuple.makePredicateFromRel(predicate, map);
        SimpleURIReference node = new SimpleURIReference(predURI);
        return node;
    }

    public static ObjectNode makeObjectFromURIandLiteral(String objURI, boolean isLiteral, URI literalType, String language) throws URISyntaxException {
        Object obj = null;
        obj = isLiteral ? (literalType != null ? new SimpleLiteral(objURI, literalType) : (language != null ? new SimpleLiteral(objURI, language) : new SimpleLiteral(objURI))) : new SimpleURIReference(new URI(objURI));
        return obj;
    }

    public static RelationshipTuple fromTriple(Triple triple) {
        String subject = triple.getSubject().toString();
        String predicate = triple.getPredicate().toString();
        ObjectNode objectNode = triple.getObject();
        if (objectNode instanceof Literal) {
            return RelationshipTuple.getLiteral(subject, predicate, (Literal)objectNode);
        }
        return new RelationshipTuple(subject, predicate, objectNode.toString(), false, null, null);
    }

    private static RelationshipTuple getLiteral(String subject, String predicate, Literal literal) {
        return new RelationshipTuple(subject, predicate, literal.getLexicalForm(), true, literal.getDatatypeURI(), literal.getLanguage());
    }

    private static boolean eq(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return b != null && a.equals(b);
    }

    private static int hc(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

