/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class TupleArrayTripleIterator
extends TripleIterator {
    private static final HashMap<String, String> DEFAULT_NS = new HashMap(2);
    int size = 0;
    int index = 0;
    ArrayList<RelationshipTuple> m_TupleArray = null;
    Map<String, String> m_map = null;

    public TupleArrayTripleIterator(ArrayList<RelationshipTuple> array, Map<String, String> map) {
        this.m_TupleArray = array;
        this.size = array.size();
        this.m_map = map;
    }

    public TupleArrayTripleIterator(ArrayList<RelationshipTuple> array) {
        this.m_TupleArray = array;
        this.size = array.size();
        this.m_map = DEFAULT_NS;
    }

    public boolean hasNext() throws TrippiException {
        return this.index < this.size;
    }

    public Triple next() throws TrippiException {
        RelationshipTuple tuple = this.m_TupleArray.get(this.index++);
        try {
            return tuple.toTriple(this.m_map);
        }
        catch (URISyntaxException e) {
            throw new TrippiException("Invalid URI in Triple", (Throwable)e);
        }
    }

    public void close() throws TrippiException {
    }

    static {
        DEFAULT_NS.put("rel", "info:fedora/fedora-system:def/relations-external#");
        DEFAULT_NS.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }
}

