/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerInitializationException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLDatastreamProcessor {
    private static final Logger logger = LoggerFactory.getLogger(XMLDatastreamProcessor.class);
    protected Datastream m_ds;
    private static String DC_DEFAULT_CONTROLGROUP;
    private static String RELS_DEFAULT_CONTROLGROUP;
    private static boolean initialized;
    protected DS_TYPE m_dsType;

    private XMLDatastreamProcessor() {
    }

    public XMLDatastreamProcessor(String dsId) {
        XMLDatastreamProcessor.init();
        String controlGroup = null;
        if (dsId.equals("DC")) {
            controlGroup = DC_DEFAULT_CONTROLGROUP;
        } else if (dsId.equals("RELS-EXT") || dsId.equals("RELS-INT")) {
            controlGroup = RELS_DEFAULT_CONTROLGROUP;
        } else {
            throw new RuntimeException("XML Datastream Processor only handles DC and RELS datastreams.  Datastream ID supplied was " + dsId);
        }
        if (controlGroup.equals("X")) {
            this.m_ds = new DatastreamXMLMetadata();
            this.m_dsType = DS_TYPE.INLINE_XML;
        } else if (controlGroup.equals("M")) {
            this.m_ds = new DatastreamManagedContent();
            this.m_dsType = DS_TYPE.MANAGED;
        }
        this.m_ds.DSControlGrp = controlGroup;
        this.m_ds.DatastreamID = dsId;
    }

    public XMLDatastreamProcessor(Datastream ds) {
        if (ds instanceof DatastreamXMLMetadata) {
            this.m_ds = ds;
            this.m_dsType = DS_TYPE.INLINE_XML;
        } else if (ds instanceof DatastreamManagedContent) {
            this.m_ds = ds;
            this.m_dsType = DS_TYPE.MANAGED;
        } else {
            throw new RuntimeException("XML datastreams must be of type Managed or Inline, but type was " + ds.getClass().getName());
        }
    }

    private static void init() {
        if (!initialized) {
            try {
                Server server = Server.getInstance(new File(Constants.FEDORA_HOME), false);
                Module module = server.getModule("org.fcrepo.server.storage.DOManager");
                DC_DEFAULT_CONTROLGROUP = module.getParameter("defaultDCControlGroup");
                RELS_DEFAULT_CONTROLGROUP = module.getParameter("defaultRELSControlGroup");
            }
            catch (ServerInitializationException e) {
                logger.error("Unable to get server", (Throwable)e);
            }
            catch (ModuleInitializationException e) {
                logger.error("Unable to get DOManager module", (Throwable)e);
            }
            if (DC_DEFAULT_CONTROLGROUP == null) {
                logger.error("Unable to determine default controlgroup for DC datastreams, using X");
                DC_DEFAULT_CONTROLGROUP = "X";
            }
            if (RELS_DEFAULT_CONTROLGROUP == null) {
                logger.error("Unable to determine default controlgroup for RELS datastreams, using X");
                RELS_DEFAULT_CONTROLGROUP = "X";
            }
            initialized = true;
        }
    }

    public XMLDatastreamProcessor newVersion() throws ServerInitializationException, ModuleInitializationException {
        Datastream ds;
        if (this.m_dsType == DS_TYPE.INLINE_XML) {
            ds = new DatastreamXMLMetadata();
            ds.DSControlGrp = "X";
        } else if (this.m_dsType == DS_TYPE.MANAGED) {
            ds = new DatastreamManagedContent();
            ds.DSControlGrp = "M";
        } else {
            throw new RuntimeException("XML datastreams must be of type Managed or Inline");
        }
        return new XMLDatastreamProcessor(ds);
    }

    public byte[] getXMLContent() {
        return this.getXMLContent(null);
    }

    public byte[] getXMLContent(Context ctx) {
        if (this.m_dsType == DS_TYPE.INLINE_XML) {
            return ((DatastreamXMLMetadata)this.m_ds).xmlContent;
        }
        if (this.m_dsType == DS_TYPE.MANAGED) {
            try {
                if (ctx == null) {
                    return IOUtils.toByteArray((InputStream)this.m_ds.getContentStream());
                }
                return IOUtils.toByteArray((InputStream)this.m_ds.getContentStream(ctx));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read managed stream contents", e);
            }
            catch (StreamIOException e) {
                throw new RuntimeException("Unable to read managed stream contents", e);
            }
        }
        throw new RuntimeException("XML datastreams must be of type Managed or Inline");
    }

    public Datastream getDatastream() {
        return this.m_ds;
    }

    public void setXMLContent(byte[] xmlContent) {
        if (this.m_dsType == DS_TYPE.INLINE_XML) {
            ((DatastreamXMLMetadata)this.m_ds).xmlContent = xmlContent;
        } else if (this.m_dsType == DS_TYPE.MANAGED) {
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlContent);
            MIMETypedStream s = new MIMETypedStream("text/xml", bais, null, xmlContent.length);
            try {
                ((DatastreamManagedContent)this.m_ds).putContentStream(s);
            }
            catch (StreamIOException e) {
                throw new RuntimeException("Unable to update managed datastream contents", e);
            }
        } else {
            throw new RuntimeException("XML datastreams must be of type Managed or Inline");
        }
    }

    public void setDSMDClass(int DSMDClass) {
        if (this.m_dsType == DS_TYPE.INLINE_XML) {
            ((DatastreamXMLMetadata)this.m_ds).DSMDClass = DSMDClass;
        } else if (this.m_dsType == DS_TYPE.MANAGED) {
            ((DatastreamManagedContent)this.m_ds).DSMDClass = DSMDClass;
        } else {
            throw new RuntimeException("XML datastreams must be of type Managed or Inline");
        }
    }

    public int getDSMDClass() {
        if (this.m_dsType == DS_TYPE.INLINE_XML) {
            return ((DatastreamXMLMetadata)this.m_ds).DSMDClass;
        }
        if (this.m_dsType == DS_TYPE.MANAGED) {
            return ((DatastreamManagedContent)this.m_ds).DSMDClass;
        }
        throw new RuntimeException("XML datastreams must be of type Managed or Inline");
    }

    static {
        initialized = false;
    }

    private static enum DS_TYPE {
        INLINE_XML,
        MANAGED;

    }
}

