/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.upload;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.UploadServlet;
import org.fcrepo.server.rest.BaseRestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class UploadResource
extends BaseRestResource {
    private static final Logger logger = LoggerFactory.getLogger(UploadServlet.class);

    public UploadResource(Server server) {
        super(server);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response upload(MultipartBody multipart) {
        String uploaded;
        Attachment file = multipart.getAttachment("file");
        if (file == null) {
            return Response.status((int)400).entity((Object)"Missing file part").type("text/plain").build();
        }
        InputStream fileStream = (InputStream)file.getObject(InputStream.class);
        try {
            uploaded = this.m_management.putTempStream(this.getContext(), fileStream);
            logger.debug("File uploaded: ", (Object)uploaded);
        }
        catch (ServerException e) {
            logger.error(e.toString());
            return this.handleException(e, false);
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)uploaded).type("text/plain").build();
    }
}

