/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.fcrepo.common.FaultException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.authorization.AuthzDeniedException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.errors.authorization.AuthzPermittedException;

public abstract class CXFUtility {
    public static String SOAP_FAULT_CODE_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";
    public static String SOAP_ULTIMATE_RECEIVER = "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver";

    public static void throwFault(ServerException se) throws SoapFault {
        throw CXFUtility.getFault(se);
    }

    public static SoapFault getFault(ServerException se) {
        String[] details = se.getDetails();
        String detailString = "";
        if (details.length > 0) {
            StringBuffer buf = new StringBuffer();
            for (String element : details) {
                buf.append("<detail>");
                buf.append(se.getClass().getName());
                buf.append(": ");
                buf.append(element);
                buf.append("</detail>\n");
            }
            detailString = buf.toString();
        }
        SoapFault fault = new SoapFault(detailString, (Throwable)se, SoapFault.FAULT_CODE_CLIENT);
        return fault;
    }

    public static SoapFault getFault(AuthzException e) {
        String reason = "";
        if (e instanceof AuthzOperationalException) {
            reason = "Authorization Failed";
        } else if (e instanceof AuthzDeniedException) {
            reason = "Authorization Denied";
        } else if (e instanceof AuthzPermittedException) {
            reason = "Authorization Permitted";
        }
        SoapFault fault = new SoapFault(reason, (Throwable)e, new QName("Authz"));
        return fault;
    }

    public static SoapFault getFault(Throwable th) {
        if (th instanceof ServerException) {
            if (th instanceof AuthzException) {
                return CXFUtility.getFault((AuthzException)th);
            }
            return CXFUtility.getFault((ServerException)th);
        }
        if (th instanceof FaultException) {
            return new SoapFault(th.toString(), th, SoapFault.FAULT_CODE_CLIENT);
        }
        return new SoapFault(th.toString(), (Throwable)new Exception("Uncaught exception from Fedora Server", th), SoapFault.FAULT_CODE_CLIENT);
    }
}

