/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuntimeWSDL {
    private Document _wsdlDoc;

    public RuntimeWSDL(File schemaFile, File sourceWSDL, String endpoint) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xsdDoc = builder.parse(schemaFile);
            this._wsdlDoc = builder.parse(sourceWSDL);
            Element typesElement = this.getTopElement("types");
            RuntimeWSDL.removeChildren(typesElement);
            Node xsdNode = this._wsdlDoc.importNode(xsdDoc.getDocumentElement(), true);
            typesElement.appendChild(xsdNode);
            Element serviceElement = this.getTopElement("service");
            String serviceName = serviceElement.getAttributeNS(null, "name");
            if (serviceName == null) {
                throw new IOException("WSDL missing required attribute of service element: name");
            }
            NodeList ports = serviceElement.getElementsByTagNameNS("*", "port");
            while (ports.getLength() > 1) {
                serviceElement.removeChild(ports.item(0));
            }
            if (ports.getLength() == 0) {
                throw new IOException("WSDL missing required element: port");
            }
            Element port = (Element)ports.item(0);
            int i = endpoint.indexOf(":");
            String schemePart = "";
            if (i != -1) {
                schemePart = "-" + endpoint.substring(0, i).toUpperCase();
            }
            port.setAttribute("name", serviceName + schemePart + "-Port");
            Element address = (Element)port.getElementsByTagNameNS("*", "address").item(0);
            if (address == null) {
                throw new IOException("WSDL missing required element: address");
            }
            address.setAttribute("location", endpoint);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Error getting RuntimeWSDL", e);
        }
    }

    private Element getTopElement(String name) throws IOException {
        Element element = (Element)this._wsdlDoc.getDocumentElement().getElementsByTagNameNS("*", name).item(0);
        if (element != null) {
            return element;
        }
        throw new IOException("WSDL missing required element: " + name);
    }

    private static final void removeChildren(Element element) {
        Node firstChild = element.getFirstChild();
        while (firstChild != null) {
            element.removeChild(firstChild);
            firstChild = element.getFirstChild();
        }
    }

    public void serialize(Writer out) throws IOException {
        OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
        fmt.setIndent(2);
        fmt.setLineWidth(80);
        fmt.setPreserveSpace(false);
        fmt.setOmitXMLDeclaration(false);
        fmt.setOmitDocumentType(true);
        XMLSerializer ser = new XMLSerializer(out, fmt);
        ser.serialize(this._wsdlDoc);
    }

    public static void main(String[] args) throws Exception {
        PrintWriter out = new PrintWriter(System.out);
        new RuntimeWSDL(new File(args[0]), new File(args[1]), args[2]).serialize(out);
        out.flush();
    }
}

