/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.errors.InconsistentTableSpecException;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.utilities.SQLUtilityImpl;
import org.fcrepo.server.utilities.TableCreatingConnection;
import org.fcrepo.server.utilities.TableSpec;

public abstract class SQLUtility {
    private static SQLUtility instance = new SQLUtilityImpl();

    public static ConnectionPool getConnectionPool(ServerConfiguration fcfg) throws SQLException {
        ModuleConfiguration mcfg = fcfg.getModuleConfiguration("org.fcrepo.server.storage.ConnectionPoolManager");
        String defaultPool = mcfg.getParameter("defaultPoolName", Parameter.class).getValue();
        DatastoreConfiguration dcfg = fcfg.getDatastoreConfiguration(defaultPool);
        return SQLUtility.getConnectionPool(dcfg);
    }

    public static ConnectionPool getConnectionPool(DatastoreConfiguration cpDC) throws SQLException {
        return instance.i_getConnectionPool(cpDC);
    }

    public static void replaceInto(Connection conn, String tableName, String[] columns, String[] values, String uniqueColumn) throws SQLException {
        SQLUtility.replaceInto(conn, tableName, columns, values, uniqueColumn, null);
    }

    public static void replaceInto(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
        instance.i_replaceInto(conn, table, columns, values, uniqueColumn, numeric);
    }

    public static boolean updateRow(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
        return instance.i_updateRow(conn, table, columns, values, uniqueColumn, numeric);
    }

    public static void addRow(Connection conn, String table, String[] columns, String[] values, boolean[] numeric) throws SQLException {
        instance.i_addRow(conn, table, columns, values, numeric);
    }

    public static String getLongString(ResultSet rs, int pos) throws SQLException {
        return instance.i_getLongString(rs, pos);
    }

    public static void createNonExistingTables(ConnectionPool cPool, InputStream dbSpec) throws IOException, InconsistentTableSpecException, SQLException {
        instance.i_createNonExistingTables(cPool, dbSpec);
    }

    protected abstract ConnectionPool i_getConnectionPool(DatastoreConfiguration var1) throws SQLException;

    protected abstract void i_replaceInto(Connection var1, String var2, String[] var3, String[] var4, String var5, boolean[] var6) throws SQLException;

    protected abstract boolean i_updateRow(Connection var1, String var2, String[] var3, String[] var4, String var5, boolean[] var6) throws SQLException;

    protected abstract void i_addRow(Connection var1, String var2, String[] var3, String[] var4, boolean[] var5) throws SQLException;

    protected abstract void i_createNonExistingTables(ConnectionPool var1, InputStream var2) throws IOException, InconsistentTableSpecException, SQLException;

    protected abstract List<TableSpec> i_getNonExistingTables(Connection var1, List<TableSpec> var2) throws SQLException;

    protected abstract void i_createTables(TableCreatingConnection var1, List<TableSpec> var2) throws SQLException;

    protected abstract String i_getLongString(ResultSet var1, int var2) throws SQLException;
}

