/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.errors.InconsistentTableSpecException;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.utilities.DDLConverter;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.server.utilities.TableCreatingConnection;
import org.fcrepo.server.utilities.TableSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLUtilityImpl
extends SQLUtility {
    private static final Logger logger = LoggerFactory.getLogger(SQLUtilityImpl.class);

    SQLUtilityImpl() {
    }

    @Override
    protected ConnectionPool i_getConnectionPool(DatastoreConfiguration cpDC) throws SQLException {
        String cpUsername = cpDC.getParameter("dbUsername", Parameter.class).getValue();
        String cpPassword = cpDC.getParameter("dbPassword", Parameter.class).getValue();
        String cpURL = cpDC.getParameter("jdbcURL", Parameter.class).getValue();
        String cpDriver = cpDC.getParameter("jdbcDriverClass", Parameter.class).getValue();
        String cpDDLConverter = cpDC.getParameter("ddlConverter", Parameter.class).getValue();
        int cpMaxActive = Integer.parseInt(cpDC.getParameter("maxActive", Parameter.class).getValue());
        int cpMaxIdle = Integer.parseInt(cpDC.getParameter("maxIdle", Parameter.class).getValue());
        long cpMaxWait = Long.parseLong(cpDC.getParameter("maxWait", Parameter.class).getValue());
        int cpMinIdle = Integer.parseInt(cpDC.getParameter("minIdle", Parameter.class).getValue());
        long cpMinEvictableIdleTimeMillis = Long.parseLong(cpDC.getParameter("minEvictableIdleTimeMillis", Parameter.class).getValue());
        int cpNumTestsPerEvictionRun = Integer.parseInt(cpDC.getParameter("numTestsPerEvictionRun", Parameter.class).getValue());
        long cpTimeBetweenEvictionRunsMillis = Long.parseLong(cpDC.getParameter("timeBetweenEvictionRunsMillis", Parameter.class).getValue());
        String cpValidationQuery = null;
        if (cpDC.getParameter("validationQuery") != null) {
            cpValidationQuery = cpDC.getParameter("validationQuery", Parameter.class).getValue();
        }
        boolean cpTestOnBorrow = Boolean.parseBoolean(cpDC.getParameter("testOnBorrow", Parameter.class).getValue());
        boolean cpTestOnReturn = Boolean.parseBoolean(cpDC.getParameter("testOnReturn", Parameter.class).getValue());
        boolean cpTestWhileIdle = Boolean.parseBoolean(cpDC.getParameter("testWhileIdle", Parameter.class).getValue());
        byte cpWhenExhaustedAction = Byte.parseByte(cpDC.getParameter("whenExhaustedAction", Parameter.class).getValue());
        DDLConverter ddlConverter = null;
        if (cpDDLConverter != null) {
            try {
                ddlConverter = (DDLConverter)Class.forName(cpDDLConverter).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new ConnectionPool(cpDriver, cpURL, cpUsername, cpPassword, ddlConverter, cpMaxActive, cpMaxIdle, cpMaxWait, cpMinIdle, cpMinEvictableIdleTimeMillis, cpNumTestsPerEvictionRun, cpTimeBetweenEvictionRunsMillis, cpValidationQuery, cpTestOnBorrow, cpTestOnReturn, cpTestWhileIdle, cpWhenExhaustedAction);
    }

    @Override
    protected void i_replaceInto(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
        if (!this.i_updateRow(conn, table, columns, values, uniqueColumn, numeric)) {
            this.i_addRow(conn, table, columns, values, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean i_updateRow(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + table + " SET ");
        boolean needComma = false;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].equals(uniqueColumn)) continue;
            if (needComma) {
                sql.append(", ");
            } else {
                needComma = true;
            }
            sql.append(columns[i] + " = ");
            if (values[i] == null) {
                sql.append("NULL");
                continue;
            }
            sql.append("?");
        }
        sql.append(" WHERE " + uniqueColumn + " = ?");
        logger.debug("About to execute: " + sql.toString());
        PreparedStatement stmt = conn.prepareStatement(sql.toString());
        try {
            int varIndex = 0;
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].equals(uniqueColumn) || values[i] == null) continue;
                ++varIndex;
                if (numeric != null && numeric[i]) {
                    this.setNumeric(stmt, varIndex, columns[i], values[i]);
                    continue;
                }
                stmt.setString(varIndex, values[i]);
            }
            stmt.setString(++varIndex, this.getSelector(columns, values, uniqueColumn));
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void i_addRow(Connection conn, String table, String[] columns, String[] values, boolean[] numeric) throws SQLException {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + table + " (");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(columns[i]);
        }
        sql.append(") VALUES (");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            if (values[i] == null) {
                sql.append("NULL");
                continue;
            }
            sql.append("?");
        }
        sql.append(")");
        logger.debug("About to execute: " + sql.toString());
        PreparedStatement stmt = conn.prepareStatement(sql.toString());
        try {
            int varIndex = 0;
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (values[i2] == null) continue;
                ++varIndex;
                if (numeric != null && numeric[i2]) {
                    this.setNumeric(stmt, varIndex, columns[i2], values[i2]);
                    continue;
                }
                stmt.setString(varIndex, values[i2]);
            }
            stmt.executeUpdate();
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void i_createNonExistingTables(ConnectionPool cPool, InputStream dbSpec) throws IOException, InconsistentTableSpecException, SQLException {
        List<TableSpec> nonExisting = null;
        Connection conn = null;
        try {
            conn = cPool.getReadOnlyConnection();
            nonExisting = this.i_getNonExistingTables(conn, TableSpec.getTableSpecs(dbSpec));
        }
        finally {
            if (conn != null) {
                cPool.free(conn);
            }
        }
        if (nonExisting.size() > 0) {
            TableCreatingConnection tcConn = null;
            try {
                tcConn = cPool.getTableCreatingConnection();
                if (tcConn == null) {
                    throw new SQLException("Unable to construct CREATE TABLE statement(s) because there is no DDLConverter registered for this connection type.");
                }
                this.i_createTables(tcConn, nonExisting);
            }
            finally {
                if (tcConn != null) {
                    cPool.free(tcConn);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<TableSpec> i_getNonExistingTables(Connection conn, List<TableSpec> tSpecs) throws SQLException {
        ArrayList<TableSpec> nonExisting = new ArrayList<TableSpec>();
        DatabaseMetaData dbMeta = conn.getMetaData();
        Iterator<TableSpec> tSpecIter = tSpecs.iterator();
        ResultSet r = null;
        try {
            r = dbMeta.getTables(null, null, "%", null);
            HashSet<String> existingTableSet = new HashSet<String>();
            while (r.next()) {
                existingTableSet.add(r.getString("TABLE_NAME").toLowerCase());
            }
            r.close();
            r = null;
            while (tSpecIter.hasNext()) {
                TableSpec spec = tSpecIter.next();
                if (existingTableSet.contains(spec.getName().toLowerCase())) continue;
                nonExisting.add(spec);
            }
            return nonExisting;
        }
        catch (SQLException sqle) {
            throw new SQLException(sqle.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                r = null;
            }
            catch (Throwable throwable) {
                r = null;
                throw throwable;
            }
        }
    }

    @Override
    protected void i_createTables(TableCreatingConnection tcConn, List<TableSpec> tSpecs) throws SQLException {
        for (TableSpec spec : tSpecs) {
            if (logger.isInfoEnabled()) {
                StringBuffer sqlCmds = new StringBuffer();
                Iterator<String> iter = tcConn.getDDLConverter().getDDL(spec).iterator();
                while (iter.hasNext()) {
                    sqlCmds.append("\n");
                    sqlCmds.append(iter.next());
                    sqlCmds.append(";");
                }
                logger.info("Creating new table '" + spec.getName() + "' with command(s): " + sqlCmds.toString());
            }
            tcConn.createTable(spec);
        }
    }

    void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warn("Unable to close statement", (Throwable)e);
            }
        }
    }

    @Override
    protected String i_getLongString(ResultSet rs, int pos) throws SQLException {
        String s = rs.getString(pos);
        if (s != null) {
            return s;
        }
        try {
            Clob c = rs.getClob(pos);
            return c.getSubString(1L, (int)c.length());
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    private void setNumeric(PreparedStatement stmt, int varIndex, String columnName, String value) throws SQLException {
        try {
            stmt.setInt(varIndex, Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            try {
                stmt.setLong(varIndex, Long.parseLong(value));
            }
            catch (NumberFormatException e2) {
                throw new SQLException("Value specified for " + columnName + ", '" + value + "' was" + " specified as numeric, but is not");
            }
        }
    }

    private String getSelector(String[] columns, String[] values, String uniqueColumn) throws SQLException {
        String selector = null;
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equals(uniqueColumn)) continue;
            selector = values[i];
        }
        if (selector != null) {
            return selector;
        }
        throw new SQLException("Unique column does not exist in given column array");
    }
}

