/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.common.http.WebClient;
import org.fcrepo.common.http.WebClientConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.config.ServerConfigurationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtility {
    private static final Logger logger = LoggerFactory.getLogger(ServerUtility.class);
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String FEDORA_SERVER_HOST = "fedoraServerHost";
    public static final String FEDORA_SERVER_PORT = "fedoraServerPort";
    public static final String FEDORA_SERVER_CONTEXT = "fedoraAppServerContext";
    public static final String FEDORA_REDIRECT_PORT = "fedoraRedirectPort";
    private static ServerConfiguration CONFIG;

    public static boolean pingServer(String protocol, String user, String pass) {
        try {
            ServerUtility.getServerResponse(protocol, user, pass, "/describe");
            return true;
        }
        catch (Exception e) {
            logger.debug("Assuming the server isn't running because describe request failed", (Throwable)e);
            return false;
        }
    }

    public static String getBaseURL(String protocol) {
        String port;
        if (protocol.equals(HTTP)) {
            port = CONFIG.getParameter(FEDORA_SERVER_PORT, Parameter.class).getValue();
        } else if (protocol.equals(HTTPS)) {
            port = CONFIG.getParameter(FEDORA_REDIRECT_PORT, Parameter.class).getValue();
        } else {
            throw new RuntimeException("Unrecogonized protocol: " + protocol);
        }
        return protocol + "://" + CONFIG.getParameter(FEDORA_SERVER_HOST, Parameter.class).getValue() + ":" + port + "/" + CONFIG.getParameter(FEDORA_SERVER_CONTEXT, Parameter.class).getValue();
    }

    public static void reloadPolicies(String protocol, String user, String pass) throws IOException {
        ServerUtility.getServerResponse(protocol, user, pass, "/management/control?action=reloadPolicies");
    }

    private static String getServerResponse(String protocol, String user, String pass, String path) throws IOException {
        String url = ServerUtility.getBaseURL(protocol) + path;
        logger.info("Getting URL: " + url);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, pass);
        WebClientConfiguration webconfig = new WebClientConfiguration();
        ServerUtility.initWebClientConfig(webconfig);
        return new WebClient(webconfig).getResponseAsString(url, true, creds);
    }

    private static InputStream getServerResponseAsStream(String protocol, String user, String pass, String path) throws IOException {
        String url = ServerUtility.getBaseURL(protocol) + path;
        logger.info("Getting URL: " + url);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, pass);
        return new WebClient().get(url, true, creds);
    }

    public static boolean isURLFedoraServer(String url) {
        URI uri = URI.create(url);
        String scheme = uri.getScheme();
        if (!scheme.equals(HTTP) && !scheme.equals(HTTPS)) {
            return false;
        }
        String fHost = CONFIG.getParameter(FEDORA_SERVER_HOST, Parameter.class).getValue();
        String host = uri.getHost();
        if (!host.equals(fHost) && !host.equals("localhost")) {
            return false;
        }
        String path = uri.getPath();
        String fedoraContext = CONFIG.getParameter(FEDORA_SERVER_CONTEXT, Parameter.class).getValue();
        if (!path.startsWith("/" + fedoraContext + "/")) {
            return false;
        }
        String httpPort = CONFIG.getParameter(FEDORA_SERVER_PORT, Parameter.class).getValue();
        String httpsPort = CONFIG.getParameter(FEDORA_REDIRECT_PORT, Parameter.class).getValue();
        if (uri.getPort() == -1) {
            if (scheme.equals(HTTP)) {
                return httpPort.equals("80");
            }
            return httpsPort.equals("443");
        }
        String port = "" + uri.getPort();
        if (scheme.equals(HTTP)) {
            return port.equals(httpPort);
        }
        return port.equals(httpsPort);
    }

    public static InputStream modifyDatastreamControlGroup(String protocol, String user, String pass, String pidspec, String datastreamspec, String controlGroup, boolean addXMLHeader, boolean reformat, boolean setMIMETypeCharset) throws IOException {
        String path = "/management/control?action=modifyDatastreamControlGroup&pid=" + pidspec + "&dsID=" + datastreamspec + "&controlGroup=" + controlGroup + "&addXMLHeader=" + addXMLHeader + "&reformat=" + reformat + "&setMIMETypeCharset=" + setMIMETypeCharset;
        return ServerUtility.getServerResponseAsStream(protocol, user, pass, path);
    }

    private static void initWebClientConfig(WebClientConfiguration wconf) {
        if (CONFIG.getParameter("httpClientTimeoutSecs") != null) {
            wconf.setTimeoutSecs(Integer.parseInt(CONFIG.getParameter("httpClientTimeoutSecs")));
        }
        if (CONFIG.getParameter("httpClientSocketTimeoutSecs") != null) {
            wconf.setSockTimeoutSecs(Integer.parseInt(CONFIG.getParameter("httpClientSocketTimeoutSecs")));
        }
        if (CONFIG.getParameter("httpClientMaxConnectionsPerHost") != null) {
            wconf.setMaxConnPerHost(Integer.parseInt(CONFIG.getParameter("httpClientMaxConnectionsPerHost")));
        }
        if (CONFIG.getParameter("httpClientMaxTotalConnections") != null) {
            wconf.setMaxTotalConn(Integer.parseInt(CONFIG.getParameter("httpClientMaxTotalConnections")));
        }
        if (CONFIG.getParameter("httpClientFollowRedirects") != null) {
            wconf.setFollowRedirects(Boolean.parseBoolean(CONFIG.getParameter("httpClientFollowRedirects")));
        }
        if (CONFIG.getParameter("httpClientMaxFollowRedirects") != null) {
            wconf.setMaxRedirects(Integer.parseInt(CONFIG.getParameter("httpClientMaxFollowRedirects")));
        }
        if (CONFIG.getParameter("httpClientUserAgent") != null) {
            wconf.setUserAgent(CONFIG.getParameter("httpClientUserAgent"));
        }
    }

    public static void main(String[] args) {
        String method;
        if (args.length < 1) {
            System.out.println("Parameters:  method arg1 arg2 arg3 etc");
            System.out.println("");
            System.out.println("Methods:");
            System.out.println("    reloadpolicies");
            System.out.println("    migratedatastreamcontrolgroup");
            System.exit(0);
        }
        if ((method = args[0].toLowerCase()).equals("reloadpolicies")) {
            if (args.length == 4) {
                try {
                    ServerUtility.reloadPolicies(args[1], args[2], args[3]);
                    System.out.println("SUCCESS: Policies have been reloaded");
                    System.exit(0);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    System.err.println("ERROR: Reloading policies failed; see above");
                    System.exit(1);
                }
            } else {
                System.err.println("ERROR: Three arguments required: http|https username password");
                System.exit(1);
            }
        } else if (method.equals("migratedatastreamcontrolgroup")) {
            if (args.length > 10) {
                System.err.println("ERROR: too many arguments provided");
                System.exit(1);
            }
            if (args.length < 7) {
                System.err.println("ERROR: insufficient arguments provided.  Arguments are: ");
                System.err.println("    protocol [http|https]");
                System.err.println("    user");
                System.err.println("    password");
                System.err.println("    pid - either");
                System.err.println("        a single pid, eg demo:object");
                System.err.println("        list of pids separated by commas, eg demo:object1,demo:object2");
                System.err.println("        name of file containing pids, eg file:///path/to/file");
                System.err.println("    dsid - either");
                System.err.println("        a single datastream id, eg DC");
                System.err.println("        list of ids separated by commas, eg DC,RELS-EXT");
                System.err.println("    controlGroup - target control group (note only M is implemented)");
                System.err.println("    addXMLHeader - add an XML header to the datastream [true|false, default false]");
                System.err.println("    reformat - reformat the XML [true|false, default false]");
                System.err.println("    setMIMETypeCharset - add charset=UTF-8 to the MIMEType [true|false, default false]");
                System.exit(1);
            }
            try {
                boolean addXMLHeader = ServerUtility.getArgBoolean(args, 7, false);
                boolean reformat = ServerUtility.getArgBoolean(args, 8, false);
                boolean setMIMETypeCharset = ServerUtility.getArgBoolean(args, 9, false);
                InputStream is = ServerUtility.modifyDatastreamControlGroup(args[1], args[2], args[3], args[4], args[5], args[6], addXMLHeader, reformat, setMIMETypeCharset);
                IOUtils.copy((InputStream)is, (OutputStream)System.out);
                is.close();
                System.out.println("SUCCESS: Datastreams modified");
                System.exit(0);
            }
            catch (Throwable th) {
                th.printStackTrace();
                System.err.println("ERROR: migrating datastream control group failed; see above");
                System.exit(1);
            }
        } else {
            System.err.println("ERROR: unrecognised method " + method);
            System.exit(1);
        }
    }

    private static boolean getArgBoolean(String[] args, int position, boolean defaultValue) {
        if (args.length > position) {
            String lowerArg = args[position].toLowerCase();
            if (lowerArg.equals("true") || lowerArg.equals("yes")) {
                return true;
            }
            if (lowerArg.equals("false") || lowerArg.equals("no")) {
                return false;
            }
            throw new IllegalArgumentException(args[position] + " not a valid value.  Specify true or false");
        }
        return defaultValue;
    }

    static {
        String fedoraHome = Constants.FEDORA_HOME;
        if (fedoraHome == null) {
            logger.warn("FEDORA_HOME not set; unable to initialize");
        } else {
            File fcfgFile = new File(fedoraHome, "server/config/fedora.fcfg");
            try {
                CONFIG = new ServerConfigurationParser(new FileInputStream(fcfgFile)).parse();
            }
            catch (IOException e) {
                logger.warn("Unable to read server configuration from " + fcfgFile.getPath(), (Throwable)e);
            }
        }
    }
}

