/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public final class ServerUtilitySerializer {
    PrintWriter m_writer = null;
    private String m_curpid;
    private String m_curdsID;
    private int m_objectCount = 0;
    private int m_datastreamCount = 0;
    private int m_datastreamCountThisObject = 0;
    private static final int INDENT = 4;

    private ServerUtilitySerializer() {
    }

    public ServerUtilitySerializer(PrintWriter pw) throws IOException {
        this.m_writer = new PrintWriter(pw);
        this.start();
    }

    private void indent(int level) throws IOException {
        this.m_writer.write(new String(new char[level * 4]).replace("\u0000", " "));
    }

    private void start() throws IOException {
        this.m_writer.println("Updating managed content datastreams");
    }

    public void finish() throws IOException {
        this.m_writer.println("Finished updating managed content datastreams");
        this.m_writer.println("Updated " + this.m_objectCount + " objects and " + this.m_datastreamCount + " datastreams");
    }

    public void startObject(String pid) throws IOException {
        this.m_curpid = pid;
        this.indent(1);
        this.m_writer.println("Updating object " + pid);
    }

    public void endObject() throws IOException {
        this.indent(1);
        this.m_writer.println("Finished updating object " + this.m_curpid);
    }

    public void startDatastream(String dsID) throws IOException {
        this.m_datastreamCountThisObject = 0;
        this.m_curdsID = dsID;
        this.indent(2);
        this.m_writer.println("Updating datastream " + dsID);
    }

    public void endDatastream() throws IOException {
        this.m_datastreamCount += this.m_datastreamCountThisObject;
        if (this.m_datastreamCountThisObject > 0) {
            ++this.m_objectCount;
        }
        this.indent(2);
        this.m_writer.println("Finished updating datastream" + this.m_curdsID);
    }

    public void writeVersions(Date[] versions) throws IOException {
        this.indent(3);
        if (versions == null) {
            this.m_writer.println("Datastream " + this.m_curdsID + " not found in this object");
            this.m_datastreamCountThisObject = 0;
        } else {
            if (versions.length == 0) {
                this.m_writer.println("Datastream already has desired ControlGroup)");
            } else {
                for (Date version : versions) {
                    this.indent(4);
                    this.m_writer.println("Updated version " + version.toString());
                }
            }
            this.m_datastreamCountThisObject = versions.length;
        }
    }
}

