/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.errors.InvalidOperatorException;
import org.fcrepo.server.errors.QueryParseException;
import org.fcrepo.server.search.Condition;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.ObjectFields;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.types.gen.ArrayOfString;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.types.gen.DatastreamControlGroup;
import org.fcrepo.server.types.gen.DatastreamDef;
import org.fcrepo.server.types.gen.DatastreamProblem;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.server.types.gen.GetDissemination;
import org.fcrepo.server.types.gen.ListSession;
import org.fcrepo.server.types.gen.MIMETypedStream;
import org.fcrepo.server.types.gen.MethodParmDef;
import org.fcrepo.server.types.gen.ObjectFactory;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.server.types.gen.ObjectProfile;
import org.fcrepo.server.types.gen.Property;
import org.fcrepo.server.types.gen.RelationshipTuple;
import org.fcrepo.server.types.gen.Validation;
import org.fcrepo.server.types.mtom.gen.GetDissemination;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypeUtility {
    private static final Logger logger = LoggerFactory.getLogger(TypeUtility.class);
    private static final int INITIAL_SIZE = 0x100000;
    private static final int BUFFER_SIZE = 1024;

    public static Datastream convertDatastreamToGenDatastream(org.fcrepo.server.storage.types.Datastream in) {
        if (in == null) {
            return null;
        }
        Datastream out = new Datastream();
        String group = in.DSControlGrp;
        out.setControlGroup(DatastreamControlGroup.fromValue((String)group));
        if ("R".equals(group) || "E".equals(group)) {
            out.setLocation(in.DSLocation);
        }
        out.setCreateDate(DateUtility.convertDateToString((Date)in.DSCreateDT));
        out.setID(in.DatastreamID);
        ArrayOfString altIDs = new ArrayOfString();
        if (in.DatastreamAltIDs != null) {
            altIDs.getItem().addAll(Arrays.asList(in.DatastreamAltIDs));
        }
        out.setAltIDs(altIDs);
        out.setLabel(in.DSLabel);
        out.setVersionable(in.DSVersionable);
        out.setMIMEType(in.DSMIME);
        out.setFormatURI(in.DSFormatURI);
        out.setSize(in.DSSize);
        out.setState(in.DSState);
        out.setVersionID(in.DSVersionID);
        out.setChecksum(in.DSChecksum);
        out.setChecksumType(in.DSChecksumType);
        return out;
    }

    public static org.fcrepo.server.types.gen.FieldSearchResult convertFieldSearchResultToGenFieldSearchResult(FieldSearchResult result) {
        if (result == null) {
            return null;
        }
        org.fcrepo.server.types.gen.FieldSearchResult ret = new org.fcrepo.server.types.gen.FieldSearchResult();
        ret.setResultList(TypeUtility.convertSearchObjectFieldsListToGenObjectFieldsArray(result.objectFieldsList()));
        if (result.getToken() != null) {
            ListSession sess = new ListSession();
            ObjectFactory factory = new ObjectFactory();
            sess.setToken(result.getToken());
            if (result.getCursor() > -1L) {
                sess.setCursor(new BigInteger("" + result.getCursor()));
            }
            if (result.getCompleteListSize() > -1L) {
                sess.setCompleteListSize(new BigInteger("" + result.getCompleteListSize()));
            }
            if (result.getExpirationDate() != null) {
                sess.setExpirationDate(factory.createListSessionExpirationDate(DateUtility.convertDateToString((Date)result.getExpirationDate())));
            }
            ret.setListSession(factory.createFieldSearchResultListSession(sess));
        }
        return ret;
    }

    public static org.fcrepo.server.search.FieldSearchQuery convertGenFieldSearchQueryToFieldSearchQuery(FieldSearchQuery gen) throws InvalidOperatorException, QueryParseException {
        if (gen == null) {
            return null;
        }
        if (gen.getTerms() != null) {
            return new org.fcrepo.server.search.FieldSearchQuery((String)gen.getTerms().getValue());
        }
        if (gen.getConditions() != null) {
            return new org.fcrepo.server.search.FieldSearchQuery(TypeUtility.convertGenConditionArrayToSearchConditionList((FieldSearchQuery.Conditions)gen.getConditions().getValue()));
        }
        return null;
    }

    public static List<Condition> convertGenConditionArrayToSearchConditionList(FieldSearchQuery.Conditions genConditions) throws InvalidOperatorException, QueryParseException {
        if (genConditions == null) {
            return null;
        }
        ArrayList<Condition> list = new ArrayList<Condition>();
        if (genConditions != null && genConditions.getCondition() != null) {
            for (org.fcrepo.server.types.gen.Condition c : genConditions.getCondition()) {
                list.add(new Condition(c.getProperty(), c.getOperator() != null ? c.getOperator().value() : null, c.getValue()));
            }
        }
        return list;
    }

    private static FieldSearchResult.ResultList convertSearchObjectFieldsListToGenObjectFieldsArray(List<ObjectFields> sfList) {
        if (sfList == null) {
            return null;
        }
        FieldSearchResult.ResultList genFields = new FieldSearchResult.ResultList();
        for (int i = 0; i < sfList.size(); ++i) {
            org.fcrepo.server.types.gen.ObjectFields gf = new org.fcrepo.server.types.gen.ObjectFields();
            ObjectFields sf = sfList.get(i);
            ObjectFactory factory = new ObjectFactory();
            if (sf.getPid() != null) {
                gf.setPid(factory.createObjectFieldsPid(sf.getPid()));
            }
            if (sf.getLabel() != null) {
                gf.setLabel(factory.createObjectFieldsLabel(sf.getLabel()));
            }
            if (sf.getState() != null) {
                gf.setState(factory.createObjectFieldsState(sf.getState()));
            }
            if (sf.getOwnerId() != null) {
                gf.setOwnerId(factory.createObjectFieldsOwnerId(sf.getOwnerId()));
            }
            if (sf.getCDate() != null) {
                gf.setCDate(factory.createObjectFieldsCDate(DateUtility.convertDateToString((Date)sf.getCDate())));
            }
            if (sf.getMDate() != null) {
                gf.setMDate(factory.createObjectFieldsMDate(DateUtility.convertDateToString((Date)sf.getMDate())));
            }
            if (sf.getDCMDate() != null) {
                gf.setDcmDate(factory.createObjectFieldsDcmDate(DateUtility.convertDateToString((Date)sf.getDCMDate())));
            }
            if (sf.titles().size() != 0) {
                gf.getTitle().addAll(TypeUtility.toStringList(sf.titles()));
            }
            if (sf.creators().size() != 0) {
                gf.getCreator().addAll(TypeUtility.toStringList(sf.creators()));
            }
            if (sf.subjects().size() != 0) {
                gf.getSubject().addAll(TypeUtility.toStringList(sf.subjects()));
            }
            if (sf.descriptions().size() != 0) {
                gf.getDescription().addAll(TypeUtility.toStringList(sf.descriptions()));
            }
            if (sf.publishers().size() != 0) {
                gf.getPublisher().addAll(TypeUtility.toStringList(sf.publishers()));
            }
            if (sf.contributors().size() != 0) {
                gf.getContributor().addAll(TypeUtility.toStringList(sf.contributors()));
            }
            if (sf.dates().size() != 0) {
                gf.getDate().addAll(TypeUtility.toStringList(sf.dates()));
            }
            if (sf.types().size() != 0) {
                gf.getType().addAll(TypeUtility.toStringList(sf.types()));
            }
            if (sf.formats().size() != 0) {
                gf.getFormat().addAll(TypeUtility.toStringList(sf.formats()));
            }
            if (sf.identifiers().size() != 0) {
                gf.getIdentifier().addAll(TypeUtility.toStringList(sf.identifiers()));
            }
            if (sf.sources().size() != 0) {
                gf.getSource().addAll(TypeUtility.toStringList(sf.sources()));
            }
            if (sf.languages().size() != 0) {
                gf.getLanguage().addAll(TypeUtility.toStringList(sf.languages()));
            }
            if (sf.relations().size() != 0) {
                gf.getRelation().addAll(TypeUtility.toStringList(sf.relations()));
            }
            if (sf.coverages().size() != 0) {
                gf.getCoverage().addAll(TypeUtility.toStringList(sf.coverages()));
            }
            if (sf.rights().size() != 0) {
                gf.getRights().addAll(TypeUtility.toStringList(sf.rights()));
            }
            genFields.getObjectFields().add(gf);
        }
        return genFields;
    }

    public static String[] toStringArray(List<DCField> l) {
        if (l == null) {
            return null;
        }
        String[] ret = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            ret[i] = l.get(i) != null ? l.get(i).getValue() : null;
        }
        return ret;
    }

    private static List<String> toStringList(List<DCField> dcFields) {
        if (dcFields == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>(dcFields.size());
        for (DCField dcField : dcFields) {
            ret.add(dcField != null ? dcField.getValue() : null);
        }
        return ret;
    }

    public static MethodParmDef convertMethodParmDefToGenMethodParmDef(org.fcrepo.server.storage.types.MethodParmDef methodParmDef) {
        if (methodParmDef != null) {
            MethodParmDef genMethodParmDef = new MethodParmDef();
            genMethodParmDef.setParmName(methodParmDef.parmName);
            genMethodParmDef.setParmLabel(methodParmDef.parmLabel);
            genMethodParmDef.setParmDefaultValue(methodParmDef.parmDefaultValue);
            ArrayOfString parmDomainVals = new ArrayOfString();
            if (methodParmDef.parmDomainValues != null) {
                parmDomainVals.getItem().addAll(Arrays.asList(methodParmDef.parmDomainValues));
            }
            genMethodParmDef.setParmDomainValues(parmDomainVals);
            genMethodParmDef.setParmRequired(methodParmDef.parmRequired);
            genMethodParmDef.setParmType(methodParmDef.parmType);
            genMethodParmDef.setParmPassBy(methodParmDef.parmPassBy);
            return genMethodParmDef;
        }
        return null;
    }

    public static org.fcrepo.server.types.gen.MIMETypedStream convertMIMETypedStreamToGenMIMETypedStream(MIMETypedStream mimeTypedStream) {
        if (mimeTypedStream != null) {
            org.fcrepo.server.types.gen.MIMETypedStream genMIMETypedStream = new org.fcrepo.server.types.gen.MIMETypedStream();
            genMIMETypedStream.setMIMEType(mimeTypedStream.MIMEType);
            org.fcrepo.server.storage.types.Property[] header = mimeTypedStream.header;
            MIMETypedStream.Header head = new MIMETypedStream.Header();
            if (header != null) {
                for (org.fcrepo.server.storage.types.Property property : header) {
                    head.getProperty().add(TypeUtility.convertPropertyToGenProperty(property));
                }
            }
            genMIMETypedStream.setHeader(head);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            InputStream is = mimeTypedStream.getStream();
            int byteStream = 0;
            try {
                byte[] buffer = new byte[255];
                while ((byteStream = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, byteStream);
                }
            }
            catch (IOException ioe) {
                logger.error("Error converting types", (Throwable)ioe);
            }
            genMIMETypedStream.setStream(baos.toByteArray());
            mimeTypedStream.close();
            mimeTypedStream.setStream(new ByteArrayInputStream(baos.toByteArray()));
            return genMIMETypedStream;
        }
        return null;
    }

    public static org.fcrepo.server.types.mtom.gen.MIMETypedStream convertMIMETypedStreamToGenMIMETypedStreamMTOM(MIMETypedStream mimeTypedStream) {
        if (mimeTypedStream != null) {
            org.fcrepo.server.types.mtom.gen.MIMETypedStream genMIMETypedStream = new org.fcrepo.server.types.mtom.gen.MIMETypedStream();
            genMIMETypedStream.setMIMEType(mimeTypedStream.MIMEType);
            org.fcrepo.server.storage.types.Property[] header = mimeTypedStream.header;
            MIMETypedStream.Header head = new MIMETypedStream.Header();
            if (header != null) {
                for (org.fcrepo.server.storage.types.Property property : header) {
                    head.getProperty().add(TypeUtility.convertPropertyToGenProperty(property));
                }
            }
            genMIMETypedStream.setHeader(head);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            InputStream is = mimeTypedStream.getStream();
            int byteStream = 0;
            try {
                byte[] buffer = new byte[255];
                while ((byteStream = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, byteStream);
                }
            }
            catch (IOException ioe) {
                logger.error("Error converting types", (Throwable)ioe);
            }
            genMIMETypedStream.setStream(new DataHandler((DataSource)new ByteArrayDataSource(baos.toByteArray(), "text/html")));
            mimeTypedStream.close();
            mimeTypedStream.setStream(new ByteArrayInputStream(baos.toByteArray()));
            return genMIMETypedStream;
        }
        return null;
    }

    public static List<ObjectMethodsDef> convertObjectMethodsDefArrayToGenObjectMethodsDefList(org.fcrepo.server.storage.types.ObjectMethodsDef[] objectMethodDefs) {
        if (objectMethodDefs != null) {
            ArrayList<ObjectMethodsDef> genObjectMethodDefs = new ArrayList<ObjectMethodsDef>(objectMethodDefs.length);
            for (org.fcrepo.server.storage.types.ObjectMethodsDef objectMethodsDef : objectMethodDefs) {
                ObjectMethodsDef genObjectMethodDef = new ObjectMethodsDef();
                genObjectMethodDef.setPID(objectMethodsDef.PID);
                genObjectMethodDef.setServiceDefinitionPID(objectMethodsDef.sDefPID);
                genObjectMethodDef.setMethodName(objectMethodsDef.methodName);
                org.fcrepo.server.storage.types.MethodParmDef[] methodParmDefs = objectMethodsDef.methodParmDefs;
                ObjectMethodsDef.MethodParmDefs genMethodParmDefs = new ObjectMethodsDef.MethodParmDefs();
                if (methodParmDefs != null) {
                    for (org.fcrepo.server.storage.types.MethodParmDef methodParmDef : methodParmDefs) {
                        genMethodParmDefs.getMethodParmDef().add(TypeUtility.convertMethodParmDefToGenMethodParmDef(methodParmDef));
                    }
                }
                genObjectMethodDef.setMethodParmDefs(genMethodParmDefs);
                genObjectMethodDefs.add(genObjectMethodDef);
            }
            return genObjectMethodDefs;
        }
        return null;
    }

    public static ObjectProfile convertObjectProfileToGenObjectProfile(org.fcrepo.server.access.ObjectProfile objectProfile) {
        if (objectProfile != null) {
            ObjectProfile genObjectProfile = new ObjectProfile();
            genObjectProfile.setPid(objectProfile.PID);
            genObjectProfile.setObjLabel(objectProfile.objectLabel);
            ObjectProfile.ObjModels objModels = new ObjectProfile.ObjModels();
            if (objectProfile.objectModels != null) {
                objModels.getModel().addAll(objectProfile.objectModels);
            }
            genObjectProfile.setObjModels(objModels);
            genObjectProfile.setObjCreateDate(DateUtility.convertDateToString((Date)objectProfile.objectCreateDate));
            genObjectProfile.setObjLastModDate(DateUtility.convertDateToString((Date)objectProfile.objectLastModDate));
            genObjectProfile.setObjDissIndexViewURL(objectProfile.dissIndexViewURL);
            genObjectProfile.setObjItemIndexViewURL(objectProfile.itemIndexViewURL);
            return genObjectProfile;
        }
        return null;
    }

    public static org.fcrepo.server.types.gen.RepositoryInfo convertReposInfoToGenReposInfo(RepositoryInfo repositoryInfo) {
        if (repositoryInfo != null) {
            ArrayOfString val;
            org.fcrepo.server.types.gen.RepositoryInfo genRepositoryInfo = new org.fcrepo.server.types.gen.RepositoryInfo();
            genRepositoryInfo.setRepositoryName(repositoryInfo.repositoryName);
            genRepositoryInfo.setRepositoryBaseURL(repositoryInfo.repositoryBaseURL);
            genRepositoryInfo.setRepositoryVersion(repositoryInfo.repositoryVersion);
            genRepositoryInfo.setRepositoryPIDNamespace(repositoryInfo.repositoryPIDNamespace);
            genRepositoryInfo.setDefaultExportFormat(repositoryInfo.defaultExportFormat);
            genRepositoryInfo.setOAINamespace(repositoryInfo.OAINamespace);
            if (repositoryInfo.adminEmailList != null) {
                val = new ArrayOfString();
                val.getItem().addAll(Arrays.asList(repositoryInfo.adminEmailList));
                genRepositoryInfo.setAdminEmailList(val);
            }
            genRepositoryInfo.setSamplePID(repositoryInfo.samplePID);
            genRepositoryInfo.setSampleOAIIdentifier(repositoryInfo.sampleOAIIdentifer);
            genRepositoryInfo.setSampleSearchURL(repositoryInfo.sampleSearchURL);
            genRepositoryInfo.setSampleAccessURL(repositoryInfo.sampleAccessURL);
            genRepositoryInfo.setSampleOAIURL(repositoryInfo.sampleOAIURL);
            if (repositoryInfo.retainPIDs != null) {
                val = new ArrayOfString();
                val.getItem().addAll(Arrays.asList(repositoryInfo.retainPIDs));
                genRepositoryInfo.setRetainPIDs(val);
            }
            return genRepositoryInfo;
        }
        return null;
    }

    public static org.fcrepo.server.storage.types.Property[] convertGenPropertyArrayToPropertyArray(GetDissemination.Parameters genProperties) {
        if (genProperties != null) {
            org.fcrepo.server.storage.types.Property[] properties = new org.fcrepo.server.storage.types.Property[genProperties.getParameter() == null ? 0 : genProperties.getParameter().size()];
            int i = 0;
            for (Property prop : genProperties.getParameter()) {
                org.fcrepo.server.storage.types.Property property = new org.fcrepo.server.storage.types.Property();
                property = TypeUtility.convertGenPropertyToProperty(prop);
                properties[i++] = property;
            }
            return properties;
        }
        return null;
    }

    public static org.fcrepo.server.storage.types.Property[] convertGenPropertyArrayToPropertyArray(GetDissemination.Parameters genProperties) {
        if (genProperties != null) {
            org.fcrepo.server.storage.types.Property[] properties = new org.fcrepo.server.storage.types.Property[genProperties.getParameter() == null ? 0 : genProperties.getParameter().size()];
            int i = 0;
            for (Property prop : genProperties.getParameter()) {
                org.fcrepo.server.storage.types.Property property = new org.fcrepo.server.storage.types.Property();
                property = TypeUtility.convertGenPropertyToProperty(prop);
                properties[i++] = property;
            }
            return properties;
        }
        return null;
    }

    public static org.fcrepo.server.storage.types.Property convertGenPropertyToProperty(Property genProperty) {
        org.fcrepo.server.storage.types.Property property = new org.fcrepo.server.storage.types.Property();
        if (genProperty != null) {
            property.name = genProperty.getName();
            property.value = genProperty.getValue();
        }
        return property;
    }

    public static Property convertPropertyToGenProperty(org.fcrepo.server.storage.types.Property property) {
        Property genProperty = new Property();
        if (property != null) {
            genProperty.setName(property.name);
            genProperty.setValue(property.value);
        }
        return genProperty;
    }

    public static RelationshipTuple convertRelsTupleToGenRelsTuple(org.fcrepo.server.storage.types.RelationshipTuple in) {
        if (in == null) {
            return null;
        }
        RelationshipTuple out = new RelationshipTuple();
        out.setSubject(in.subject);
        out.setPredicate(in.predicate);
        out.setObject(in.object);
        out.setIsLiteral(in.isLiteral);
        if (in.datatype == null) {
            out.setDatatype(null);
        } else {
            out.setDatatype(in.datatype.toString());
        }
        return out;
    }

    public static DatastreamDef convertDatastreamDefToGenDatastreamDef(org.fcrepo.server.storage.types.DatastreamDef in) {
        if (in == null) {
            return null;
        }
        DatastreamDef out = new DatastreamDef();
        out.setID(in.dsID);
        out.setLabel(in.dsLabel);
        out.setMIMEType(in.dsMIME);
        return out;
    }

    public static List<DatastreamDef> convertDatastreamDefArrayToGenDatastreamDefList(org.fcrepo.server.storage.types.DatastreamDef[] dsDefs) {
        if (dsDefs != null) {
            ArrayList<DatastreamDef> genDatastreamDefs = new ArrayList<DatastreamDef>(dsDefs.length);
            for (org.fcrepo.server.storage.types.DatastreamDef dsDef : dsDefs) {
                genDatastreamDefs.add(TypeUtility.convertDatastreamDefToGenDatastreamDef(dsDef));
            }
            return genDatastreamDefs;
        }
        return null;
    }

    public static org.fcrepo.server.types.gen.Validation convertValidationToGenValidation(Validation validation) {
        if (validation == null) {
            return null;
        }
        org.fcrepo.server.types.gen.Validation genvalid = new org.fcrepo.server.types.gen.Validation();
        genvalid.setValid(validation.isValid());
        genvalid.setPid(validation.getPid());
        Validation.ObjModels objModels = new Validation.ObjModels();
        objModels.getModel().addAll(validation.getContentModels());
        genvalid.setObjModels(objModels);
        Validation.ObjProblems objProblems = new Validation.ObjProblems();
        objProblems.getProblem().addAll(validation.getObjectProblems());
        genvalid.setObjProblems(objProblems);
        Map<String, List<String>> dsprobs = validation.getDatastreamProblems();
        Validation.DatastreamProblems problems = new Validation.DatastreamProblems();
        if (dsprobs != null) {
            for (String key : dsprobs.keySet()) {
                DatastreamProblem dsProblem = new DatastreamProblem();
                dsProblem.setDatastreamID(key);
                dsProblem.getProblem().addAll((Collection)dsprobs.get(key));
                problems.getDatastream().add(dsProblem);
            }
        }
        genvalid.setDatastreamProblems(problems);
        return genvalid;
    }

    public static byte[] convertDataHandlerToBytes(DataHandler dh) {
        if (dh != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(0x100000);
            try {
                int bytesRead;
                InputStream in = dh.getInputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) >= 0) {
                    bos.write(buffer, 0, bytesRead);
                }
                return bos.toByteArray();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static DataHandler convertBytesToDataHandler(byte[] content) {
        if (content != null) {
            return new DataHandler((DataSource)new ByteArrayDataSource(content, "text/xml"));
        }
        return null;
    }

    public static ArrayOfString convertStringtoAOS(String[] arr) {
        if (arr != null) {
            ArrayOfString arofs = new ArrayOfString();
            arofs.getItem().addAll(Arrays.asList(arr));
            return arofs;
        }
        return null;
    }
}

