/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities.rebuild;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ConnectionPoolNotFoundException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.management.PIDGenerator;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.fcrepo.server.storage.DefaultDOManager;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.server.validation.DOValidator;

public class RebuildDOManager
extends DefaultDOManager {
    public RebuildDOManager(Map moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    protected void initRetainPID() {
        this.m_retainPIDs = null;
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        this.m_contentManager = (ExternalContentManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ExternalContentManager"));
        if (this.m_contentManager == null) {
            throw new ModuleInitializationException("ExternalContentManager not loaded.", this.getRole());
        }
        this.m_fieldSearch = (FieldSearch)((Object)this.getServer().getModule("org.fcrepo.server.search.FieldSearch"));
        this.m_pidGenerator = (PIDGenerator)((Object)this.getServer().getModule("org.fcrepo.server.management.PIDGenerator"));
        this.m_translator = (DOTranslator)((Object)this.getServer().getModule("org.fcrepo.server.storage.translation.DOTranslator"));
        this.m_validator = (DOValidator)((Object)this.getServer().getModule("org.fcrepo.server.validation.DOValidator"));
        if (this.m_validator == null) {
            throw new ModuleInitializationException("DOValidator not loaded.", this.getRole());
        }
        ConnectionPoolManager cpm = (ConnectionPoolManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ConnectionPoolManager"));
        if (cpm == null) {
            throw new ModuleInitializationException("ConnectionPoolManager not loaded.", this.getRole());
        }
        try {
            this.m_connectionPool = this.m_storagePool == null ? cpm.getPool() : cpm.getPool(this.m_storagePool);
        }
        catch (ConnectionPoolNotFoundException cpnfe) {
            String storagePool = this.m_storagePool == null ? "[null]" : this.m_storagePool;
            throw new ModuleInitializationException("Couldn't get required connection pool " + storagePool + " ...wasn't found", this.getRole());
        }
        try {
            String dbSpec = "org/fcrepo/server/storage/resources/DefaultDOManager.dbspec";
            InputStream specIn = this.getClass().getClassLoader().getResourceAsStream(dbSpec);
            if (specIn == null) {
                throw new IOException("Cannot find required resource: " + dbSpec);
            }
            SQLUtility.createNonExistingTables(this.m_connectionPool, specIn);
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Error checking for and creating non-existing tables", this.getRole(), e);
        }
        this.m_permanentStore = (ILowlevelStorage)((Object)this.getServer().getModule("org.fcrepo.server.storage.lowlevel.ILowlevelStorage"));
        if (this.m_permanentStore == null) {
            throw new ModuleInitializationException("LowlevelStorage not loaded", this.getRole());
        }
    }
}

