/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities.rebuild;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.fcrepo.server.Server;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerInitializationException;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.trippi.TriplestoreConnector;
import org.w3c.dom.Element;

public class RebuildServer
extends Server {
    public static String[] REBUILDERS = new String[]{"org.fcrepo.server.resourceIndex.ResourceIndexRebuilder", "org.fcrepo.server.utilities.rebuild.SQLRebuilder", "org.fcrepo.server.security.xacml.pdp.data.PolicyIndexRebuilder"};

    public RebuildServer(Element rootConfigElement, File homeDir) throws ServerInitializationException, ModuleInitializationException {
        super(rootConfigElement, homeDir);
    }

    protected RebuildServer(File homeDir) throws ServerInitializationException, ModuleInitializationException {
        super(homeDir);
    }

    @Override
    protected void registerBeanDefinitions() throws ServerInitializationException {
        DatastoreConfiguration dsConfig;
        String ds;
        ServerConfiguration sc = RebuildServer.getConfig();
        ModuleConfiguration rim = sc.getModuleConfiguration(ResourceIndex.class.getName());
        if (rim != null && (ds = rim.getParameter("datastore")) != null && (dsConfig = sc.getDatastoreConfiguration(ds)) != null) {
            try {
                String name = TriplestoreConnector.class.getName();
                GenericBeanDefinition beanDefinition = Server.getTriplestoreConnectorBeanDefinition(dsConfig);
                beanDefinition.setAttribute("name", (Object)name);
                beanDefinition.setAttribute("id", (Object)name);
                this.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            }
            catch (IOException e) {
                throw new ServerInitializationException(e.toString(), e);
            }
        }
        for (String rebuilder : REBUILDERS) {
            try {
                ScannedGenericBeanDefinition beanDefinition = Server.getScannedBeanDefinition(rebuilder);
                beanDefinition.setAutowireCandidate(true);
                beanDefinition.setAutowireMode(1);
                beanDefinition.setAttribute("id", (Object)rebuilder);
                beanDefinition.setAttribute("name", (Object)rebuilder);
                beanDefinition.setInitMethodName("init");
                beanDefinition.setScope("singleton");
                beanDefinition.setDependencyCheck(0);
                this.registerBeanDefinition(rebuilder, (BeanDefinition)beanDefinition);
            }
            catch (IOException e) {
                throw new ServerInitializationException(e.toString(), e);
            }
        }
    }

    @Override
    protected boolean overrideModuleRole(String moduleRole) {
        return "org.fcrepo.server.security.Authorization".equals(moduleRole) || "org.fcrepo.server.access.Access".equals(moduleRole) || "org.fcrepo.server.access.DynamicAccess".equals(moduleRole) || "org.fcrepo.oai.OAIProvider".equals(moduleRole) || "org.fcrepo.oai.OAIProvider".equals(moduleRole) || "org.fcrepo.server.management.Management".equals(moduleRole) || "org.fcrepo.server.resourceIndex.ResourceIndex".equals(moduleRole);
    }

    @Override
    protected String overrideModuleClass(String moduleClass) {
        if (moduleClass != null && moduleClass.endsWith("DOManager")) {
            return "org.fcrepo.server.utilities.rebuild.RebuildDOManager";
        }
        return null;
    }

    public static final Server getRebuildInstance(File homeDir) throws ServerInitializationException, ModuleInitializationException {
        String className = "org.fcrepo.server.utilities.rebuild.RebuildServer";
        try {
            RebuildServer inst = new RebuildServer(homeDir);
            s_instances.put(homeDir, inst);
            inst.init();
            return inst;
        }
        catch (IllegalArgumentException iae) {
            throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_BADARGS, className));
        }
    }
}

